jQuery(document).ready(function ($) {
    function showLoader() {
        return '<div class="spinner loader load"></div>';
    }
    function updateCart() {
        $('.cart-mini-products').html(showLoader());

        $.ajax({
            url: lamkadeh_ajax_obj.ajax_url,
            type: "POST",
            data: {
                action: 'get_cart_data',
                _ajax_nonce: lamkadeh_ajax_obj.nonce
            },
            success: function (res) {
                if (res.success) {
                    $('.header-bottom-left-cart-badge-counter span').text(res.data.count);
                    $('.header-bottom-left-cart-data span:last').html(res.data.subtotal + " تومان");
                    $('.price-header-bottom-left-cart-popup').html(res.data.total);
                    let html = '';
                    if (res.data.items.length > 0) {
                        res.data.items.forEach(function (item) {
                            let priceBlock = '';
                            if (item.discount_percentage) {
                                priceBlock = `
                                    <div class="price-sales-off">
                                        <div class="badge">%${item.discount_percentage}</div>
                                        ${item.regular_price_html} <span></span> 
                                    </div>
                                    <div class="price-regular">
                                        <span>تــــو مان</span>
                                        <span>${item.sale_price_html}</span>
                                    </div>`;
                            } else {
                                priceBlock = `
                                    <div class="price-regular">
                                        <span>${item.price_html}</span>
                                    </div>`;
                            }
                            html += `
                            <div class="cart-mini-detail-product" data-cart-key="${item.cart_item_key}">
                                <div class="cart-mini-detail-image-product">
                                    <div class="remove-item" data-key="${item.cart_item_key}">
                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 1L13 13M13 1L1 13" stroke="white" stroke-width="2" stroke-linecap="round"/>
                                        </svg>
                                    </div>
                                    <img src="${item.img}" alt="${item.title}" />
                                </div>
                                <a href="${item.product_url}" class="cart-mini-product-details">
                                    <h5>${item.title}</h5>
                                    <div class="cart-mini-detail-product-underline"></div>
                                    <div class="cart-mini-detail-product-meta">
                                        <div class="cart-mini-detail-quantity">
                                            <button class="plus" data-key="${item.cart_item_key}">
                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6 10V6M6 6V2M6 6H10M6 6H2" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </button>
                                            <input type="text" value="${item.qty}" min="1" max="100" readonly />
                                            <button class="mines" data-key="${item.cart_item_key}">
                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M10 6H2" stroke="#1D2977" stroke-opacity="0.5" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                            </button>
                                        </div>
                                        <div class="cart-mini-detail-amount">
                                            ${priceBlock}
                                        </div>
                                    </div>
                                </a>
                            </div>`;
                        });
                    } else {
                        html = '<div class="cart-empty">سبد خرید خالی است</div>';
                    }
                    $('.cart-mini-products').html(html);
                }
            },
            error: function () {
                $('.cart-mini-products').html('<div class="cart-error">خطا در بارگذاری سبد خرید</div>');
            }
        });
    }
    updateCart();
    $(document).on('click', '.plus', function (e) {
        e.preventDefault();
        let key = $(this).data('key');
        let input = $(this).siblings('input');
        let qty = parseInt(input.val()) + 1;
        $.ajax({
            url: lamkadeh_ajax_obj.ajax_url,
            type: "POST",
            data: {
                action: 'update_cart_item',
                key: key,
                qty: qty,
                _ajax_nonce: lamkadeh_ajax_obj.nonce
            },
            success: function () {
                updateCart();
            },
            error: function () {
                alert('خطا در به‌روزرسانی سبد خرید');
            }
        });
    });
    $(document).on('click', '.mines', function (e) {
        e.preventDefault();
        let key = $(this).data('key');
        let input = $(this).siblings('input');
        let qty = parseInt(input.val()) - 1;
        if (qty < 1) qty = 1;
        $.ajax({
            url: lamkadeh_ajax_obj.ajax_url,
            type: "POST",
            data: {
                action: 'update_cart_item',
                key: key,
                qty: qty,
                _ajax_nonce: lamkadeh_ajax_obj.nonce
            },
            success: function () {
                updateCart();
            },
            error: function () {
                alert('خطا در به‌روزرسانی سبد خرید');
            }
        });
    });
    $(document).on('click', '.remove-item', function (e) {
        e.preventDefault();
        let key = $(this).data('key');
        $.ajax({
            url: lamkadeh_ajax_obj.ajax_url,
            type: "POST",
            data: {
                action: 'remove_cart_item',
                key: key,
                _ajax_nonce: lamkadeh_ajax_obj.nonce
            },
            success: function () {
                updateCart();
            },
            error: function () {
                alert('خطا در حذف محصول از سبد خرید');
            }
        });
    });
    $('.header-bottom-left-cart-icon, .header-bottom-left-cart-data').on('click', function (e) {
        e.preventDefault();
        $('.header-bottom-left-cart-popup, .overly-header-bottom-left-cart-popup').toggleClass('active');
    });
    $('.overly-header-bottom-left-cart-popup').on('click', function () {
        $('.header-bottom-left-cart-popup, .overly-header-bottom-left-cart-popup').removeClass('active');
    });
    $(document.body).on('added_to_cart removed_from_cart updated_cart_totals', function () {
        updateCart();
    });
});

jQuery(document).ready(function ($) {
    function updateCartCount() {
        $.ajax({
            url: lamkadeh_ajax_obj.ajax_url,
            type: "POST",
            data: { action: 'get_cart_count' },
            success: function (res) {
                if (res.success) {
                    let count = res.data.count;
                    if (count > 0) {
                        $(".cart-mini-responsive-counter span").text(count);
                    } else {
                        $(".cart-mini-responsive-counter span").text("0");
                    }
                }
            }
        });
    }
    updateCartCount();
    $(document.body).on("added_to_cart removed_from_cart updated_wc_div", function () {
        updateCartCount();
    });
});
