jQuery(document).ready(function($) {
    loadUpdates();
    
    $('#refresh_updates').on('click', function() {
        loadUpdates();
    });
    
    $('.filter-btn').on('click', function() {
        $('.filter-btn').removeClass('active');
        $(this).addClass('active');
        
        const filter = $(this).data('filter');
        filterUpdates(filter);
    });
    
    function loadUpdates() {
        const apiUrl = $('#api_url_input').val();
        
        $('#updates_container').html(`
            <div class="loading-spinner">
                <div class="spinner"></div>
                <p>${smartHub.i18n.loading}</p>
            </div>
        `);
        
        $.ajax({
            url: smartHub.ajaxurl,
            type: 'POST',
            data: {
                action: 'get_theme_updates',
                nonce: smartHub.nonce,
                api_url: apiUrl
            },
            success: function(response) {
                if (response.success) {
                    $('#updates_container').html(response.data.updates);
                    $('#banners_container').html(response.data.banners);
                } else {
                    $('#updates_container').html(`
                        <div class="no-updates">
                            <p>${smartHub.i18n.errorFetch}: ${response.data}</p>
                        </div>
                    `);
                }
            },
            error: function() {
                $('#updates_container').html(`
                    <div class="no-updates">
                        <p>${smartHub.i18n.serverError}</p>
                    </div>
                `);
            }
        });
    }
    
    function filterUpdates(filter) {
        if (filter === 'all') {
            $('.update-card').show();
        } else {
            $('.update-card').hide();
            $(`.update-card[data-status="${filter}"]`).show();
        }
    }
});