<?php

function lamkadeh_admin_editor_assets($hook)
{
    wp_enqueue_code_editor(array('type' => 'text/html'));
    wp_enqueue_script('wp-theme-plugin-editor');
    wp_enqueue_style('wp-codemirror');
}
add_action('admin_enqueue_scripts', 'lamkadeh_admin_editor_assets');

function custom_code()
{
?>
    <div class="wrap">
        <label for="custom_head"><?php echo __("کدهای HTML یا Head:", "lamkadeh"); ?></label>
        <textarea id="custom_head" name="custom_head" rows="10" class="widefat code-editor"><?php echo esc_textarea(get_option("custom_head")); ?></textarea>
    </div>

    <div class="wrap">
        <label for="custom_css"><?php echo __("کدهای CSS:", "lamkadeh"); ?></label>
        <textarea id="custom_css" name="custom_css" rows="10" class="widefat code-editor"><?php echo esc_textarea(get_option("custom_css")); ?></textarea>
    </div>

    <div class="wrap">
        <label for="custom_js"><?php echo __("کدهای JavaScript:", "lamkadeh"); ?></label>
        <textarea id="custom_js" name="custom_js" rows="10" class="widefat code-editor"><?php echo esc_textarea(get_option("custom_js")); ?></textarea>
    </div>

    <script>
        jQuery(document).ready(function($) {
            const editorConfig = {
                codemirror: {
                    lineNumbers: true,
                    theme: 'dracula',
                    indentUnit: 4,
                    autoCloseBrackets: true,
                    matchBrackets: true,
                    autoCloseTags: true,
                    foldGutter: true,
                    gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
                    extraKeys: {
                        "F11": function(cm) {
                            cm.setOption("fullScreen", !cm.getOption("fullScreen"));
                        },
                        "Esc": function(cm) {
                            if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
                        },
                        "Ctrl-Space": "autocomplete",
                        "Ctrl-/": "toggleComment"
                    },
                    hintOptions: {
                        completeSingle: false
                    },
                    viewportMargin: Infinity,
                    lineWrapping: true,
                    scrollbarStyle: 'simple'
                }
            };

            if (wp.codeEditor) {
                window.headEditor = wp.codeEditor.initialize('custom_head', {
                    ...editorConfig,
                    codemirror: {
                        ...editorConfig.codemirror,
                        mode: 'htmlmixed'
                    }
                });

                window.cssEditor = wp.codeEditor.initialize('custom_css', {
                    ...editorConfig,
                    codemirror: {
                        ...editorConfig.codemirror,
                        mode: 'css'
                    }
                });

                window.jsEditor = wp.codeEditor.initialize('custom_js', {
                    ...editorConfig,
                    codemirror: {
                        ...editorConfig.codemirror,
                        mode: 'javascript'
                    }
                });
            }
        });
    </script>

<?php
}

function add_custom_code_to_site()
{
    $custom_head = get_option('custom_head', '');
    if (!empty($custom_head)) {
        echo $custom_head;
    }

    $custom_css = get_option('custom_css', '');
    if (!empty($custom_css)) {
        echo '<style id="theme-custom-css">' . $custom_css . '</style>';
    }

    $custom_js = get_option('custom_js', '');
    if (!empty($custom_js)) {
        echo '<script id="theme-custom-js">' . $custom_js . '</script>';
    }
}
add_action('wp_head', 'add_custom_code_to_site', 100);
add_action('wp_footer', 'add_custom_code_to_site', 100);
