<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class BoxSingleData extends Widget_Base
{
    public function get_name()
    {
        return 'BoxSingleData';
    }

    public function get_title()
    {
        return __('جدول دیتای صفحه مقاله', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-document';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('تنظیمات دیتا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (!function_exists('jdate')) {
            require_once(get_template_directory() . "/includes/date-convertor-shamsi/jdf.php");
        }
        $views = get_post_meta(get_the_ID(), 'lamkadeh_post_views_count', true);
        if (!$views)
            $views = 0;

        ?>
        <section class="header-view-order">
            <div class="header-view-order-wrapper">

                <div class="header-view-order-item">
                    <div class="header-view-order-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z"
                                stroke="white" stroke-width="1.5" />
                            <path
                                d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z"
                                stroke="#1D2977" stroke-width="1.5" />
                        </svg>
                    </div>
                    <div class="header-view-order-content">
                        <div class="header-view-order-content-text">
                            <?php echo esc_html($views);
                            echo __("بازدید", "lamkadeh") ?></div>
                        <span><?php _e("تعداد بازدید", "lamkadeh"); ?></span>
                    </div>
                </div>

                <div class="header-view-order-item">
                    <div class="header-view-order-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M3 10C3 6.22876 3 4.34315 4.17157 3.17157C5.34315 2 7.22876 2 11 2H13C16.7712 2 18.6569 2 19.8284 3.17157C21 4.34315 21 6.22876 21 10V14C21 17.7712 21 19.6569 19.8284 20.8284C18.6569 22 16.7712 22 13 22H11C7.22876 22 5.34315 22 4.17157 20.8284C3 19.6569 3 17.7712 3 14V10Z"
                                stroke="white" stroke-width="1.5" />
                            <path
                                d="M18.18 8.03933L18.6435 7.57589C19.4113 6.80804 20.6563 6.80804 21.4241 7.57589C22.192 8.34374 22.192 9.58868 21.4241 10.3565L20.9607 10.82M18.18 8.03933C18.18 8.03933 18.238 9.02414 19.1069 9.89309C19.9759 10.762 20.9607 10.82 20.9607 10.82M18.18 8.03933L13.9194 12.2999C13.6308 12.5885 13.4865 12.7328 13.3624 12.8919C13.2161 13.0796 13.0906 13.2827 12.9882 13.4975C12.9014 13.6797 12.8368 13.8732 12.7078 14.2604L12.2946 15.5L12.1609 15.901M20.9607 10.82L16.7001 15.0806C16.4115 15.3692 16.2672 15.5135 16.1081 15.6376C15.9204 15.7839 15.7173 15.9094 15.5025 16.0118C15.3203 16.0986 15.1268 16.1632 14.7396 16.2922L13.5 16.7054L13.099 16.8391M13.099 16.8391L12.6979 16.9728C12.5074 17.0363 12.2973 16.9867 12.1553 16.8447C12.0133 16.7027 11.9637 16.4926 12.0272 16.3021L12.1609 15.901M13.099 16.8391L12.1609 15.901"
                                stroke="#1D2977" stroke-width="1.5" />
                            <path d="M8 13H10.5" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" />
                            <path d="M8 9H14.5" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" />
                            <path d="M8 17H9.5" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" />
                        </svg>
                    </div>
                    <div class="header-view-order-content">
                        <div class="header-view-order-content-text"><?php the_author(); ?></div>
                        <span><?php _e("نگارنده", "lamkadeh"); ?></span>
                    </div>
                </div>

                <!-- وضعیت پرداخت -->
                <div class="header-view-order-item">
                    <div class="header-view-order-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M2.5 6.5C2.5 4.29086 4.29086 2.5 6.5 2.5C8.70914 2.5 10.5 4.29086 10.5 6.5C10.5 8.70914 8.70914 10.5 6.5 10.5C4.29086 10.5 2.5 8.70914 2.5 6.5Z"
                                stroke="#1D2977" stroke-width="1.5" />
                            <path
                                d="M13.5 17.5C13.5 15.2909 15.2909 13.5 17.5 13.5C19.7091 13.5 21.5 15.2909 21.5 17.5C21.5 19.7091 19.7091 21.5 17.5 21.5C15.2909 21.5 13.5 19.7091 13.5 17.5Z"
                                stroke="white" stroke-width="1.5" />
                            <path
                                d="M2.5 17.5C2.5 15.6144 2.5 14.6716 3.08579 14.0858C3.67157 13.5 4.61438 13.5 6.5 13.5C8.38562 13.5 9.32843 13.5 9.91421 14.0858C10.5 14.6716 10.5 15.6144 10.5 17.5C10.5 19.3856 10.5 20.3284 9.91421 20.9142C9.32843 21.5 8.38562 21.5 6.5 21.5C4.61438 21.5 3.67157 21.5 3.08579 20.9142C2.5 20.3284 2.5 19.3856 2.5 17.5Z"
                                stroke="#1D2977" stroke-width="1.5" />
                            <path
                                d="M13.5 6.5C13.5 4.61438 13.5 3.67157 14.0858 3.08579C14.6716 2.5 15.6144 2.5 17.5 2.5C19.3856 2.5 20.3284 2.5 20.9142 3.08579C21.5 3.67157 21.5 4.61438 21.5 6.5C21.5 8.38562 21.5 9.32843 20.9142 9.91421C20.3284 10.5 19.3856 10.5 17.5 10.5C15.6144 10.5 14.6716 10.5 14.0858 9.91421C13.5 9.32843 13.5 8.38562 13.5 6.5Z"
                                stroke="white" stroke-width="1.5" />
                        </svg>
                    </div>
                    <div class="header-view-order-content">
                        <div class="header-view-order-content-text">
                            <?php
                            $categories = get_the_category();
                            if (!empty($categories)) {
                                foreach ($categories as $category) {
                                    if ($category->parent == 0) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a>';
                                        break;
                                    }
                                }
                            }
                            ?>
                        </div>
                        <span><?php _e("دسته بندی", "lamkadeh"); ?></span>
                    </div>
                </div>

                <div class="header-view-order-item">
                    <div class="header-view-order-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 4V2.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
                            <path d="M17 4V2.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
                            <path d="M2.5 9H21.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
                            <path
                                d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12V14C22 17.7712 22 19.6569 20.8284 20.8284C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V12Z"
                                stroke="#1D2977" stroke-width="1.5" />
                            <path
                                d="M18 17C18 17.5523 17.5523 18 17 18C16.4477 18 16 17.5523 16 17C16 16.4477 16.4477 16 17 16C17.5523 16 18 16.4477 18 17Z"
                                fill="#1D2977" />
                            <path
                                d="M18 13C18 13.5523 17.5523 14 17 14C16.4477 14 16 13.5523 16 13C16 12.4477 16.4477 12 17 12C17.5523 12 18 12.4477 18 13Z"
                                fill="#1D2977" />
                            <path
                                d="M13 17C13 17.5523 12.5523 18 12 18C11.4477 18 11 17.5523 11 17C11 16.4477 11.4477 16 12 16C12.5523 16 13 16.4477 13 17Z"
                                fill="#1D2977" />
                            <path
                                d="M13 13C13 13.5523 12.5523 14 12 14C11.4477 14 11 13.5523 11 13C11 12.4477 11.4477 12 12 12C12.5523 12 13 12.4477 13 13Z"
                                fill="#1D2977" />
                            <path
                                d="M8 17C8 17.5523 7.55228 18 7 18C6.44772 18 6 17.5523 6 17C6 16.4477 6.44772 16 7 16C7.55228 16 8 16.4477 8 17Z"
                                fill="#1D2977" />
                            <path
                                d="M8 13C8 13.5523 7.55228 14 7 14C6.44772 14 6 13.5523 6 13C6 12.4477 6.44772 12 7 12C7.55228 12 8 12.4477 8 13Z"
                                fill="#1D2977" />
                        </svg>
                    </div>
                    <div class="header-view-order-content">
                        <div class="header-view-order-content-text">
                            <span><?php echo get_the_date('j F, Y'); ?></span>
                        </div>
                        <span><?php _e("تاریخ نگارش", "lamkadeh"); ?></span>
                    </div>
                </div>

            </div>
            <div class="header-view-order-shape-one"></div>
            <div class="header-view-order-shape-two"></div>
            <div class="header-view-order-shape-three"></div>
            <div class="header-view-order-shape-four"></div>
        </section>
        <?php
    }
}
