<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class ContactUs extends Widget_Base
{
    public function get_name()
    {
        return 'ContactUs';
    }

    public function get_title()
    {
        return __('تماس با ما لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-headphones';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    public function get_keywords()
    {
        return ['contact', 'تماس', 'lamkadeh', 'پشتیبانی'];
    }

    protected function register_controls()
    {
        // بخش تنظیمات محتوا
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('تصویر', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/theme/man-contact-us.png',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('عنوان اصلی', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('راه های <strong>ارتــــــــــــــباطی با ما</strong>', 'lamkadeh'),
                'placeholder' => __('عنوان خود را وارد کنید', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('توضیحات', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('<strong>تـــــــیم</strong> ما همیشه آماده پاسخگویی به <strong>ســــوالات و مشاوره خـــــــرید</strong> شماست!', 'lamkadeh'),
                'placeholder' => __('توضیحات خود را وارد کنید', 'lamkadeh'),
            ]
        );

        // اطلاعات تماس
        $this->add_control(
            'contact_info_heading',
            [
                'label' => __('اطلاعات تماس', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'contact_type',
            [
                'label' => __('نوع تماس', 'lamkadeh'),
                'type' => Controls_Manager::SELECT,
                'default' => 'phone',
                'options' => [
                    'phone' => __('تلفن', 'lamkadeh'),
                    'email' => __('ایمیل', 'lamkadeh'),
                    'address' => __('آدرس', 'lamkadeh'),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('واحـدهای <strong>پشتیبانی</strong>', 'lamkadeh'),
                'placeholder' => __('عنوان را وارد کنید', 'lamkadeh'),
            ]
        );

        $repeater->add_control(
            'contact_info_1',
            [
                'label' => __('اطلاعات تماس ۱', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => '۰۲۱ - ۵۵۶۷۸۹۰',
                'placeholder' => __('اطلاعات تماس را وارد کنید', 'lamkadeh'),
            ]
        );

        $repeater->add_control(
            'contact_info_2',
            [
                'label' => __('اطلاعات تماس ۲', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => '۰۲۱ - ۵۵۶۷۸۹۰',
                'placeholder' => __('اطلاعات تماس دوم را وارد کنید', 'lamkadeh'),
            ]
        );

        $repeater->add_control(
            'link_1',
            [
                'label' => __('لینک اطلاعات ۱', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'lamkadeh'),
                'condition' => [
                    'contact_type' => ['phone', 'email'],
                ],
            ]
        );

        $repeater->add_control(
            'link_2',
            [
                'label' => __('لینک اطلاعات ۲', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'lamkadeh'),
                'condition' => [
                    'contact_type' => ['phone', 'email'],
                ],
            ]
        );

        $this->add_control(
            'contact_items',
            [
                'label' => __('آیتم‌های تماس', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'contact_type' => 'phone',
                        'title' => __('واحـدهای <strong>پشتیبانی</strong>', 'lamkadeh'),
                        'contact_info_1' => '۰۲۱ - ۵۵۶۷۸۹۰',
                        'contact_info_2' => '۰۲۱ - ۵۵۶۷۸۹۰',
                    ],
                    [
                        'contact_type' => 'email',
                        'title' => __('ایمیل <strong>پشتیبانی</strong>', 'lamkadeh'),
                        'contact_info_1' => '<strong>info</strong>@site1.com',
                        'contact_info_2' => '<strong>info</strong>@site2.com',
                    ],
                    [
                        'contact_type' => 'address',
                        'title' => __('آدرس <strong>فروشگاه</strong>', 'lamkadeh'),
                        'contact_info_1' => 'تهران - خیابان سعادت آباد - کوچه 5 - پلاک 12',
                        'contact_info_2' => '',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        // بخش تنظیمات استایل
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-content-top-head-title span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('رنگ توضیحات', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-content-top-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => __('رنگ عنوان آیتم‌ها', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-content-body-item-content-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_text_color',
            [
                'label' => __('رنگ متن آیتم‌ها', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-content-body-item-content-body' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __('رنگ پس‌زمینه', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        // استایل برای لینک‌ها
        $this->add_control(
            'link_color',
            [
                'label' => __('رنگ لینک‌ها', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-content-body-item-content-body a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'link_hover_color',
            [
                'label' => __('رنگ لینک‌ها هاور', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-content-body-item-content-body a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // دریافت تصویر
        $image_url = $settings['image']['url'] ?: get_template_directory_uri() . '/assets/images/theme/man-contact-us.png';
?>
        <section class="contact-us-section">
            <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
            <div class="contact-us-content-box">
                <svg class="contact-us-content-box-svg" width="92" height="66" viewBox="0 0 92 66" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12.2143 44.1343C9.65011 44.1343 7.57143 42.1584 7.57143 39.7209C7.57143 37.2834 9.65011 35.3075 12.2143 35.3075C14.7785 35.3075 16.8571 37.2834 16.8571 39.7209C16.8571 42.1584 14.7785 44.1343 12.2143 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 44.1343C46.793 44.1343 44.7143 42.1584 44.7143 39.7209C44.7143 37.2834 46.793 35.3074 49.3571 35.3074C51.9213 35.3074 54 37.2834 54 39.7209C54 42.1584 51.9213 44.1343 49.3571 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 44.1343C65.3644 44.1343 63.2857 42.1584 63.2857 39.7209C63.2857 37.2834 65.3644 35.3074 67.9286 35.3074C70.4927 35.3074 72.5714 37.2834 72.5714 39.7209C72.5714 42.1584 70.4928 44.1343 67.9286 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 26.4806C-8.92132 26.4806 -11 24.5046 -11 22.0672C-11 19.6297 -8.92132 17.6537 -6.35714 17.6537C-3.79296 17.6537 -1.71428 19.6297 -1.71428 22.0672C-1.71428 24.5046 -3.79296 26.4806 -6.35714 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 26.4806C9.65011 26.4806 7.57143 24.5046 7.57143 22.0672C7.57143 19.6297 9.65011 17.6537 12.2143 17.6537C14.7785 17.6537 16.8571 19.6297 16.8571 22.0672C16.8571 24.5046 14.7785 26.4806 12.2143 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 26.4806C28.2215 26.4806 26.1429 24.5046 26.1429 22.0672C26.1429 19.6297 28.2215 17.6537 30.7857 17.6537C33.3499 17.6537 35.4286 19.6297 35.4286 22.0672C35.4286 24.5046 33.3499 26.4806 30.7857 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 26.4806C65.3644 26.4806 63.2857 24.5046 63.2857 22.0672C63.2857 19.6297 65.3644 17.6537 67.9286 17.6537C70.4927 17.6537 72.5714 19.6297 72.5714 22.0672C72.5714 24.5046 70.4927 26.4806 67.9286 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 26.4806C83.9358 26.4806 81.8571 24.5046 81.8571 22.0672C81.8571 19.6297 83.9358 17.6537 86.5 17.6537C89.0642 17.6537 91.1429 19.6297 91.1429 22.0672C91.1429 24.5046 89.0642 26.4806 86.5 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 8.82686C-8.92132 8.82686 -11 6.8509 -11 4.41343C-11 1.97596 -8.92132 4.0125e-06 -6.35714 3.90467e-06C-3.79296 3.79685e-06 -1.71429 1.97596 -1.71428 4.41343C-1.71428 6.8509 -3.79296 8.82686 -6.35714 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 8.82686C28.2215 8.82686 26.1429 6.8509 26.1429 4.41343C26.1429 1.97596 28.2215 2.45063e-06 30.7857 2.3428e-06C33.3499 2.23498e-06 35.4286 1.97596 35.4286 4.41343C35.4286 6.8509 33.3499 8.82686 30.7857 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 8.82686C46.793 8.82686 44.7143 6.8509 44.7143 4.41343C44.7143 1.97596 46.793 1.66969e-06 49.3571 1.56187e-06C51.9213 1.45404e-06 54 1.97596 54 4.41343C54 6.8509 51.9213 8.82686 49.3571 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 8.82686C65.3644 8.82686 63.2857 6.8509 63.2857 4.41343C63.2857 1.97596 65.3644 8.88758e-07 67.9286 7.80934e-07C70.4927 6.73109e-07 72.5714 1.97596 72.5714 4.41343C72.5714 6.8509 70.4927 8.82686 67.9286 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 8.82686C83.9358 8.82686 81.8571 6.8509 81.8571 4.41343C81.8571 1.97596 83.9358 1.07825e-07 86.5 0C89.0642 -1.07825e-07 91.1429 1.97596 91.1429 4.41343C91.1429 6.8509 89.0642 8.82686 86.5 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 26.4806C46.793 26.4806 44.7143 24.5046 44.7143 22.0672C44.7143 19.6297 46.793 17.6537 49.3571 17.6537C51.9213 17.6537 54 19.6297 54 22.0672C54 24.5046 51.9213 26.4806 49.3571 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 8.82686C9.65011 8.82686 7.57143 6.8509 7.57143 4.41343C7.57143 1.97596 9.6501 3.23156e-06 12.2143 3.12374e-06C14.7785 3.01591e-06 16.8571 1.97596 16.8571 4.41343C16.8571 6.8509 14.7785 8.82686 12.2143 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 44.1343C28.2215 44.1343 26.1429 42.1584 26.1429 39.7209C26.1429 37.2834 28.2215 35.3074 30.7857 35.3074C33.3499 35.3074 35.4286 37.2834 35.4286 39.7209C35.4286 42.1584 33.3499 44.1343 30.7857 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 44.1343C83.9358 44.1343 81.8571 42.1584 81.8571 39.7209C81.8571 37.2834 83.9358 35.3074 86.5 35.3074C89.0642 35.3074 91.1429 37.2834 91.1429 39.7209C91.1429 42.1584 89.0642 44.1343 86.5 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 44.1343C-8.92132 44.1343 -11 42.1584 -11 39.7209C-11 37.2834 -8.92132 35.3075 -6.35714 35.3075C-3.79296 35.3075 -1.71428 37.2834 -1.71428 39.7209C-1.71428 42.1584 -3.79296 44.1343 -6.35714 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 97.4286C9.65011 97.4286 7.57143 95.4526 7.57143 93.0151C7.57143 90.5777 9.65011 88.6017 12.2143 88.6017C14.7785 88.6017 16.8571 90.5777 16.8571 93.0151C16.8571 95.4526 14.7785 97.4286 12.2143 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 97.4286C46.793 97.4286 44.7143 95.4526 44.7143 93.0151C44.7143 90.5777 46.793 88.6017 49.3571 88.6017C51.9213 88.6017 54 90.5777 54 93.0151C54 95.4526 51.9213 97.4286 49.3571 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 97.4286C65.3644 97.4286 63.2857 95.4526 63.2857 93.0151C63.2857 90.5777 65.3644 88.6017 67.9286 88.6017C70.4927 88.6017 72.5714 90.5777 72.5714 93.0151C72.5714 95.4526 70.4928 97.4286 67.9286 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 79.7749C-8.92132 79.7749 -11 77.7989 -11 75.3614C-11 72.924 -8.92132 70.948 -6.35714 70.948C-3.79296 70.948 -1.71428 72.924 -1.71428 75.3614C-1.71428 77.7989 -3.79296 79.7749 -6.35714 79.7749Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 79.7749C9.65011 79.7749 7.57143 77.7989 7.57143 75.3614C7.57143 72.924 9.65011 70.948 12.2143 70.948C14.7785 70.948 16.8571 72.924 16.8571 75.3614C16.8571 77.7989 14.7785 79.7749 12.2143 79.7749Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 79.7749C28.2215 79.7749 26.1429 77.7989 26.1429 75.3614C26.1429 72.924 28.2215 70.948 30.7857 70.948C33.3499 70.948 35.4286 72.924 35.4286 75.3614C35.4286 77.7989 33.3499 79.7749 30.7857 79.7749Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 79.7748C65.3644 79.7748 63.2857 77.7989 63.2857 75.3614C63.2857 72.924 65.3644 70.948 67.9286 70.948C70.4927 70.948 72.5714 72.924 72.5714 75.3614C72.5714 77.7989 70.4927 79.7748 67.9286 79.7748Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 79.7748C83.9358 79.7748 81.8571 77.7989 81.8571 75.3614C81.8571 72.924 83.9358 70.948 86.5 70.948C89.0642 70.948 91.1429 72.924 91.1429 75.3614C91.1429 77.7989 89.0642 79.7748 86.5 79.7748Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 62.1211C-8.92132 62.1211 -11 60.1452 -11 57.7077C-11 55.2702 -8.92132 53.2943 -6.35714 53.2943C-3.79296 53.2943 -1.71429 55.2702 -1.71428 57.7077C-1.71428 60.1452 -3.79296 62.1211 -6.35714 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 62.1211C28.2215 62.1211 26.1429 60.1452 26.1429 57.7077C26.1429 55.2702 28.2215 53.2943 30.7857 53.2943C33.3499 53.2943 35.4286 55.2702 35.4286 57.7077C35.4286 60.1452 33.3499 62.1211 30.7857 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 62.1211C46.793 62.1211 44.7143 60.1452 44.7143 57.7077C44.7143 55.2702 46.793 53.2943 49.3571 53.2943C51.9213 53.2943 54 55.2702 54 57.7077C54 60.1452 51.9213 62.1211 49.3571 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 62.1211C65.3644 62.1211 63.2857 60.1452 63.2857 57.7077C63.2857 55.2702 65.3644 53.2943 67.9286 53.2943C70.4927 53.2943 72.5714 55.2702 72.5714 57.7077C72.5714 60.1452 70.4927 62.1211 67.9286 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 62.1211C83.9358 62.1211 81.8571 60.1452 81.8571 57.7077C81.8571 55.2702 83.9358 53.2943 86.5 53.2943C89.0642 53.2943 91.1429 55.2702 91.1429 57.7077C91.1429 60.1452 89.0642 62.1211 86.5 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 79.7748C46.793 79.7748 44.7143 77.7989 44.7143 75.3614C44.7143 72.924 46.793 70.948 49.3571 70.948C51.9213 70.948 54 72.924 54 75.3614C54 77.7989 51.9213 79.7748 49.3571 79.7748Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 62.1211C9.65011 62.1211 7.57143 60.1452 7.57143 57.7077C7.57143 55.2702 9.6501 53.2943 12.2143 53.2943C14.7785 53.2943 16.8571 55.2702 16.8571 57.7077C16.8571 60.1452 14.7785 62.1211 12.2143 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 97.4286C28.2215 97.4286 26.1429 95.4526 26.1429 93.0151C26.1429 90.5777 28.2215 88.6017 30.7857 88.6017C33.3499 88.6017 35.4286 90.5777 35.4286 93.0151C35.4286 95.4526 33.3499 97.4286 30.7857 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 97.4286C83.9358 97.4286 81.8571 95.4526 81.8571 93.0151C81.8571 90.5777 83.9358 88.6017 86.5 88.6017C89.0642 88.6017 91.1429 90.5777 91.1429 93.0151C91.1429 95.4526 89.0642 97.4286 86.5 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 97.4286C-8.92132 97.4286 -11 95.4526 -11 93.0152C-11 90.5777 -8.92132 88.6017 -6.35714 88.6017C-3.79296 88.6017 -1.71428 90.5777 -1.71428 93.0152C-1.71428 95.4526 -3.79296 97.4286 -6.35714 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                </svg>
                <svg class="contact-us-content-box-svg-one" width="92" height="66" viewBox="0 0 92 66" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12.2143 44.1343C9.65011 44.1343 7.57143 42.1584 7.57143 39.7209C7.57143 37.2834 9.65011 35.3075 12.2143 35.3075C14.7785 35.3075 16.8571 37.2834 16.8571 39.7209C16.8571 42.1584 14.7785 44.1343 12.2143 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 44.1343C46.793 44.1343 44.7143 42.1584 44.7143 39.7209C44.7143 37.2834 46.793 35.3074 49.3571 35.3074C51.9213 35.3074 54 37.2834 54 39.7209C54 42.1584 51.9213 44.1343 49.3571 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 44.1343C65.3644 44.1343 63.2857 42.1584 63.2857 39.7209C63.2857 37.2834 65.3644 35.3074 67.9286 35.3074C70.4927 35.3074 72.5714 37.2834 72.5714 39.7209C72.5714 42.1584 70.4928 44.1343 67.9286 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 26.4806C-8.92132 26.4806 -11 24.5046 -11 22.0672C-11 19.6297 -8.92132 17.6537 -6.35714 17.6537C-3.79296 17.6537 -1.71428 19.6297 -1.71428 22.0672C-1.71428 24.5046 -3.79296 26.4806 -6.35714 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 26.4806C9.65011 26.4806 7.57143 24.5046 7.57143 22.0672C7.57143 19.6297 9.65011 17.6537 12.2143 17.6537C14.7785 17.6537 16.8571 19.6297 16.8571 22.0672C16.8571 24.5046 14.7785 26.4806 12.2143 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 26.4806C28.2215 26.4806 26.1429 24.5046 26.1429 22.0672C26.1429 19.6297 28.2215 17.6537 30.7857 17.6537C33.3499 17.6537 35.4286 19.6297 35.4286 22.0672C35.4286 24.5046 33.3499 26.4806 30.7857 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 26.4806C65.3644 26.4806 63.2857 24.5046 63.2857 22.0672C63.2857 19.6297 65.3644 17.6537 67.9286 17.6537C70.4927 17.6537 72.5714 19.6297 72.5714 22.0672C72.5714 24.5046 70.4927 26.4806 67.9286 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 26.4806C83.9358 26.4806 81.8571 24.5046 81.8571 22.0672C81.8571 19.6297 83.9358 17.6537 86.5 17.6537C89.0642 17.6537 91.1429 19.6297 91.1429 22.0672C91.1429 24.5046 89.0642 26.4806 86.5 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 8.82686C-8.92132 8.82686 -11 6.8509 -11 4.41343C-11 1.97596 -8.92132 4.0125e-06 -6.35714 3.90467e-06C-3.79296 3.79685e-06 -1.71429 1.97596 -1.71428 4.41343C-1.71428 6.8509 -3.79296 8.82686 -6.35714 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 8.82686C28.2215 8.82686 26.1429 6.8509 26.1429 4.41343C26.1429 1.97596 28.2215 2.45063e-06 30.7857 2.3428e-06C33.3499 2.23498e-06 35.4286 1.97596 35.4286 4.41343C35.4286 6.8509 33.3499 8.82686 30.7857 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 8.82686C46.793 8.82686 44.7143 6.8509 44.7143 4.41343C44.7143 1.97596 46.793 1.66969e-06 49.3571 1.56187e-06C51.9213 1.45404e-06 54 1.97596 54 4.41343C54 6.8509 51.9213 8.82686 49.3571 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 8.82686C65.3644 8.82686 63.2857 6.8509 63.2857 4.41343C63.2857 1.97596 65.3644 8.88758e-07 67.9286 7.80934e-07C70.4927 6.73109e-07 72.5714 1.97596 72.5714 4.41343C72.5714 6.8509 70.4927 8.82686 67.9286 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 8.82686C83.9358 8.82686 81.8571 6.8509 81.8571 4.41343C81.8571 1.97596 83.9358 1.07825e-07 86.5 0C89.0642 -1.07825e-07 91.1429 1.97596 91.1429 4.41343C91.1429 6.8509 89.0642 8.82686 86.5 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 26.4806C46.793 26.4806 44.7143 24.5046 44.7143 22.0672C44.7143 19.6297 46.793 17.6537 49.3571 17.6537C51.9213 17.6537 54 19.6297 54 22.0672C54 24.5046 51.9213 26.4806 49.3571 26.4806Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 8.82686C9.65011 8.82686 7.57143 6.8509 7.57143 4.41343C7.57143 1.97596 9.6501 3.23156e-06 12.2143 3.12374e-06C14.7785 3.01591e-06 16.8571 1.97596 16.8571 4.41343C16.8571 6.8509 14.7785 8.82686 12.2143 8.82686Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 44.1343C28.2215 44.1343 26.1429 42.1584 26.1429 39.7209C26.1429 37.2834 28.2215 35.3074 30.7857 35.3074C33.3499 35.3074 35.4286 37.2834 35.4286 39.7209C35.4286 42.1584 33.3499 44.1343 30.7857 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 44.1343C83.9358 44.1343 81.8571 42.1584 81.8571 39.7209C81.8571 37.2834 83.9358 35.3074 86.5 35.3074C89.0642 35.3074 91.1429 37.2834 91.1429 39.7209C91.1429 42.1584 89.0642 44.1343 86.5 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 44.1343C-8.92132 44.1343 -11 42.1584 -11 39.7209C-11 37.2834 -8.92132 35.3075 -6.35714 35.3075C-3.79296 35.3075 -1.71428 37.2834 -1.71428 39.7209C-1.71428 42.1584 -3.79296 44.1343 -6.35714 44.1343Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 97.4286C9.65011 97.4286 7.57143 95.4526 7.57143 93.0151C7.57143 90.5777 9.65011 88.6017 12.2143 88.6017C14.7785 88.6017 16.8571 90.5777 16.8571 93.0151C16.8571 95.4526 14.7785 97.4286 12.2143 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 97.4286C46.793 97.4286 44.7143 95.4526 44.7143 93.0151C44.7143 90.5777 46.793 88.6017 49.3571 88.6017C51.9213 88.6017 54 90.5777 54 93.0151C54 95.4526 51.9213 97.4286 49.3571 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 97.4286C65.3644 97.4286 63.2857 95.4526 63.2857 93.0151C63.2857 90.5777 65.3644 88.6017 67.9286 88.6017C70.4927 88.6017 72.5714 90.5777 72.5714 93.0151C72.5714 95.4526 70.4928 97.4286 67.9286 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 79.7749C-8.92132 79.7749 -11 77.7989 -11 75.3614C-11 72.924 -8.92132 70.948 -6.35714 70.948C-3.79296 70.948 -1.71428 72.924 -1.71428 75.3614C-1.71428 77.7989 -3.79296 79.7749 -6.35714 79.7749Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 79.7749C9.65011 79.7749 7.57143 77.7989 7.57143 75.3614C7.57143 72.924 9.65011 70.948 12.2143 70.948C14.7785 70.948 16.8571 72.924 16.8571 75.3614C16.8571 77.7989 14.7785 79.7749 12.2143 79.7749Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 79.7749C28.2215 79.7749 26.1429 77.7989 26.1429 75.3614C26.1429 72.924 28.2215 70.948 30.7857 70.948C33.3499 70.948 35.4286 72.924 35.4286 75.3614C35.4286 77.7989 33.3499 79.7749 30.7857 79.7749Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 79.7748C65.3644 79.7748 63.2857 77.7989 63.2857 75.3614C63.2857 72.924 65.3644 70.948 67.9286 70.948C70.4927 70.948 72.5714 72.924 72.5714 75.3614C72.5714 77.7989 70.4927 79.7748 67.9286 79.7748Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 79.7748C83.9358 79.7748 81.8571 77.7989 81.8571 75.3614C81.8571 72.924 83.9358 70.948 86.5 70.948C89.0642 70.948 91.1429 72.924 91.1429 75.3614C91.1429 77.7989 89.0642 79.7748 86.5 79.7748Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 62.1211C-8.92132 62.1211 -11 60.1452 -11 57.7077C-11 55.2702 -8.92132 53.2943 -6.35714 53.2943C-3.79296 53.2943 -1.71429 55.2702 -1.71428 57.7077C-1.71428 60.1452 -3.79296 62.1211 -6.35714 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 62.1211C28.2215 62.1211 26.1429 60.1452 26.1429 57.7077C26.1429 55.2702 28.2215 53.2943 30.7857 53.2943C33.3499 53.2943 35.4286 55.2702 35.4286 57.7077C35.4286 60.1452 33.3499 62.1211 30.7857 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 62.1211C46.793 62.1211 44.7143 60.1452 44.7143 57.7077C44.7143 55.2702 46.793 53.2943 49.3571 53.2943C51.9213 53.2943 54 55.2702 54 57.7077C54 60.1452 51.9213 62.1211 49.3571 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M67.9286 62.1211C65.3644 62.1211 63.2857 60.1452 63.2857 57.7077C63.2857 55.2702 65.3644 53.2943 67.9286 53.2943C70.4927 53.2943 72.5714 55.2702 72.5714 57.7077C72.5714 60.1452 70.4927 62.1211 67.9286 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 62.1211C83.9358 62.1211 81.8571 60.1452 81.8571 57.7077C81.8571 55.2702 83.9358 53.2943 86.5 53.2943C89.0642 53.2943 91.1429 55.2702 91.1429 57.7077C91.1429 60.1452 89.0642 62.1211 86.5 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M49.3571 79.7748C46.793 79.7748 44.7143 77.7989 44.7143 75.3614C44.7143 72.924 46.793 70.948 49.3571 70.948C51.9213 70.948 54 72.924 54 75.3614C54 77.7989 51.9213 79.7748 49.3571 79.7748Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M12.2143 62.1211C9.65011 62.1211 7.57143 60.1452 7.57143 57.7077C7.57143 55.2702 9.6501 53.2943 12.2143 53.2943C14.7785 53.2943 16.8571 55.2702 16.8571 57.7077C16.8571 60.1452 14.7785 62.1211 12.2143 62.1211Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M30.7857 97.4286C28.2215 97.4286 26.1429 95.4526 26.1429 93.0151C26.1429 90.5777 28.2215 88.6017 30.7857 88.6017C33.3499 88.6017 35.4286 90.5777 35.4286 93.0151C35.4286 95.4526 33.3499 97.4286 30.7857 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M86.5 97.4286C83.9358 97.4286 81.8571 95.4526 81.8571 93.0151C81.8571 90.5777 83.9358 88.6017 86.5 88.6017C89.0642 88.6017 91.1429 90.5777 91.1429 93.0151C91.1429 95.4526 89.0642 97.4286 86.5 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                    <path d="M-6.35714 97.4286C-8.92132 97.4286 -11 95.4526 -11 93.0152C-11 90.5777 -8.92132 88.6017 -6.35714 88.6017C-3.79296 88.6017 -1.71428 90.5777 -1.71428 93.0152C-1.71428 95.4526 -3.79296 97.4286 -6.35714 97.4286Z" fill="#1D2977" fill-opacity="0.12" />
                </svg>

                <div class="contact-us-content">
                    <div class="contact-us-content-top">
                        <div class="contact-us-content-top-head">
                            <span>CONTACT US</span>
                            <div class="contact-us-content-top-head-title">
                                <span><?php echo wp_kses($settings['title'], $this->get_allowed_html_tags()); ?></span>
                                <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_1_4017)">
                                        <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M35.3246 13.8347C36.4486 12.6513 38.3078 12.873 39.2369 14.1871L40.3928 15.822C41.136 16.8731 41.0732 18.3344 40.1862 19.2682L39.9618 19.5045C39.9612 19.5061 39.9605 19.5079 39.9598 19.5098C39.948 19.5431 39.918 19.6493 39.9475 19.8507C40.0087 20.2683 40.331 21.1168 41.6397 22.4946C42.9525 23.8768 43.7488 24.2025 44.1178 24.2624C44.277 24.2883 44.3602 24.2658 44.3868 24.2565L44.7614 23.8621C45.5623 23.0189 46.8112 22.8527 47.8181 23.4323L49.5694 24.4403C51.0662 25.3019 51.4146 27.4095 50.2184 28.6689L48.9162 30.0398C48.5098 30.4677 47.9556 30.833 47.2708 30.9005C45.5989 31.0656 41.7259 30.8506 37.6656 26.5759C33.8769 22.5871 33.1572 19.1176 33.0662 17.4225L33.6768 17.3897L33.0662 17.4225C33.0212 16.585 33.3946 15.8666 33.8858 15.3494L35.3246 13.8347ZM38.1142 14.9809C37.6445 14.3167 36.8008 14.277 36.3215 14.7816L34.8827 16.2964C34.5789 16.6162 34.4195 16.9828 34.4392 17.3488C34.5135 18.7328 35.1095 21.8882 38.6626 25.629C42.3881 29.5512 45.8203 29.662 47.1358 29.5322C47.3959 29.5065 47.6635 29.3622 47.9193 29.0929L49.2214 27.722C49.7832 27.1306 49.6359 26.0651 48.8835 25.632L47.1322 24.624C46.6622 24.3535 46.1117 24.4371 45.7583 24.8091L45.3408 25.2486L44.8576 24.7896C45.3408 25.2486 45.3402 25.2493 45.3396 25.25L45.3383 25.2513L45.3355 25.2541L45.3297 25.26L45.3166 25.273C45.3071 25.2821 45.2962 25.2922 45.2839 25.303C45.2593 25.3246 45.2288 25.3492 45.1922 25.3752C45.1187 25.4273 45.0209 25.4846 44.8972 25.5334C44.6442 25.6332 44.3101 25.6867 43.8974 25.6197C43.093 25.489 42.0387 24.9113 40.6428 23.4416C39.2427 21.9676 38.7068 20.8678 38.587 20.0501C38.526 19.6338 38.5748 19.3005 38.6644 19.0488C38.7084 18.9251 38.7604 18.8264 38.8084 18.7514C38.8323 18.7141 38.8551 18.6828 38.8753 18.6573C38.8853 18.6446 38.8948 18.6333 38.9033 18.6234L38.9155 18.6097L38.9211 18.6036L38.9238 18.6008L38.9251 18.5994C38.9257 18.5987 38.9264 18.5981 39.4137 19.061L38.9264 18.598L39.1893 18.3212C39.5977 17.8913 39.657 17.1631 39.2701 16.6158L38.1142 14.9809Z" fill="#1D2977" />
                                        <path d="M43.1547 12.7233C43.2154 12.3485 43.5697 12.0943 43.9445 12.1549C43.9677 12.1594 44.0424 12.1733 44.0815 12.1821C44.1597 12.1995 44.2688 12.2263 44.4048 12.2659C44.6769 12.3452 45.0569 12.4757 45.5131 12.6848C46.4263 13.1035 47.6417 13.8359 48.9028 15.0971C50.164 16.3582 50.8964 17.5736 51.3151 18.4868C51.5242 18.943 51.6548 19.323 51.734 19.5951C51.7736 19.7311 51.8004 19.8402 51.8179 19.9184C51.8266 19.9575 51.8329 19.9889 51.8374 20.0121L51.8426 20.0407C51.9033 20.4156 51.6514 20.7845 51.2766 20.8452C50.9028 20.9057 50.5507 20.6527 50.4886 20.2796C50.4866 20.2696 50.4814 20.2427 50.4757 20.2173C50.4644 20.1666 50.4449 20.0861 50.4138 19.9796C50.3518 19.7666 50.2441 19.45 50.0652 19.0598C49.7078 18.2804 49.0653 17.2041 47.9306 16.0694C46.7958 14.9346 45.7195 14.2921 44.9401 13.9347C44.5499 13.7558 44.2333 13.6481 44.0203 13.5861C43.9139 13.555 43.78 13.5243 43.7293 13.513C43.3562 13.4508 43.0942 13.0971 43.1547 12.7233Z" fill="#1D2977" />
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M43.3621 15.8855C43.4664 15.5204 43.8469 15.309 44.212 15.4133L44.0231 16.0744C44.212 15.4133 44.2123 15.4134 44.2126 15.4135L44.2133 15.4137L44.2147 15.4141L44.2178 15.415L44.2249 15.4171L44.243 15.4228C44.2568 15.4272 44.2741 15.433 44.2947 15.4403C44.3359 15.4549 44.3903 15.4757 44.457 15.5043C44.5905 15.5615 44.773 15.6499 44.9972 15.7825C45.4458 16.0481 46.0583 16.4892 46.7779 17.2087C47.4975 17.9283 47.9385 18.5408 48.2041 18.9895C48.3367 19.2136 48.4251 19.3961 48.4823 19.5296C48.5109 19.5963 48.5317 19.6508 48.5463 19.6919C48.5536 19.7125 48.5594 19.7298 48.5638 19.7436L48.5695 19.7617L48.5716 19.7688L48.5725 19.7719L48.5729 19.7733L48.5731 19.774C48.5732 19.7743 48.5733 19.7746 47.9122 19.9635L48.5733 19.7746C48.6776 20.1397 48.4662 20.5202 48.1011 20.6245C47.7391 20.728 47.3619 20.521 47.2539 20.1616L47.2505 20.1517C47.2456 20.138 47.2355 20.1108 47.2185 20.0712C47.1846 19.9921 47.1231 19.8626 47.0208 19.6898C46.8164 19.3444 46.4472 18.8226 45.8056 18.181C45.164 17.5394 44.6422 17.1702 44.2968 16.9658C44.124 16.8635 43.9945 16.802 43.9154 16.7681C43.8758 16.7511 43.8486 16.741 43.8349 16.7361L43.825 16.7327C43.4656 16.6247 43.2587 16.2475 43.3621 15.8855Z" fill="#1D2977" />
                                        <circle cx="22" cy="62" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_1_4017">
                                            <rect width="64" height="64" rx="32" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-us-content-top-shape"></div>
                        </div>
                        <span class="contact-us-content-top-description">
                            <?php echo wp_kses($settings['description'], $this->get_allowed_html_tags()); ?>
                        </span>
                    </div>
                    <div class="contact-us-content-body">
                        <?php foreach ($settings['contact_items'] as $item): ?>
                            <div class="contact-us-content-body-item">
                                <div class="contact-us-content-body-item-icon">
                                    <?php echo $this->get_contact_icon($item['contact_type']); ?>
                                </div>
                                <div class="contact-us-content-body-item-rectangle"></div>
                                <div class="contact-us-content-body-item-content">
                                    <span class="contact-us-content-body-item-content-title">
                                        <?php echo wp_kses($item['title'], $this->get_allowed_html_tags()); ?>
                                    </span>
                                    <div class="contact-us-content-body-item-content-rectangle"></div>
                                    <div class="contact-us-content-body-item-content-body">
                                        <?php echo $this->render_contact_info($item); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
<?php
    }

    /**
     * تابع برای دریافت آیکون بر اساس نوع تماس
     */
    private function get_contact_icon($type)
    {
        switch ($type) {
            case 'phone':
                return '
                    <svg width="84" height="84" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="2" y="2" width="60" height="60" rx="30" fill="#FFD701" />
                        <rect x="2" y="2" width="60" height="60" rx="30" stroke="white" stroke-width="4" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M24.8857 23.0921C26.1118 21.8012 28.1401 22.0431 29.1537 23.4767L30.4146 25.2601C31.2254 26.4068 31.1569 28.001 30.1893 29.0196L29.9445 29.2774C29.9438 29.2792 29.9431 29.2811 29.9423 29.2832C29.9294 29.3196 29.8967 29.4354 29.9289 29.6551C29.9956 30.1107 30.3473 31.0364 31.7749 32.5394C33.2071 34.0472 34.0757 34.4025 34.4783 34.4679C34.652 34.4961 34.7428 34.4716 34.7717 34.4614L35.1804 34.0312C36.0541 33.1113 37.4165 32.9301 38.515 33.5623L40.4255 34.662C42.0584 35.6019 42.4385 37.9011 41.1335 39.275L39.7129 40.7705C39.2696 41.2373 38.665 41.6358 37.918 41.7095C36.0941 41.8895 31.869 41.655 27.4396 36.9917C23.3064 32.6403 22.5212 28.8554 22.422 27.0062L23.0881 26.9704L22.422 27.0062C22.3729 26.0925 22.7802 25.3088 23.3161 24.7446L24.8857 23.0921ZM27.9289 24.3426C27.4165 23.618 26.4961 23.5747 25.9733 24.1252L24.4037 25.7777C24.0723 26.1266 23.8984 26.5265 23.9198 26.9258C24.0009 28.4356 24.651 31.8779 28.5272 35.9587C32.5913 40.2375 36.3356 40.3584 37.7706 40.2167C38.0544 40.1887 38.3463 40.0313 38.6253 39.7375L40.0459 38.2419C40.6587 37.5968 40.498 36.4345 39.6772 35.962L37.7667 34.8624C37.254 34.5673 36.6534 34.6584 36.268 35.0642L35.8125 35.5437L35.2853 35.043C35.8125 35.5438 35.8118 35.5445 35.8111 35.5452L35.8097 35.5467L35.8067 35.5498L35.8004 35.5562L35.7861 35.5704C35.7757 35.5803 35.7639 35.5913 35.7504 35.6031C35.7236 35.6266 35.6903 35.6535 35.6503 35.6819C35.5702 35.7387 35.4635 35.8012 35.3286 35.8544C35.0526 35.9633 34.6881 36.0216 34.2378 35.9485C33.3603 35.806 32.2102 35.1757 30.6873 33.5724C29.16 31.9644 28.5754 30.7647 28.4447 29.8726C28.3782 29.4185 28.4314 29.0549 28.5291 28.7804C28.5772 28.6453 28.6339 28.5377 28.6862 28.4559C28.7123 28.4151 28.7372 28.381 28.7592 28.3532C28.7702 28.3393 28.7804 28.327 28.7898 28.3163L28.8031 28.3013L28.8092 28.2947L28.8121 28.2915L28.8135 28.29C28.8142 28.2893 28.8149 28.2886 29.3466 28.7936L28.8149 28.2886L29.1017 27.9866C29.5473 27.5176 29.612 26.7232 29.1899 26.1261L27.9289 24.3426Z" fill="#1D2977" />
                        <path d="M33.4275 21.8801C33.4937 21.4712 33.8802 21.1938 34.2891 21.26C34.3144 21.2649 34.3958 21.2801 34.4385 21.2896C34.5238 21.3086 34.6429 21.3378 34.7913 21.3811C35.088 21.4675 35.5026 21.6099 36.0003 21.838C36.9965 22.2948 38.3223 23.0938 39.6981 24.4696C41.0739 25.8454 41.873 27.1712 42.3297 28.1675C42.5578 28.6651 42.7002 29.0797 42.7867 29.3765C42.8299 29.5249 42.8592 29.6439 42.8782 29.7293C42.8877 29.7719 42.8946 29.8062 42.8995 29.8315L42.9052 29.8627C42.9714 30.2716 42.6966 30.6741 42.2877 30.7403C41.88 30.8063 41.4959 30.5303 41.428 30.1233C41.4259 30.1124 41.4202 30.083 41.414 30.0553C41.4017 29.9999 41.3804 29.9121 41.3465 29.796C41.2789 29.5636 41.1613 29.2183 40.9662 28.7926C40.5763 27.9423 39.8753 26.7681 38.6375 25.5303C37.3996 24.2924 36.2254 23.5914 35.3751 23.2016C34.9495 23.0064 34.6041 22.8889 34.3718 22.8212C34.2556 22.7874 34.1096 22.7539 34.0543 22.7415C33.6473 22.6737 33.3614 22.2878 33.4275 21.8801Z" fill="#1D2977" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M33.6541 25.3296C33.7678 24.9313 34.183 24.7007 34.5812 24.8145L34.3752 25.5356C34.5812 24.8145 34.5816 24.8146 34.5819 24.8147L34.5827 24.8149L34.5842 24.8153L34.5875 24.8163L34.5953 24.8186L34.6151 24.8248C34.6302 24.8296 34.649 24.8359 34.6714 24.8438C34.7163 24.8598 34.7757 24.8824 34.8485 24.9136C34.9942 24.9761 35.1933 25.0725 35.4378 25.2172C35.9272 25.5069 36.5954 25.9881 37.3804 26.773C38.1654 27.558 38.6465 28.2262 38.9362 28.7157C39.0809 28.9602 39.1774 29.1592 39.2398 29.3049C39.271 29.3777 39.2937 29.4371 39.3096 29.482C39.3176 29.5044 39.3238 29.5233 39.3287 29.5383L39.3348 29.5581L39.3371 29.5659L39.3381 29.5692L39.3386 29.5708L39.3388 29.5715C39.3389 29.5718 39.339 29.5722 38.6178 29.7782L39.339 29.5722C39.4528 29.9705 39.2222 30.3856 38.8239 30.4994C38.429 30.6122 38.0175 30.3864 37.8997 29.9944L37.896 29.9836C37.8906 29.9686 37.8796 29.939 37.8611 29.8958C37.8241 29.8095 37.757 29.6682 37.6454 29.4796C37.4224 29.1029 37.0197 28.5336 36.3197 27.8337C35.6198 27.1337 35.0505 26.731 34.6738 26.5081C34.4852 26.3964 34.344 26.3293 34.2576 26.2923C34.2144 26.2738 34.1848 26.2628 34.1698 26.2575L34.159 26.2538C33.767 26.1359 33.5412 25.7244 33.6541 25.3296Z" fill="#1D2977" />
                    </svg>
                ';

            case 'email':
                return '
                    <svg width="85" height="84" viewBox="0 0 65 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M32 2H33C49.5685 2 63 15.4315 63 32C63 48.5685 49.5685 62 33 62H32C15.4315 62 2 48.5685 2 32C2 15.4315 15.4315 2 32 2Z" fill="#FFD701" />
                        <path d="M32 2H33C49.5685 2 63 15.4315 63 32C63 48.5685 49.5685 62 33 62H32C15.4315 62 2 48.5685 2 32C2 15.4315 15.4315 2 32 2Z" stroke="white" stroke-width="4" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M30.4436 23.25H34.5564C36.3942 23.25 37.8498 23.25 38.989 23.4031C40.1614 23.5608 41.1104 23.8929 41.8588 24.6412C42.6071 25.3896 42.9392 26.3386 43.0969 27.511C43.25 28.6502 43.25 30.1058 43.25 31.9436V32.0564C43.25 33.8942 43.25 35.3498 43.0969 36.489C42.9392 37.6614 42.6071 38.6104 41.8588 39.3588C41.1104 40.1071 40.1614 40.4392 38.989 40.5969C37.8498 40.75 36.3942 40.75 34.5564 40.75H30.4436C28.6058 40.75 27.1502 40.75 26.011 40.5969C24.8386 40.4392 23.8896 40.1071 23.1412 39.3588C22.3929 38.6104 22.0608 37.6614 21.9031 36.489C21.75 35.3498 21.75 33.8942 21.75 32.0564V31.9436C21.75 30.1058 21.75 28.6502 21.9031 27.511C22.0608 26.3386 22.3929 25.3896 23.1412 24.6412C23.8896 23.8929 24.8386 23.5608 26.011 23.4031C27.1502 23.25 28.6058 23.25 30.4436 23.25ZM26.2108 24.8898C25.2048 25.025 24.6251 25.2787 24.2019 25.7019C23.7787 26.1251 23.525 26.7048 23.3898 27.7108C23.2516 28.7385 23.25 30.0932 23.25 32C23.25 33.9068 23.2516 35.2615 23.3898 36.2892C23.525 37.2952 23.7787 37.8749 24.2019 38.2981C24.6251 38.7213 25.2048 38.975 26.2108 39.1102C27.2385 39.2484 28.5932 39.25 30.5 39.25H34.5C36.4068 39.25 37.7615 39.2484 38.7892 39.1102C39.7952 38.975 40.3749 38.7213 40.7981 38.2981C41.2213 37.8749 41.475 37.2952 41.6102 36.2892C41.7484 35.2615 41.75 33.9068 41.75 32C41.75 30.0932 41.7484 28.7385 41.6102 27.7108C41.475 26.7048 41.2213 26.1251 40.7981 25.7019C40.3749 25.2787 39.7952 25.025 38.7892 24.8898C37.7615 24.7516 36.4068 24.75 34.5 24.75H30.5C28.5932 24.75 27.2385 24.7516 26.2108 24.8898ZM25.9238 27.5199C26.189 27.2017 26.6619 27.1587 26.9801 27.4238L29.139 29.2229C30.072 30.0004 30.7197 30.5384 31.2666 30.8901C31.7959 31.2306 32.1549 31.3449 32.5 31.3449C32.8451 31.3449 33.2041 31.2306 33.7334 30.8901C34.2803 30.5384 34.928 30.0004 35.861 29.2229L38.0199 27.4238C38.3381 27.1587 38.811 27.2017 39.0762 27.5199C39.3413 27.8381 39.2983 28.311 38.9801 28.5762L36.7836 30.4066C35.8973 31.1452 35.1789 31.7439 34.5448 32.1517C33.8843 32.5765 33.2411 32.8449 32.5 32.8449C31.7589 32.8449 31.1157 32.5765 30.4552 32.1517C29.8211 31.7439 29.1027 31.1452 28.2164 30.4066L26.0199 28.5762C25.7017 28.311 25.6587 27.8381 25.9238 27.5199Z" fill="#1D2977" />
                    </svg>
                ';

            case 'address':
                return '
                    <svg width="84" height="84" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="2" y="2" width="60" height="60" rx="30" fill="#FFD701" />
                        <rect x="2" y="2" width="60" height="60" rx="30" stroke="white" stroke-width="4" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M23.083 30.1433C23.083 25.2443 26.988 21.25 31.833 21.25C36.678 21.25 40.583 25.2443 40.583 30.1433C40.583 32.5084 39.909 35.0479 38.7175 37.2419C37.5274 39.4331 35.7886 41.3372 33.6135 42.3539C32.4836 42.882 31.1824 42.882 30.0525 42.3539C27.8774 41.3372 26.1386 39.4331 24.9486 37.2419C23.757 35.0479 23.083 32.5084 23.083 30.1433ZM31.833 22.75C27.8414 22.75 24.583 26.0475 24.583 30.1433C24.583 32.2404 25.1856 34.5354 26.2667 36.526C27.3492 38.5192 28.879 40.1496 30.6877 40.995C31.4151 41.335 32.251 41.335 32.9784 40.995C34.787 40.1496 36.3168 38.5192 37.3993 36.526C38.4804 34.5354 39.083 32.2404 39.083 30.1433C39.083 26.0475 35.8246 22.75 31.833 22.75ZM31.833 27.75C30.5904 27.75 29.583 28.7574 29.583 30C29.583 31.2426 30.5904 32.25 31.833 32.25C33.0756 32.25 34.083 31.2426 34.083 30C34.083 28.7574 33.0756 27.75 31.833 27.75ZM28.083 30C28.083 27.9289 29.7619 26.25 31.833 26.25C33.9041 26.25 35.583 27.9289 35.583 30C35.583 32.0711 33.9041 33.75 31.833 33.75C29.7619 33.75 28.083 32.0711 28.083 30Z" fill="#1D2977" />
                    </svg>
                ';
        }
    }

    /**
     * تابع برای رندر اطلاعات تماس
     */
    private function render_contact_info($item)
    {
        $output = '';

        if ($item['contact_type'] === 'address') {
            // برای آدرس - استفاده از WYSIWYG content
            $output = '<div>' . wp_kses($item['contact_info_1'], $this->get_allowed_html_tags()) . '</div>';
        } else {
            // برای تلفن و ایمیل
            $link_1 = $item['link_1']['url'] ?? '';
            $link_2 = $item['link_2']['url'] ?? '';

            $output .= $this->render_contact_link($item['contact_info_1'], $link_1, $item['contact_type']);

            if (!empty($item['contact_info_2'])) {
                $output .= $this->render_contact_link($item['contact_info_2'], $link_2, $item['contact_type']);
            }
        }

        return $output;
    }

    /**
     * تابع برای رندر لینک تماس با پشتیبانی از HTML
     */
    private function render_contact_link($content, $link, $type)
    {
        if (!empty($link)) {
            // استخراج متن ساده از HTML برای لینک
            $plain_text = wp_strip_all_tags($content);
            $href = $type === 'phone' ? 'tel:' . preg_replace('/[^0-9+]/', '', $plain_text) : ($type === 'email' ? 'mailto:' . $plain_text : $link);

            return '<a href="' . esc_url($href) . '">' . wp_kses($content, $this->get_allowed_html_tags()) . '</a>';
        } else {
            return '<div>' . wp_kses($content, $this->get_allowed_html_tags()) . '</div>';
        }
    }

    /**
     * تابع برای دریافت تگ‌های HTML مجاز
     */
    private function get_allowed_html_tags()
    {
        return [
            'strong' => [],
            'em' => [],
            'b' => [],
            'i' => [],
            'u' => [],
            'span' => [
                'style' => [],
                'class' => [],
            ],
            'div' => [
                'style' => [],
                'class' => [],
            ],
            'a' => [
                'href' => [],
                'title' => [],
                'target' => [],
                'rel' => [],
                'class' => [],
            ],
        ];
    }
}
