<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Features extends Widget_Base
{
    public function get_name()
    {
        return 'Features';
    }

    public function get_title()
    {
        return __('ویژگی های لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    public function get_keywords()
    {
        return ['features', 'ویژگی', 'lamkadeh', 'امکانات'];
    }

    protected function register_controls()
    {
        // بخش تنظیمات محتوا
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __('عنوان اصلی', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('ویــــژگی های فروشـگاه ما', 'lamkadeh'),
                'placeholder' => __('عنوان اصلی را وارد کنید', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('توضیحات', 'lamkadeh'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('ما اینجاییم تا <strong>تجــــربه‌ای راحت و مطمئن</strong> بـــــــرات بسازیم', 'lamkadeh'),
                'placeholder' => __('توضیحات را وارد کنید', 'lamkadeh'),
            ]
        );

        // ویژگی‌ها
        $this->add_control(
            'features_heading',
            [
                'label' => __('ویژگی‌ها', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => __('آیکون', 'lamkadeh'),
                'type' => Controls_Manager::SELECT,
                'default' => 'support',
                'options' => [
                    'support' => __('پشتیبانی', 'lamkadeh'),
                    'shipping' => __('ارسال', 'lamkadeh'),
                    'quality' => __('کیفیت', 'lamkadeh'),
                    'guarantee' => __('ضمانت', 'lamkadeh'),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                'placeholder' => __('عنوان ویژگی را وارد کنید', 'lamkadeh'),
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label' => __('زیرعنوان', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                'placeholder' => __('زیرعنوان را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'features_list',
            [
                'label' => __('لیست ویژگی‌ها', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon' => 'support',
                        'title' => __('۷ روز هفته, ۲۴ ساعته', 'lamkadeh'),
                        'subtitle' => __('همیشه پاسخگوی شماییم', 'lamkadeh'),
                    ],
                    [
                        'icon' => 'shipping',
                        'title' => __('ارسال سریع و رایگان', 'lamkadeh'),
                        'subtitle' => __('در کمترین زمان ممکن', 'lamkadeh'),
                    ],
                    [
                        'icon' => 'quality',
                        'title' => __('کیفیت تضمینی', 'lamkadeh'),
                        'subtitle' => __('محصولات با کیفیت عالی', 'lamkadeh'),
                    ],
                    [
                        'icon' => 'guarantee',
                        'title' => __('ضمانت بازگشت', 'lamkadeh'),
                        'subtitle' => __('۷ روز ضمانت بازگشت', 'lamkadeh'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        // تصاویر
        $this->add_control(
            'images_heading',
            [
                'label' => __('تصاویر', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'left_image',
            [
                'label' => __('تصویر سمت چپ', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/products/chair.png',
                ],
            ]
        );

        $this->add_control(
            'right_image',
            [
                'label' => __('تصویر سمت راست', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/products/sofa.png',
                ],
            ]
        );

        $this->end_controls_section();

        // بخش تنظیمات استایل
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان اصلی', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .features-center-top-title-content span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('رنگ توضیحات', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .description-features-center-top' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'feature_title_color',
            [
                'label' => __('رنگ عنوان ویژگی‌ها', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .features-center-body-item-body div span:first-child' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'feature_subtitle_color',
            [
                'label' => __('رنگ زیرعنوان ویژگی‌ها', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .features-center-body-item-body div span:last-child' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __('رنگ پس‌زمینه', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .features' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // دریافت تصاویر
        $left_image_url = $settings['left_image']['url'] ?: get_template_directory_uri() . '/assets/images/products/chair.png';
        $right_image_url = $settings['right_image']['url'] ?: get_template_directory_uri() . '/assets/images/products/sofa.png';
?>
        <section class="features">
            <section class="features-content">
                <svg width="71" height="60" viewBox="0 0 71 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <!-- SVG content remains the same -->
                </svg>
            </section>
            <section class="features-center">
                <div class="features-center-top">
                    <div class="features-center-top-title">
                        <span>FEATURES OUR SHOP</span>
                        <div class="features-center-top-title-content">
                            <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_2_17046)">
                                    <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#1D2977" />
                                    <path d="M45.6932 20.1945C45.9617 19.926 45.9617 19.4907 45.6932 19.2222C45.4247 18.9538 44.9894 18.9538 44.7209 19.2222L40.6237 23.3194L39.2765 21.9722C39.008 21.7038 38.5727 21.7038 38.3042 21.9722C38.0357 22.2407 38.0357 22.676 38.3042 22.9445L40.1376 24.7778C40.406 25.0463 40.8413 25.0463 41.1098 24.7778L45.6932 20.1945Z" fill="#F7F8FD" fill-opacity="0.24" />
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M41.9987 12.1459C36.5564 12.1459 32.1445 16.5577 32.1445 22C32.1445 27.4423 36.5564 31.8542 41.9987 31.8542C47.441 31.8542 51.8529 27.4423 51.8529 22C51.8529 16.5577 47.441 12.1459 41.9987 12.1459ZM33.5195 22C33.5195 17.3171 37.3158 13.5209 41.9987 13.5209C46.6816 13.5209 50.4779 17.3171 50.4779 22C50.4779 26.683 46.6816 30.4792 41.9987 30.4792C37.3158 30.4792 33.5195 26.683 33.5195 22Z" fill="#F7F8FD" fill-opacity="0.24" />
                                    <circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.06" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_2_17046">
                                        <rect width="64" height="64" rx="32" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>
                            <span><?php echo esc_html($settings['main_title']); ?></span>
                        </div>
                        <div class="features-center-top-title-shape"></div>
                    </div>
                    <span class="description-features-center-top">
                        <?php echo wp_kses($settings['description'], ['strong' => []]); ?>
                    </span>
                </div>
                <div class="features-center-body">
                    <?php foreach ($settings['features_list'] as $feature): ?>
                        <div class="features-center-body-item">
                            <div class="features-center-body-item-rectangle"></div>
                            <div class="features-center-body-item-body">
                                <?php echo $this->get_feature_icon($feature['icon']); ?>
                                <div>
                                    <span><?php echo esc_html($feature['title']); ?></span>
                                    <span><?php echo esc_html($feature['subtitle']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </section>
            <section class="features-left">
                <svg width="84" height="52" viewBox="0 0 84 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M82.4017 1.23486C62.4043 4.19215 25.101 15.9879 31.0926 40.7673C35.1833 57.6852 54.1928 49.6358 49.0001 31.2998C43.8075 12.9638 11.2496 10.8317 6.29495 47.7901M6.29495 47.7901L12.8906 44.1366M6.29495 47.7901L1.65956 38.8748" stroke="#F7F8FD" stroke-width="2" stroke-linecap="round" />
                </svg>
                <img src="<?php echo esc_url($left_image_url); ?>" alt="<?php echo esc_attr__('ویژگی‌های لمکده', 'lamkadeh'); ?>">
                <div class="features-left-circle"></div>
            </section>
            <section class="features-right">
                <svg width="84" height="52" viewBox="0 0 84 52" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1.3835 1.91553C21.3809 4.87282 58.6842 16.6686 52.6926 41.448C48.6019 58.3659 29.5924 50.3165 34.785 31.9805C39.9777 13.6445 72.5356 11.5123 77.4902 48.4708M77.4902 48.4708L70.8946 44.8172M77.4902 48.4708L82.1256 39.5555" stroke="#F7F8FD" stroke-width="2" stroke-linecap="round" />
                </svg>
                <img src="<?php echo esc_url($right_image_url); ?>" alt="<?php echo esc_attr__('ویژگی‌های لمکده', 'lamkadeh'); ?>">
                <div class="features-right-circle"></div>
            </section>
        </section>
<?php
    }

    /**
     * تابع برای دریافت آیکون بر اساس نوع ویژگی
     */
    private function get_feature_icon($type)
    {
        switch ($type) {
            case 'support':
                return '
                    <svg width="76" height="76" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="2" y="2" width="52" height="52" rx="26" fill="#FFD701" />
                        <rect x="2" y="2" width="52" height="52" rx="26" stroke="white" stroke-width="4" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M37.5703 35.6317C39.6816 35.6317 41.3932 33.8885 41.3932 31.7381C41.3932 29.5875 39.6816 27.8442 37.5703 27.8442L37.5703 35.6317Z" fill="#1D2977" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M38.1777 34.954L38.1777 28.522C39.661 28.8124 40.7851 30.1441 40.7851 31.7382C40.7851 33.3322 39.661 34.6639 38.1777 34.954ZM38.4834 16.4732C36.2154 14.1633 33.2117 12.8909 30.0256 12.8909C26.8395 12.8909 23.8356 14.1633 21.5675 16.4732C20.7053 17.3517 19.9902 18.3382 19.4351 19.4021C19.0783 20.395 20.23 20.6375 20.5095 19.9773C22.3156 16.5022 25.9037 14.1291 30.0256 14.1291C35.9584 14.1291 40.7851 19.0452 40.7851 25.0879L40.7851 28.6378C39.977 27.7689 38.8351 27.2253 37.57 27.2253C37.2341 27.2253 36.962 27.5024 36.962 27.8443L36.962 35.6318C36.962 35.9739 37.2341 36.251 37.57 36.251C39.9902 36.251 41.9624 34.2638 41.9991 31.8073C41.9993 31.7998 42 29.5598 42.0006 25.0879C42.0006 21.8428 40.7515 18.7833 38.4834 16.4732Z" fill="#1D2977" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M40.8908 35.5695C40.7367 35.5695 40.5854 35.6335 40.4763 35.7443C40.3673 35.8554 40.3047 36.0095 40.3047 36.1672C40.3047 36.3236 40.3673 36.4775 40.4763 36.5894C40.5854 36.7003 40.7367 36.7636 40.8908 36.7636C41.0449 36.7636 41.1962 36.7003 41.3053 36.5894C41.4144 36.4775 41.4769 36.3242 41.4769 36.1672C41.4769 36.0095 41.4144 35.8554 41.3053 35.7443C41.1962 35.6335 41.0449 35.5695 40.8908 35.5695Z" fill="#1D2977" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M32.114 41.4912L32.9765 41.3045L33.1599 42.183L32.2974 42.3697L32.114 41.4912ZM40.5604 37.5154C40.2698 37.3445 39.8977 37.4458 39.7299 37.7418C38.5503 39.8218 36.6964 41.2524 34.3453 41.9076L34.0394 40.4415C33.9694 40.1069 33.6468 39.8935 33.3183 39.9644L31.2668 40.4086C30.9382 40.4798 30.7287 40.8085 30.7986 41.1431L31.2347 43.2326C31.3044 43.5672 31.6271 43.7806 31.9556 43.7096L34.0073 43.2655C36.9858 42.6207 39.3287 40.9248 40.7826 38.3613C40.9507 38.0653 40.851 37.6866 40.5604 37.5154Z" fill="#1D2977" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M16.7392 36.458C15.5995 36.458 14.6758 35.517 14.6758 34.3562L14.6758 23.3353C14.6758 22.1745 15.5995 21.2336 16.7392 21.2336L31.6033 21.2336C32.743 21.2336 33.6668 22.1745 33.6668 23.3353L33.6668 37.1883C33.6668 37.9269 33.0789 38.5257 32.3538 38.5257C31.9581 38.5257 31.5835 38.3442 31.3343 38.0313L30.0805 36.458L16.7392 36.458ZM16.7392 22.3799C16.2213 22.3799 15.8012 22.8077 15.8012 23.3353L15.8012 34.3562C15.8012 34.8838 16.2213 35.3117 16.7392 35.3117L30.6165 35.3117L32.208 37.3087C32.2436 37.3535 32.2973 37.3794 32.3538 37.3794C32.4575 37.3794 32.5414 37.2939 32.5414 37.1883L32.5414 23.3353C32.5414 22.8077 32.1213 22.3799 31.6033 22.3799L16.7392 22.3799Z" fill="#F7F8FD" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M27.627 28.2499L31.4104 28.2499L31.4104 29.2524L29.4268 34.2478H28.2045L30.1299 29.3809L27.627 29.3809L27.627 28.2499ZM26.1357 28.1429L26.1357 29.2397L25.5079 29.2397L25.5079 30.2594L24.3443 30.2594L24.3443 29.2397L21.5737 29.2397L21.5737 28.1429L23.5916 24.1416L24.8305 24.1416L22.8209 28.1429L24.3443 28.1429L24.3443 26.7206L25.5079 26.7206L25.5079 28.1429L26.1357 28.1429ZM17.0302 30.2594L17.0302 29.3768L19.0306 27.2691C19.4075 26.8664 19.7004 26.4722 19.7004 26.0695C19.7004 25.5896 19.3823 25.2897 18.9386 25.2897C18.4868 25.2897 18.1519 25.5639 17.9594 25.9923L16.9883 25.4096C17.3651 24.5528 18.1267 24.1416 18.9221 24.1416C19.9265 24.1416 20.8556 24.8269 20.8556 26.0265C20.8556 26.7547 20.4454 27.3804 19.8929 27.9458L18.7461 29.1198L20.9476 29.1198L20.9476 30.2594L17.0302 30.2594Z" fill="#1D2977" />
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M28.9103 24.3535L23.6836 34.2476H24.1901L29.4133 24.3535L28.9103 24.3535Z" fill="#1D2977" />
                    </svg>
                ';

            case 'shipping':
                return '
                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="2" y="2" width="52" height="52" rx="26" fill="#FFD701"/>
<rect x="2" y="2" width="52" height="52" rx="26" stroke="white" stroke-width="4"/>
<path d="M22.5427 42.9435H16.7353C16.067 42.9435 15.5254 42.4018 15.5254 41.7336V31.873C15.5254 31.2047 16.0671 30.6631 16.7353 30.6631H22.5428C23.211 30.6631 23.7527 31.2047 23.7527 31.873V41.7336C23.7527 42.4018 23.211 42.9435 22.5427 42.9435Z" fill="#F7F8FD"/>
<path d="M19.6391 39.9189C19.4801 39.9189 19.324 39.9836 19.2114 40.0962C19.0989 40.2088 19.0342 40.3648 19.0342 40.5239C19.0342 40.683 19.0989 40.8391 19.2114 40.9516C19.324 41.0641 19.4801 41.1289 19.6391 41.1289C19.7983 41.1289 19.9543 41.0642 20.0668 40.9516C20.1793 40.8391 20.2441 40.683 20.2441 40.5239C20.2441 40.3648 20.1794 40.2087 20.0668 40.0962C19.9543 39.9835 19.7982 39.9189 19.6391 39.9189Z" fill="#1D2977"/>
<path d="M42.897 24.2397C42.7379 24.2397 42.5818 24.3044 42.4693 24.417C42.3568 24.5295 42.292 24.6856 42.292 24.8447C42.292 25.0038 42.3567 25.1599 42.4693 25.2723C42.5818 25.3849 42.7379 25.4496 42.897 25.4496C43.0567 25.4496 43.2122 25.385 43.3247 25.2723C43.4377 25.1599 43.5025 25.0038 43.5025 24.8447C43.5025 24.6856 43.4377 24.5295 43.3247 24.417C43.2122 24.3044 43.0567 24.2397 42.897 24.2397Z" fill="#1D2977"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M45.2887 19.5571C45.4491 19.5571 45.6031 19.6209 45.7165 19.7343C45.83 19.8478 45.8936 20.0016 45.8938 20.1621V42.9433C45.8938 43.2773 45.6228 43.5482 45.2888 43.5482H27.0269C26.2901 43.5482 25.5787 43.2816 25.0234 42.7973L24.3041 42.1701C24.1081 42.9604 23.3929 43.5481 22.5428 43.5481H16.7352C15.7345 43.5481 14.9203 42.734 14.9204 41.7332V31.8726C14.9204 30.872 15.7345 30.0578 16.7352 30.0578H22.5427C23.1642 30.0578 23.7136 30.372 24.0409 30.8498L25.9621 28.9285C26.1787 28.7119 26.6232 28.3459 27.3832 27.94C28.5432 27.3205 29.802 26.8775 29.802 26.8775V21.8929V20.1628C29.802 19.8288 30.0729 19.5579 30.407 19.5579L45.2887 19.5571ZM16.7352 42.3383H22.5426C22.8762 42.3383 23.1476 42.0669 23.1477 41.7333V31.8727C23.1477 31.5391 22.8763 31.2677 22.5427 31.2677H20.2439V38.2366C20.2439 38.5706 19.973 38.8415 19.6389 38.8415C19.3048 38.8415 19.034 38.5706 19.034 38.2366V31.2677H16.7352C16.4016 31.2677 16.1302 31.5391 16.1302 31.8727V41.7333C16.1302 42.0669 16.4016 42.3383 16.7352 42.3383ZM25.8184 41.8855L24.3575 40.6114V32.2442L26.3167 30.2564C26.3167 30.2564 27.149 29.5356 27.7095 29.2195C28.8907 28.5533 29.8003 28.2915 29.8003 28.2915V29.9178L29.2142 31.4773C29.2827 31.7451 29.524 31.9323 29.8003 31.9323L39.9576 31.9331C40.4246 31.9331 40.8045 32.313 40.8045 32.78C40.8045 33.247 40.4246 33.627 39.9576 33.627H33.8632C33.5291 33.627 33.2583 33.8979 33.2583 34.232C33.2583 34.566 33.5291 34.8369 33.8632 34.8369H41.8511C42.3181 34.8369 42.6981 35.2169 42.6981 35.6839C42.6981 36.1509 42.3181 36.5308 41.8511 36.5308H33.8632C33.5291 36.5308 33.2583 36.8018 33.2583 37.1358C33.2583 37.4698 33.5291 37.7408 33.8632 37.7408H40.5567C41.0237 37.7408 41.4036 38.1207 41.4036 38.5877C41.4036 39.0547 41.0237 39.4346 40.5567 39.4346H33.8632C33.5291 39.4346 33.2583 39.7056 33.2583 40.0396C33.2583 40.3737 33.5291 40.6446 33.8632 40.6446H38.4932C38.9602 40.6446 39.3401 41.0245 39.3401 41.4915C39.3401 41.9586 38.9602 42.3385 38.4932 42.3385H27.0268C26.5825 42.3383 26.1534 42.1775 25.8184 41.8855ZM40.55 41.4913C40.55 41.7932 40.4841 42.0798 40.3668 42.3383H44.6838V21.0243L31.012 21.025V30.7231L39.9575 30.7232C41.0917 30.7232 42.0143 31.6459 42.0143 32.78C42.0143 33.0819 41.9485 33.3685 41.851 33.627C42.0024 33.627 42.1498 33.644 42.292 33.6751V26.7911C42.292 26.4571 42.5629 26.1861 42.897 26.1861C43.231 26.1861 43.5019 26.4571 43.5019 26.7911V34.4585C43.7567 34.8009 43.9079 35.225 43.9079 35.6838C43.9079 36.6296 43.2661 37.4278 42.3951 37.667C42.5346 37.9442 42.6135 38.2568 42.6135 38.5875C42.6135 39.7217 41.6908 40.6444 40.5567 40.6444H40.3668C40.4841 40.9029 40.55 41.1894 40.55 41.4913Z" fill="#1D2977"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M33.0234 20.8501H36.3855V30.9356H33.0234V20.8501Z" fill="#1D2977"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M13.4976 18.9101C13.4976 21.1632 15.4084 24.4655 19.2116 28.9377C19.4697 29.2413 19.9384 29.2413 20.1966 28.9377C23.9998 24.4655 25.9105 21.1632 25.9105 18.9101C25.9105 15.4824 23.1318 12.7036 19.704 12.7036C16.2763 12.7036 13.4976 15.4824 13.4976 18.9101ZM19.704 13.9966C22.4177 13.9966 24.6175 16.1964 24.6175 18.9101C24.6175 20.6655 22.985 23.5685 19.704 27.5145C16.4231 23.5685 14.7906 20.6655 14.7906 18.9101C14.7906 16.1964 16.9904 13.9966 19.704 13.9966Z" fill="#F7F8FD"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M16.6655 18.9107C16.6655 20.5889 18.026 21.9493 19.7041 21.9493C21.3823 21.9493 22.7428 20.5889 22.7428 18.9107C22.7428 17.2325 21.3823 15.8721 19.7041 15.8721C18.026 15.8721 16.6655 17.2325 16.6655 18.9107ZM21.579 18.9107C21.579 19.9461 20.7396 20.7855 19.7041 20.7855C18.6687 20.7855 17.8293 19.9461 17.8293 18.9107C17.8293 17.8752 18.6687 17.0358 19.7041 17.0358C20.7396 17.0358 21.579 17.8752 21.579 18.9107Z" fill="#F7F8FD"/>
</svg>
                ';

            case 'quality':
                return '
                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="2" y="2" width="52" height="52" rx="26" fill="#FFD701"/>
<rect x="2" y="2" width="52" height="52" rx="26" stroke="white" stroke-width="4"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M39.3283 30.0356L39.3107 29.9199C39.1814 29.0757 39.1715 28.7503 39.2669 28.3971C39.3572 28.0627 39.5258 27.7949 40.0507 27.1482C40.7603 26.2741 40.9385 25.9456 40.9384 25.4288C40.9384 24.9121 40.7602 24.5836 40.0506 23.7095L39.9936 23.6393C39.5298 23.0665 39.3535 22.7815 39.2669 22.4608C39.2013 22.2181 39.1889 21.9357 39.2269 21.5558C39.2426 21.3986 39.2613 21.261 39.3107 20.9381C39.4781 19.8453 39.4678 19.4915 39.2171 19.0627C38.9708 18.6412 38.6338 18.4318 37.6826 18.0645L37.6051 18.0346C36.8096 17.7283 36.5228 17.5765 36.2675 17.3238C36.0122 17.071 35.8591 16.7874 35.5498 16.0001L35.5194 15.9232C35.1484 14.9815 34.9367 14.6476 34.511 14.4038C34.0987 14.1676 33.6995 14.1513 32.6956 14.2999L32.5967 14.3147C32.2919 14.3604 32.1541 14.3788 31.9968 14.3942C31.6113 14.432 31.325 14.4198 31.0789 14.3547C30.7406 14.2652 30.4699 14.0982 29.8164 13.5785C28.9336 12.8763 28.6023 12.7002 28.0813 12.7002C27.6253 12.7002 27.2334 12.8891 26.5996 13.3788C26.5376 13.4267 26.4772 13.4743 26.3464 13.5782C25.6928 14.098 25.4221 14.265 25.0839 14.3545C24.7264 14.4491 24.3967 14.4392 23.544 14.3112C22.4411 14.1456 22.0844 14.1558 21.6519 14.4035C21.2119 14.6555 21.0203 14.9635 20.6132 15.9997C20.304 16.7868 20.1507 17.0706 19.8954 17.3233C19.6619 17.5544 19.3561 17.7232 18.7363 17.9651C18.689 17.9835 18.6517 17.998 18.5578 18.0341L18.48 18.0641C17.5289 18.4313 17.192 18.6407 16.9456 19.0622C16.7066 19.4712 16.69 19.8672 16.8403 20.8621L16.8552 20.9594C16.9014 21.2611 16.9199 21.3974 16.9355 21.5531C16.9737 21.9343 16.9613 22.2173 16.8957 22.4605C16.8048 22.7966 16.6339 23.066 16.0764 23.7529C16.0033 23.8431 15.9571 23.9008 15.911 23.9592C15.4152 24.5878 15.2241 24.9761 15.2241 25.4288C15.2241 25.8809 15.4151 26.2694 15.9094 26.8963C15.958 26.958 16.0064 27.0182 16.1117 27.148C16.6365 27.7945 16.8053 28.0625 16.8956 28.3969C16.9612 28.6397 16.9736 28.9223 16.9356 29.3027C16.9198 29.4597 16.9011 29.5971 16.8517 29.9196C16.6844 31.0122 16.6947 31.3661 16.9453 31.7949C17.1917 32.2164 17.5287 32.4258 18.4799 32.7931L18.5574 32.823C19.3528 33.1293 19.6397 33.2811 19.8951 33.5339C20.1503 33.7865 20.3035 34.0702 20.6128 34.8575L20.6431 34.9345C21.0142 35.8761 21.2259 36.21 21.6516 36.4538C22.0639 36.6899 22.4631 36.7063 23.4673 36.5576L23.5665 36.5427C23.8718 36.4969 24.0099 36.4786 24.1676 36.4632C24.3125 36.4489 24.4403 36.442 24.5581 36.442C24.7572 36.442 24.9292 36.462 25.0836 36.5028C25.4219 36.5923 25.6926 36.7593 26.3461 37.279C27.229 37.9813 27.5602 38.1574 28.0813 38.1574C28.6023 38.1574 28.9335 37.9813 29.8163 37.2791L29.8874 37.2227C30.466 36.7634 30.7542 36.5888 31.0787 36.5029C31.4362 36.4083 31.7654 36.4182 32.6185 36.5462C33.7214 36.7118 34.0781 36.7016 34.5107 36.454C34.9507 36.2019 35.1423 35.894 35.5494 34.8577C35.8586 34.0707 36.0119 33.7869 36.2672 33.5342C36.5226 33.2813 36.8093 33.1296 37.6048 32.8233L37.6826 32.7933C38.6336 32.4261 38.9706 32.2167 39.217 31.7952C39.456 31.3862 39.4726 30.9903 39.3283 30.0356ZM39.6205 25.4289C39.6205 25.538 39.4564 25.796 39.0242 26.3285C38.3663 27.1391 38.1434 27.5053 37.9939 28.0589C37.8398 28.6295 37.8474 29.0685 38.0105 30.1338L38.025 30.2294C38.1063 30.7678 38.1161 31.0725 38.0768 31.1397C38.0316 31.2172 37.7571 31.3619 37.2045 31.5753L37.1279 31.6048C36.1362 31.9865 35.7525 32.1968 35.3362 32.6089C34.9198 33.0211 34.7071 33.4015 34.3214 34.3831C34.0785 35.0014 33.9351 35.2742 33.8517 35.3219C33.7763 35.3651 33.4638 35.3511 32.8157 35.2538C31.7568 35.0949 31.3139 35.0878 30.739 35.24C30.201 35.3823 29.8015 35.6168 29.064 36.2021L28.9919 36.2594C28.4531 36.6879 28.1927 36.8502 28.0813 36.8502C27.9698 36.8502 27.7093 36.6878 27.1706 36.2593C26.3518 35.6082 25.9821 35.3877 25.4233 35.2399C25.1546 35.1687 24.8706 35.1349 24.5581 35.1349C24.3955 35.1349 24.2256 35.144 24.0381 35.1623C23.8512 35.1806 23.6965 35.2013 23.3287 35.2564L23.2323 35.2708C22.6875 35.3515 22.3792 35.3611 22.3106 35.3218C22.232 35.2768 22.0861 35.0057 21.8705 34.4586L21.8407 34.3828C21.4549 33.4009 21.2424 33.0209 20.8261 32.6087C20.4098 32.1966 20.0259 31.9862 19.0343 31.6045L18.958 31.575C18.4051 31.3616 18.1308 31.2169 18.0855 31.1393C18.0422 31.0653 18.057 30.7536 18.158 30.094C18.2081 29.7669 18.2287 29.6147 18.247 29.4317C18.3007 28.8944 18.2785 28.4658 18.1686 28.0587C18.0183 27.5024 17.7937 27.1357 17.1034 26.2854C17.0336 26.1992 16.9898 26.1447 16.9475 26.091C16.6766 25.7475 16.5419 25.5142 16.5419 25.4288C16.5419 25.3432 16.6769 25.1094 16.9489 24.7646C16.9929 24.7089 17.0378 24.6529 17.1385 24.5289C17.7962 23.7184 18.0191 23.3522 18.1687 22.7986C18.2787 22.391 18.3008 21.962 18.2469 21.4239C18.2284 21.2393 18.2076 21.0866 18.1521 20.7236L18.1376 20.6281C18.0562 20.0896 18.0464 19.7849 18.0857 19.7177C18.131 19.6403 18.4054 19.4957 18.9581 19.2822L19.0346 19.2527C19.1306 19.2157 19.1692 19.2008 19.2187 19.1815C20.0193 18.8691 20.4426 18.6285 20.8264 18.2484C21.2427 17.8362 21.4554 17.456 21.8411 16.4744C22.084 15.856 22.2275 15.5833 22.3109 15.5355C22.3863 15.4924 22.6987 15.5063 23.3469 15.6036C24.4051 15.7625 24.8485 15.7696 25.4234 15.6176C25.985 15.469 26.3549 15.2469 27.2143 14.5634C27.3008 14.4947 27.3555 14.4517 27.4094 14.41C27.7578 14.1409 27.9939 14.0073 28.0813 14.0073C28.1927 14.0073 28.4532 14.1697 28.992 14.5982C29.8107 15.2493 30.1805 15.4698 30.7392 15.6177C31.1505 15.7264 31.5834 15.7483 32.1265 15.695C32.313 15.6767 32.4672 15.6561 32.8343 15.6011L32.9308 15.5867C33.4752 15.5061 33.7833 15.4965 33.8519 15.5358C33.9306 15.5808 34.0764 15.8518 34.292 16.399L34.3219 16.4748C34.7076 17.4567 34.9201 17.8367 35.3365 18.2489C35.7528 18.661 36.1365 18.8713 37.1281 19.2531L37.2045 19.2825C37.7573 19.496 38.0317 19.6407 38.077 19.7183C38.1203 19.7923 38.1055 20.1041 38.0045 20.7636C37.9543 21.0912 37.9337 21.2436 37.9154 21.427C37.8618 21.9637 37.884 22.3921 37.9939 22.799C38.1378 23.332 38.3748 23.7277 38.9662 24.4579L39.0241 24.5293C39.4564 25.0618 39.6205 25.3198 39.6205 25.4289Z" fill="#1D2977"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M28.3383 33.6577C32.8118 33.6577 36.4383 30.0888 36.4383 25.6863C36.4383 21.2838 32.8118 17.7148 28.3383 17.7148C23.8648 17.7148 20.2383 21.2838 20.2383 25.6863C20.2383 30.0888 23.8648 33.6577 28.3383 33.6577ZM33.3196 20.9339C33.0051 20.7073 32.5651 20.7765 32.3366 21.0883L26.6334 28.8745L23.9509 26.7631C23.6465 26.5235 23.2038 26.574 22.9622 26.8759C22.7206 27.1779 22.7715 27.6169 23.076 27.8566L26.3337 30.4207C26.6473 30.6675 27.1052 30.6055 27.3405 30.2842L33.4753 21.9087C33.7037 21.5969 33.634 21.1604 33.3196 20.9339Z" fill="#F7F8FD"/>
<path d="M28.3384 17.1997C28.6321 17.1997 28.8702 17.4342 28.8702 17.7235C28.8702 18.0128 28.6321 18.2473 28.3384 18.2473C24.1682 18.2473 20.7876 21.5775 20.7876 25.6854C20.7876 29.7934 24.1682 33.1235 28.3384 33.1235C32.5086 33.1235 35.8892 29.7934 35.8892 25.6854C35.8892 25.3961 36.1272 25.1616 36.421 25.1616C36.7146 25.1616 36.9527 25.3961 36.9527 25.6854C36.9527 30.372 33.0959 34.1711 28.3384 34.1711C23.5809 34.1711 19.7241 30.372 19.7241 25.6854C19.7241 20.9989 23.5809 17.1997 28.3384 17.1997Z" fill="#1D2977"/>
<path d="M34.4995 37.5672C34.4995 37.2539 34.7608 37 35.0832 37C35.4056 37 35.6669 37.2539 35.6669 37.5672V42.8611C35.6669 43.2263 35.317 43.4963 34.951 43.4136L28.3895 41.9307L21.7237 43.414C21.3583 43.4953 21.0098 43.2255 21.0098 42.8611V39.3318C21.0098 39.0186 21.2711 38.7646 21.5935 38.7646C21.9158 38.7646 22.1772 39.0186 22.1772 39.3318V42.1493L28.2603 40.7957C28.3467 40.7765 28.4364 40.7766 28.5228 40.7961L34.4995 42.1469V37.5672Z" fill="#F7F8FD"/>
<path d="M21.6527 37C21.4836 37 21.3177 37.0688 21.1981 37.1883C21.0786 37.308 21.0098 37.4738 21.0098 37.6435C21.0098 37.812 21.0786 37.9778 21.1981 38.098C21.3177 38.2176 21.4836 38.2857 21.6527 38.2857C21.8217 38.2857 21.9876 38.2176 22.1071 38.098C22.2267 37.9778 22.2955 37.8126 22.2955 37.6435C22.2955 37.4738 22.2267 37.308 22.1071 37.1883C21.9876 37.0688 21.8217 37 21.6527 37Z" fill="#F7F8FD"/>
<path d="M30.3953 17.1997C30.2262 17.1997 30.0603 17.2685 29.9408 17.388C29.8212 17.5077 29.7524 17.6735 29.7524 17.8432C29.7524 18.0117 29.8212 18.1775 29.9408 18.2977C30.0603 18.4173 30.2262 18.4854 30.3953 18.4854C30.5643 18.4854 30.7302 18.4173 30.8498 18.2977C30.9694 18.1775 31.0382 18.0123 31.0382 17.8432C31.0382 17.6735 30.9694 17.5077 30.8498 17.388C30.7302 17.2685 30.5643 17.1997 30.3953 17.1997Z" fill="#1D2977"/>
</svg>
                ';

            case 'guarantee':
                return '
                   <svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="2" y="2" width="52" height="52" rx="26" fill="#FFD701"/>
<rect x="2" y="2" width="52" height="52" rx="26" stroke="white" stroke-width="4"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M24.9755 15.1514L37.088 18.9365V24.8641L33.0807 26.1687V20.535L20.4712 16.5151L24.9755 15.1514Z" fill="#F7F8FD"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M42.5966 18.0136C42.5661 17.8932 42.5093 17.8055 42.4324 17.7376C42.3964 17.7016 42.3563 17.6698 42.3129 17.6431C42.2884 17.6286 42.263 17.6158 42.2369 17.6047C42.2187 17.5944 28.1262 13.1047 28.1262 13.1047C28.0002 13.0647 27.865 13.0647 27.739 13.1047L13.6845 17.5766C13.4188 17.6602 13.2379 17.9062 13.2373 18.1848V33.517C13.2375 33.7958 13.4186 34.0422 13.6845 34.1259L18.6201 35.7944C18.7461 35.8344 19.0327 34.6808 19.0327 34.6808L14.515 33.05V18.6518L18.7741 17.2968L30.7205 21.0985L27.9307 21.9859L17.262 18.5924C16.9258 18.4855 16.5665 18.6713 16.4596 19.0076C16.3527 19.3438 16.5386 19.7031 16.8749 19.81L27.2918 23.1237V30.7168C27.2918 31.0697 27.5778 31.3557 27.9307 31.3557C28.2835 31.3557 28.5695 31.0697 28.5695 30.7168V23.1237L32.1899 21.9738V26.2119C32.1899 26.5646 32.4759 26.8507 32.8287 26.8507C32.8937 26.8503 32.9583 26.8401 33.0204 26.8206L34.5107 26.3454C34.8471 26.2384 35.0329 25.8792 34.926 25.5429C34.8191 25.2067 34.4599 25.0208 34.1236 25.1277L33.4656 25.3372V21.5681L36.7659 20.5179V24.287L36.0402 24.5176C35.7039 24.6246 35.518 24.9837 35.6249 25.32C35.709 25.5846 35.9543 25.7645 36.2318 25.7653C36.2968 25.7653 36.3616 25.7553 36.4235 25.7353L37.5951 25.3628C37.861 25.2792 38.042 25.0328 38.0423 24.754V20.109L41.3464 19.0587V33.0494L40.5159 33.3145C40.1764 33.4106 39.9791 33.7637 40.0752 34.1032C40.1714 34.4427 40.5245 34.64 40.864 34.5439C40.8758 34.5405 42.1769 34.1259 42.1769 34.1259C42.4429 34.0422 42.6239 33.7958 42.6241 33.517V18.1848C42.6228 18.1268 42.6135 18.0692 42.5966 18.0136ZM32.828 20.4278L20.8817 16.6267L23.3527 15.8402L35.2991 19.6414L32.828 20.4278ZM25.4603 15.1694L37.406 18.9712L39.877 18.1848L27.9307 14.3837L25.4603 15.1694Z" fill="#1D2977"/>
<path d="M16.5442 29.0615C16.2157 29.0615 15.9492 29.328 15.9492 29.6565V33.9791C15.9492 34.3077 16.2157 34.5741 16.5442 34.5741C16.8729 34.5741 17.1393 34.3077 17.1393 33.9791V29.6565C17.1393 29.328 16.8729 29.0615 16.5442 29.0615Z" fill="#1D2977"/>
<path d="M16.5439 27.2852C16.3875 27.2852 16.2341 27.3488 16.1235 27.4594C16.0128 27.57 15.9492 27.7235 15.9492 27.8805C15.9492 28.0363 16.0128 28.1897 16.1235 28.301C16.2341 28.4116 16.3875 28.4746 16.5439 28.4746C16.7004 28.4746 16.8538 28.4116 16.9644 28.301C17.075 28.1897 17.1386 28.0369 17.1386 27.8805C17.1386 27.7235 17.075 27.57 16.9644 27.4594C16.8538 27.3488 16.7004 27.2852 16.5439 27.2852Z" fill="#1D2977"/>
<path d="M18.8276 34.644C18.6712 34.644 18.5178 34.7076 18.4071 34.8183C18.2965 34.9289 18.2329 35.0824 18.2329 35.2394C18.2329 35.3952 18.2965 35.5486 18.4071 35.6599C18.5178 35.7705 18.6712 35.8335 18.8276 35.8335C18.984 35.8335 19.1375 35.7705 19.2481 35.6599C19.3587 35.5486 19.4223 35.3957 19.4223 35.2394C19.4223 35.0824 19.3587 34.9289 19.2481 34.8183C19.1375 34.7076 18.984 34.644 18.8276 34.644Z" fill="#1D2977"/>
<path d="M38.1522 26.6431C37.7994 26.6431 37.5133 26.9291 37.5133 27.2819V33.942C37.5099 37.1159 34.9377 39.688 31.7637 39.6915H24.0976C23.7449 39.6915 23.4588 39.9775 23.4588 40.3304V41.6585L18.8233 38.4138L23.4588 35.1691V36.4973C23.4588 36.8501 23.7449 37.1361 24.0976 37.1361H29.8472C31.9633 37.1341 33.6782 35.4192 33.6803 33.3031V33.0315C33.6803 32.6787 33.3942 32.3926 33.0414 32.3926C32.6886 32.3926 32.4026 32.6787 32.4026 33.0315V33.3031C32.4026 34.7144 31.2585 35.8584 29.8472 35.8584H24.7365V33.942C24.7363 33.5891 24.4501 33.3033 24.0973 33.3034C23.9665 33.3035 23.8389 33.3437 23.7316 33.4188L17.3432 37.8906C17.0541 38.0931 16.9841 38.4915 17.1865 38.7804C17.2292 38.8413 17.2823 38.8943 17.3432 38.937L23.7316 43.409C24.0207 43.6112 24.4191 43.5406 24.6212 43.2515C24.6962 43.1443 24.7364 43.0166 24.7365 42.8858V40.9692H31.7637C35.6429 40.9646 38.7865 37.8211 38.791 33.942V27.2819C38.791 26.9291 38.505 26.6431 38.1522 26.6431Z" fill="#F7F8FD"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M18.2329 23.479H24.6231V25.1331L21.2724 33.3753H19.2084L22.46 25.3452H18.2329V23.479Z" fill="#F7F8FD"/>
</svg>

                ';

            default:
                return '
                    <svg width="76" height="76" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="2" y="2" width="52" height="52" rx="26" fill="#FFD701" />
                        <rect x="2" y="2" width="52" height="52" rx="26" stroke="white" stroke-width="4" />
                        <circle cx="28" cy="28" r="8" stroke="#1D2977" stroke-width="2"/>
                        <path d="M28 20V28L33 33" stroke="#1D2977" stroke-width="2"/>
                    </svg>
                ';
        }
    }
}
