<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Item_Content extends Widget_Base
{
    public function get_name()
    {
        return 'Item_Content';
    }

    public function get_title()
    {
        return __('آیتم محتوا لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-table-of-contents';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    protected function _register_controls()
    {
        // بخش محتوا
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        // عنوان آیتم
        $repeater->add_control(
            'item_title',
            [
                'label' => __('عنوان آیتم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('استفاده از مبل L شکل', 'lamkadeh'),
                'placeholder' => __('عنوان آیتم را وارد کنید', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        // محتوای آیتم
        $repeater->add_control(
            'item_content',
            [
                'label' => __('محتوای آیتم', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('<p>مبل L شکل بهترین انتخاب برای گوشه های اتاق پذیرایی است. این نوع مبل نه تنها فضای اتاق را بهینه می کند، بلکه ظاهری مدرن و شیک به دکوراسیون می بخشد.</p>', 'lamkadeh'),
                'placeholder' => __('محتوای آیتم را وارد کنید', 'lamkadeh'),
            ]
        );

        // نمایش شمارنده
        $repeater->add_control(
            'show_counter',
            [
                'label' => __('نمایش شمارنده', 'lamkadeh'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'lamkadeh'),
                'label_off' => __('مخفی', 'lamkadeh'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // شمارنده سفارشی
        $repeater->add_control(
            'custom_counter',
            [
                'label' => __('شمارنده سفارشی', 'lamkadeh'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'condition' => [
                    'show_counter' => 'yes'
                ],
                'description' => __('در صورت خالی بودن، شماره آیتم به صورت خودکار نمایش داده می‌شود', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __('آیتم‌های محتوا', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => __('استفاده از مبل L شکل', 'lamkadeh'),
                        'item_content' => __('<p>مبل L شکل بهترین انتخاب برای گوشه های اتاق پذیرایی است. این نوع مبل نه تنها فضای اتاق را بهینه می کند، بلکه ظاهری مدرن و شیک به دکوراسیون می بخشد.</p>', 'lamkadeh'),
                        'show_counter' => 'yes',
                    ],
                    [
                        'item_title' => __('انتخاب رنگ مناسب', 'lamkadeh'),
                        'item_content' => __('<p>رنگ مبلمان باید با دکوراسیون کلی اتاق هماهنگ باشد. برای فضاهای کوچک، رنگ‌های روشن توصیه می‌شود.</p>', 'lamkadeh'),
                        'show_counter' => 'yes',
                    ],
                    [
                        'item_title' => __('مبلمان چوبی طبیعی', 'lamkadeh'),
                        'item_content' => __('<p>مبلمان چوبی طبیعی علاوه بر استحکام بالا، حس گرمی و طبیعی به فضای داخلی می‌بخشد.</p>', 'lamkadeh'),
                        'show_counter' => 'yes',
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();

        // استایل‌ها
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل‌ها', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        // استایل کلی
        $this->add_control(
            'item_background',
            [
                'label' => __('پس‌زمینه آیتم', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget' => 'background-color: {{VALUE}};',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->add_control(
            'item_border_color',
            [
                'label' => __('رنگ حاشیه', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget' => 'border-color: {{VALUE}};',
                ],
                'default' => '#e0e0e0',
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'lamkadeh'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        // استایل عنوان
        $this->add_control(
            'title_style_heading',
            [
                'label' => __('عنوان', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget-content-title' => 'color: {{VALUE}};',
                ],
                'default' => '#1D2977',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .item-content-widget-content-title',
                'fields_options' => [
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18',
                        ],
                    ],
                ],
            ]
        );

        // استایل محتوا
        $this->add_control(
            'content_style_heading',
            [
                'label' => __('محتوای متنی', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => __('رنگ متن', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget-content-text' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .item-content-widget-content-text p' => 'color: {{VALUE}};',
                ],
                'default' => '#333333',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('تایپوگرافی متن', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .item-content-widget-content-text, {{WRAPPER}} .item-content-widget-content-text p',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14',
                        ],
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'em',
                            'size' => '1.6',
                        ],
                    ],
                ],
            ]
        );

        // استایل شمارنده
        $this->add_control(
            'counter_style_heading',
            [
                'label' => __('شمارنده', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'counter_background',
            [
                'label' => __('پس‌زمینه شمارنده', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget-counter' => 'background-color: {{VALUE}};',
                ],
                'default' => '#1D2977',
            ]
        );

        $this->add_control(
            'counter_color',
            [
                'label' => __('رنگ شمارنده', 'lamkadeh'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget-counter span' => 'color: {{VALUE}};',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'counter_typography',
                'label' => __('تایپوگرافی شمارنده', 'lamkadeh'),
                'selector' => '{{WRAPPER}} .item-content-widget-counter span',
                'fields_options' => [
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'counter_size',
            [
                'label' => __('اندازه شمارنده', 'lamkadeh'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 30,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget-counter' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
            ]
        );

        $this->add_control(
            'counter_border_radius',
            [
                'label' => __('گردی شمارنده', 'lamkadeh'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget-counter' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
            ]
        );

        // استایل فاصله‌ها
        $this->add_control(
            'spacing_heading',
            [
                'label' => __('فاصله‌ها', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_spacing',
            [
                'label' => __('فاصله بین آیتم‌ها', 'lamkadeh'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
            ]
        );

        $this->add_control(
            'content_padding',
            [
                'label' => __('فاصله داخلی آیتم', 'lamkadeh'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item-content-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '20',
                    'right' => '20',
                    'bottom' => '20',
                    'left' => '20',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if ($settings['items']) {
            $counter = 1;
            foreach ($settings['items'] as $item) {
?>
                <section class="item-content-widget">
                    <div class="item-content-widget-content">
                        <p class="item-content-widget-content-title"><?php echo esc_html($item['item_title']); ?></p>
                        <?php if (!empty($item['item_content'])): ?>
                            <div class="item-content-widget-content-text">
                                <?php echo wp_kses_post($item['item_content']); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if ($item['show_counter'] === 'yes'): ?>
                        <div class="item-content-widget-counter">
                            <span>
                                <?php
                                if (!empty($item['custom_counter'])) {
                                    echo esc_html($item['custom_counter']);
                                } else {
                                    echo esc_html($counter);
                                }
                                ?>
                            </span>
                        </div>
                    <?php endif; ?>
                </section>
        <?php
                $counter++;
            }
        }
    }

    protected function _content_template()
    {
        ?>
        <#
            var counter=1;
            #>
            <# if (settings.items) { #>
                <# _.each(settings.items, function(item, index) { #>
                    <section class="item-content-widget">
                        <div class="item-content-widget-content">
                            <p class="item-content-widget-content-title">{{{ item.item_title }}}</p>
                            <# if (item.item_content) { #>
                                <div class="item-content-widget-content-text">
                                    {{{ item.item_content }}}
                                </div>
                                <# } #>
                        </div>
                        <# if (item.show_counter==='yes' ) { #>
                            <div class="item-content-widget-counter">
                                <span>
                                    <# if (item.custom_counter) { #>
                                        {{{ item.custom_counter }}}
                                        <# } else { #>
                                            {{{ counter }}}
                                            <# } #>
                                </span>
                            </div>
                            <# } #>
                    </section>
                    <#
                        counter++;
                        #>
                        <# }); #>
                            <# } #>
                        <?php
                    }
                }
