<?php

namespace Elementor;

if (!defined('ABSPATH'))
    exit;

class Footer_Template_One extends Widget_Base
{
    public function get_name()
    {
        return 'Footer_Template_One';
    }

    public function get_title()
    {
        return __('فوتر لمکده', 'lamkadeh');
    }

    public function get_icon()
    {
        return 'eicon-footer';
    }

    public function get_categories()
    {
        return ['lamkadeh'];
    }

    private function get_available_menus()
    {
        $menus = wp_get_nav_menus();
        $options = [];

        foreach ($menus as $menu) {
            $options[$menu->slug] = $menu->name;
        }

        return $options;
    }

    private function render_menu_column($menu_item, $index)
    {
        ?>
        <div class="footer-body-top-section-one-list">
            <div class="footer-body-top-section-one-list-title footer-head-title-nav">
                <div></div>
                <span><?php echo esc_html($menu_item['menu_title']); ?></span>
                <div></div>
            </div>

            <div class="footer-body-top-section-one-list-body">
                <?php
                switch ($menu_item['menu_type']) {
                    case 'wp_menu':
                        $this->render_wp_menu($menu_item);
                        break;

                    case 'custom_links':
                        $this->render_custom_links($menu_item);
                        break;

                    case 'address':
                        $this->render_address($menu_item);
                        break;
                }
                ?>
            </div>
        </div>
        <?php
    }

    private function render_wp_menu($menu_item)
    {
        if (!empty($menu_item['wp_menu'])) {
            wp_nav_menu([
                'menu' => $menu_item['wp_menu'],
                'container' => false,
                'menu_class' => '',
                'items_wrap' => '<ul>%3$s</ul>',
                'fallback_cb' => false,
            ]);
        } else {
            echo '<p>' . __('لطفاً یک منو انتخاب کنید', 'lamkadeh') . '</p>';
        }
    }

    private function render_custom_links($menu_item)
    {
        if (!empty($menu_item['custom_links'])) {
            echo '<ul>';
            foreach ($menu_item['custom_links'] as $link) {
                $target = $link['link_url']['is_external'] ? ' target="_blank"' : '';
                $nofollow = $link['link_url']['nofollow'] ? ' rel="nofollow"' : '';

                echo '<li>';
                echo '<a href="' . esc_url($link['link_url']['url']) . '"' . $target . $nofollow . '>';
                echo esc_html($link['link_text']);
                echo '</a>';
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    private function render_address($menu_item)
    {
        if (!empty($menu_item['address_content'])) {
            echo '<div class="footer-address">';
            echo wp_kses_post(wpautop($menu_item['address_content']));
            echo '</div>';
        }
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'footer_top_section',
            [
                'label' => __('بخش بالایی فوتر', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // Box 1
        $this->add_control(
            'box_one_heading',
            [
                'label' => __('باکس اول', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image_box_one_footer',
            [
                'label' => __('تصویر باکس اول', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_option("image_box_one_footer", ''),
                ],
            ]
        );

        $this->add_control(
            'text_one_box_one',
            [
                'label' => __('متن اول باکس اول', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_one_box_one", ''),
                'placeholder' => __('متن اول را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'text_two_box_one',
            [
                'label' => __('متن دوم باکس اول', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_two_box_one", ''),
                'placeholder' => __('متن دوم را وارد کنید', 'lamkadeh'),
            ]
        );

        // Box 2
        $this->add_control(
            'box_two_heading',
            [
                'label' => __('باکس دوم', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image_box_two_footer',
            [
                'label' => __('تصویر باکس دوم', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_option("image_box_two_footer", ''),
                ],
            ]
        );

        $this->add_control(
            'text_one_box_two',
            [
                'label' => __('متن اول باکس دوم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_one_box_two", ''),
                'placeholder' => __('متن اول را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'text_two_box_two',
            [
                'label' => __('متن دوم باکس دوم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_two_box_two", ''),
                'placeholder' => __('متن دوم را وارد کنید', 'lamkadeh'),
            ]
        );

        // Box 3
        $this->add_control(
            'box_three_heading',
            [
                'label' => __('باکس سوم', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image_box_three_footer',
            [
                'label' => __('تصویر باکس سوم', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_option("image_box_three_footer", ''),
                ],
            ]
        );

        $this->add_control(
            'text_one_box_three',
            [
                'label' => __('متن اول باکس سوم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_one_box_three", ''),
                'placeholder' => __('متن اول را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'text_two_box_three',
            [
                'label' => __('متن دوم باکس سوم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_two_box_three", ''),
                'placeholder' => __('متن دوم را وارد کنید', 'lamkadeh'),
            ]
        );

        // Box 4
        $this->add_control(
            'box_four_heading',
            [
                'label' => __('باکس چهارم', 'lamkadeh'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image_box_four_footer',
            [
                'label' => __('تصویر باکس چهارم', 'lamkadeh'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_option("image_box_four_footer", ''),
                ],
            ]
        );

        $this->add_control(
            'text_one_box_four',
            [
                'label' => __('متن اول باکس چهارم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_one_box_four", ''),
                'placeholder' => __('متن اول را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'text_two_box_four',
            [
                'label' => __('متن دوم باکس چهارم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option("text_two_box_four", ''),
                'placeholder' => __('متن دوم را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->end_controls_section();

        // بخش آدرس و منوها
        $this->start_controls_section(
            'footer_address_section',
            [
                'label' => __('آدرس و فهرست ها', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'footer_menus_count',
            [
                'label' => __('تعداد ستون‌های منو', 'lamkadeh'),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => __('1 ستون', 'lamkadeh'),
                    '2' => __('2 ستون', 'lamkadeh'),
                    '3' => __('3 ستون', 'lamkadeh'),
                    '4' => __('4 ستون', 'lamkadeh'),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'menu_title',
            [
                'label' => __('عنوان منو', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => __('منوی فوتر', 'lamkadeh'),
                'placeholder' => __('عنوان منو را وارد کنید', 'lamkadeh'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'menu_type',
            [
                'label' => __('نوع محتوا', 'lamkadeh'),
                'type' => Controls_Manager::SELECT,
                'default' => 'wp_menu',
                'options' => [
                    'wp_menu' => __('منوی وردپرس', 'lamkadeh'),
                    'custom_links' => __('لینک‌های دستی', 'lamkadeh'),
                    'address' => __('آدرس', 'lamkadeh'),
                ],
            ]
        );

        $repeater->add_control(
            'wp_menu',
            [
                'label' => __('انتخاب منوی وردپرس', 'lamkadeh'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_available_menus(),
                'default' => '',
                'condition' => [
                    'menu_type' => 'wp_menu',
                ],
                'description' => __('منویی که از پیش در وردپرس ایجاد کرده‌اید را انتخاب کنید', 'lamkadeh'),
            ]
        );

        $repeater->add_control(
            'custom_links',
            [
                'label' => __('لینک‌های دستی', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'link_text',
                        'label' => __('متن لینک', 'lamkadeh'),
                        'type' => Controls_Manager::TEXT,
                        'default' => __('لینک نمونه', 'lamkadeh'),
                        'placeholder' => __('متن لینک را وارد کنید', 'lamkadeh'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'link_url',
                        'label' => __('آدرس لینک', 'lamkadeh'),
                        'type' => Controls_Manager::URL,
                        'placeholder' => __('https://example.com', 'lamkadeh'),
                        'default' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ],
                ],
                'title_field' => '{{{ link_text }}}',
                'condition' => [
                    'menu_type' => 'custom_links',
                ],
            ]
        );

        $repeater->add_control(
            'address_content',
            [
                'label' => __('محتوای آدرس', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('آدرس فروشگاه خود را اینجا وارد کنید', 'lamkadeh'),
                'condition' => [
                    'menu_type' => 'address',
                ],
            ]
        );

        $this->add_control(
            'footer_menus',
            [
                'label' => __('ستون‌های منو', 'lamkadeh'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'menu_title' => __('دسترسی سریع', 'lamkadeh'),
                        'menu_type' => 'wp_menu',
                    ],
                    [
                        'menu_title' => __('خدمات', 'lamkadeh'),
                        'menu_type' => 'custom_links',
                    ],
                    [
                        'menu_title' => __('آدرس فروشگاه‌ها', 'lamkadeh'),
                        'menu_type' => 'address',
                    ],
                ],
                'title_field' => '{{{ menu_title }}} - {{{ menu_type }}}',
            ]
        );


        $this->end_controls_section();

        // بخش شبکه‌های اجتماعی
        $this->start_controls_section(
            'social_media_section',
            [
                'label' => __('شبکه‌های اجتماعی', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'social_linkedin',
            [
                'label' => __('لینکدین', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://linkedin.com/your-profile', 'lamkadeh'),
                'default' => [
                    'url' => get_option('social_linkedin', ''),
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'social_telegram',
            [
                'label' => __('تلگرام', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://t.me/your-channel', 'lamkadeh'),
                'default' => [
                    'url' => get_option('social_telegram', ''),
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'social_facebook',
            [
                'label' => __('فیسبوک', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://facebook.com/your-page', 'lamkadeh'),
                'default' => [
                    'url' => get_option('social_facebook', ''),
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'social_instagram',
            [
                'label' => __('اینستاگرام', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://instagram.com/your-profile', 'lamkadeh'),
                'default' => [
                    'url' => get_option('social_instagram', ''),
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'social_text',
            [
                'label' => __('متن شبکه‌های اجتماعی', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => get_option('social_text', ''),
                'placeholder' => __('متن مربوط به شبکه‌های اجتماعی را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->end_controls_section();

        // بخش تماس و اطلاعات
        $this->start_controls_section(
            'contact_info_section',
            [
                'label' => __('تماس و اطلاعات', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'phone_shop',
            [
                'label' => __('شماره تلفن', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option('phone_shop', ''),
                'placeholder' => __('شماره تلفن را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'email_shop',
            [
                'label' => __('ایمیل', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option('email_shop', ''),
                'placeholder' => __('آدرس ایمیل را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->end_controls_section();

        // بخش لوگو و درباره ما
        $this->start_controls_section(
            'logo_about_section',
            [
                'label' => __('درباره ما', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'short_description_shop',
            [
                'label' => __('توضیح کوتاه فروشگاه', 'lamkadeh'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => get_option('short_description_shop', ''),
                'placeholder' => __('توضیح کوتاه فروشگاه را وارد کنید', 'lamkadeh'),
                'rows' => 3,
            ]
        );

        $this->add_control(
            'long_description_shop',
            [
                'label' => __('توضیح طولانی فروشگاه', 'lamkadeh'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => get_option('long_description_shop', ''),
                'placeholder' => __('توضیح طولانی فروشگاه را وارد کنید', 'lamkadeh'),
                'rows' => 5,
            ]
        );

        $this->add_control(
            'namad',
            [
                'label' => __('نماد اعتماد', 'lamkadeh'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => get_option('namad', ''),
                'placeholder' => __('کد نماد اعتماد را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->end_controls_section();

        // بخش کپی رایت
        $this->start_controls_section(
            'copyright_section',
            [
                'label' => __('کپی رایت', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'copyright',
            [
                'label' => __('متن کپی رایت', 'lamkadeh'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => get_option('copyright', ''),
                'placeholder' => __('متن کپی رایت را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'copyright_two',
            [
                'label' => __('متن توسعه‌دهنده', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option('copyright_two', ''),
                'placeholder' => __('متن توسعه‌دهنده را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'text_link_one_footer',
            [
                'label' => __('متن لینک اول', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option('text_link_one_footer', ''),
                'placeholder' => __('متن لینک اول را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'link_one_footer',
            [
                'label' => __('لینک اول', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://example.com', 'lamkadeh'),
                'default' => [
                    'url' => get_option('link_one_footer', ''),
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'text_link_two_footer',
            [
                'label' => __('متن لینک دوم', 'lamkadeh'),
                'type' => Controls_Manager::TEXT,
                'default' => get_option('text_link_two_footer', ''),
                'placeholder' => __('متن لینک دوم را وارد کنید', 'lamkadeh'),
            ]
        );

        $this->add_control(
            'link_two_footer',
            [
                'label' => __('لینک دوم', 'lamkadeh'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://example.com', 'lamkadeh'),
                'default' => [
                    'url' => get_option('link_two_footer', ''),
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->end_controls_section();

        // استایل‌ها
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'lamkadeh'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        // می‌توانید استایل‌های مختلف را اینجا اضافه کنید
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <footer>
            <section class="footer-top container">
                <div class="footer-wrapper">
                    <!-- Box 1 -->
                    <div class="box-footer-top">
                        <div class="box-footer-top-right">
                            <img src="<?php echo esc_url($settings['image_box_one_footer']['url']); ?>"
                                alt="<?php bloginfo("name") ?>">
                        </div>
                        <div class="box-footer-top-left">
                            <span><?php echo esc_html($settings['text_one_box_one']); ?></span>
                            <span><?php echo esc_html($settings['text_two_box_one']); ?></span>
                        </div>
                    </div>

                    <!-- Box 2 -->
                    <div class="box-footer-top">
                        <div class="box-footer-top-right">
                            <img src="<?php echo esc_url($settings['image_box_two_footer']['url']); ?>"
                                alt="<?php bloginfo("name") ?>">
                        </div>
                        <div class="box-footer-top-left">
                            <span><?php echo esc_html($settings['text_one_box_two']); ?></span>
                            <span><?php echo esc_html($settings['text_two_box_two']); ?></span>
                        </div>
                    </div>

                    <!-- Box 3 -->
                    <div class="box-footer-top">
                        <div class="box-footer-top-right">
                            <img src="<?php echo esc_url($settings['image_box_three_footer']['url']); ?>"
                                alt="<?php bloginfo("name") ?>">
                        </div>
                        <div class="box-footer-top-left">
                            <span><?php echo esc_html($settings['text_one_box_three']); ?></span>
                            <span><?php echo esc_html($settings['text_two_box_three']); ?></span>
                        </div>
                    </div>

                    <!-- Box 4 -->
                    <div class="box-footer-top">
                        <div class="box-footer-top-right">
                            <img src="<?php echo esc_url($settings['image_box_four_footer']['url']); ?>"
                                alt="<?php bloginfo("name") ?>">
                        </div>
                        <div class="box-footer-top-left">
                            <span><?php echo esc_html($settings['text_one_box_four']); ?></span>
                            <span><?php echo esc_html($settings['text_two_box_four']); ?></span>
                        </div>
                    </div>
                </div>
            </section>

            <section class="footer-body">
                <section class="footer-body-top container">
                    <section class="footer-body-top-section-one">
                        <div class="footer-body-top-section-one-lists">
                            <?php
                            if (!empty($settings['footer_menus'])) {
                                foreach ($settings['footer_menus'] as $index => $menu_item) {
                                    $this->render_menu_column($menu_item, $index);
                                }
                            }
                            ?>
                        </div>

                        <div class="underline-lamkadeh">
                            <div class="underline-lamkadeh-line"></div>
                            <div class="underline-lamkadeh-circle"></div>
                        </div>

                        <!-- شبکه‌های اجتماعی -->
                        <div class="footer-body-top-section-one-about-us">
                            <div class="footer-body-top-section-one-about-us-right">
                                <div class="footer-body-top-section-one-about-us-right-icon-social-media">
                                    <?php if ($settings['social_linkedin']['url']): ?>
                                        <a href="<?php echo esc_url($settings['social_linkedin']['url']); ?>" target="_blank"
                                            rel="nofollow">
                                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M0.394824 6.07696L4.17924 6.07696L4.17924 17.3648L0.394823 17.3648L0.394824 6.07696ZM2.31236 0.635742C1.01712 0.635742 0.170898 1.47856 0.170898 2.58479C0.170898 3.66827 0.992351 4.53559 2.26283 4.53559L2.28697 4.53559C3.60698 4.53559 4.42902 3.66823 4.42902 2.58479C4.40426 1.47856 3.60702 0.635742 2.31236 0.635742ZM13.471 5.8118C11.4622 5.8118 10.5623 6.90695 10.0602 7.67496L10.0602 6.07696L6.27466 6.07696C6.32478 7.13589 6.27466 17.3648 6.27466 17.3648L10.0602 17.3648L10.0602 11.0609C10.0602 10.7232 10.085 10.3869 10.1846 10.145C10.4587 9.47099 11.0815 8.77303 12.1262 8.77303C13.497 8.77303 14.0444 9.80862 14.0444 11.3254L14.0444 17.3647L17.8293 17.3647L17.8293 10.8921C17.8293 7.42502 15.9625 5.8118 13.471 5.8118Z"
                                                    fill="#1D2977" />
                                            </svg>
                                        </a>
                                    <?php endif; ?>

                                    <?php if ($settings['social_telegram']['url']): ?>
                                        <a href="<?php echo esc_url($settings['social_telegram']['url']); ?>" target="_blank"
                                            rel="nofollow">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_1_4248)">
                                                    <path
                                                        d="M6.23861 10.8158L14.4863 18.0727C14.5816 18.1571 14.6973 18.2152 14.8218 18.2414C14.9464 18.2676 15.0757 18.2609 15.1969 18.2221C15.3181 18.1832 15.4271 18.1135 15.5133 18.0197C15.5994 17.926 15.6597 17.8114 15.6882 17.6874L19.1377 2.62316C19.1666 2.49342 19.1598 2.35827 19.1179 2.23212C19.076 2.10598 19.0006 1.99358 18.8998 1.90692C18.7991 1.82026 18.6766 1.7626 18.5456 1.74009C18.4146 1.71759 18.28 1.73107 18.156 1.77912L1.22027 8.43049C0.541367 8.69655 0.63311 9.68737 1.34871 9.83416L6.23861 10.8158Z"
                                                        stroke="#1D2977" stroke-width="1.46789" stroke-linecap="round"
                                                        stroke-linejoin="round" />
                                                    <path d="M6.23877 10.8152L18.725 1.79688" stroke="#1D2977"
                                                        stroke-width="1.46789" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path
                                                        d="M10.358 14.4393L7.49565 17.3017C7.39353 17.4054 7.26289 17.4764 7.12033 17.5056C6.97777 17.5349 6.82973 17.5211 6.69501 17.4661C6.5603 17.411 6.44499 17.3171 6.36375 17.1964C6.28252 17.0756 6.23901 16.9334 6.23877 16.7879L6.23877 10.8154"
                                                        stroke="#1D2977" stroke-width="1.46789" stroke-linecap="round"
                                                        stroke-linejoin="round" />
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_1_4248">
                                                        <rect width="20" height="18.1651" fill="white"
                                                            transform="translate(0 0.916992)" />
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </a>
                                    <?php endif; ?>

                                    <?php if ($settings['social_facebook']['url']): ?>
                                        <a href="<?php echo esc_url($settings['social_facebook']['url']); ?>" target="_blank"
                                            rel="nofollow">
                                            <svg width="8" height="18" viewBox="0 0 8 18" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M7.83809 5.95667L5.22392 5.95667L5.22392 4.16416C5.22392 3.49098 5.65067 3.33403 5.95124 3.33403C6.25112 3.33403 7.79603 3.33403 7.79603 3.33403L7.79603 0.374626L5.25538 0.364258C2.43502 0.364258 1.79319 2.57148 1.79319 3.98397L1.79319 5.95667L0.162109 5.95667L0.162109 9.00617L1.79319 9.00617C1.79319 12.9198 1.79319 17.6352 1.79319 17.6352L5.22392 17.6352C5.22392 17.6352 5.22392 12.8733 5.22392 9.00617L7.53889 9.00617L7.83809 5.95667Z"
                                                    fill="#1D2977" />
                                            </svg>
                                        </a>
                                    <?php endif; ?>

                                    <?php if ($settings['social_instagram']['url']): ?>
                                        <a href="<?php echo esc_url($settings['social_instagram']['url']); ?>" target="_blank"
                                            rel="nofollow">
                                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_1_4241)">
                                                    <path
                                                        d="M9.00207 4.31934C6.46176 4.31934 4.35693 6.38787 4.35693 8.96447C4.35693 11.5411 6.42547 13.6096 9.00207 13.6096C11.5787 13.6096 13.6472 11.5048 13.6472 8.96447C13.6472 6.42416 11.5424 4.31934 9.00207 4.31934ZM9.00207 11.9403C7.36901 11.9403 6.02628 10.5975 6.02628 8.96447C6.02628 7.33142 7.36901 5.98868 9.00207 5.98868C10.6351 5.98868 11.9779 7.33142 11.9779 8.96447C11.9779 10.5975 10.6351 11.9403 9.00207 11.9403Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M13.8278 5.26205C14.409 5.26205 14.8802 4.79087 14.8802 4.20964C14.8802 3.62841 14.409 3.15723 13.8278 3.15723C13.2466 3.15723 12.7754 3.62841 12.7754 4.20964C12.7754 4.79087 13.2466 5.26205 13.8278 5.26205Z"
                                                        fill="#1D2977" />
                                                    <path
                                                        d="M16.5483 1.4879C15.6048 0.508062 14.262 0 12.7378 0H5.26207C2.10483 0 0 2.10483 0 5.26207V12.7015C0 14.262 0.508062 15.6048 1.52419 16.5846C2.50402 17.5281 3.81046 17.9999 5.29836 17.9999H12.7015C14.262 17.9999 15.5685 17.4918 16.512 16.5846C17.4918 15.641 17.9999 14.2983 17.9999 12.7378V5.26207C17.9999 3.73788 17.4918 2.43144 16.5483 1.4879ZM16.4031 12.7378C16.4031 13.8628 16.0039 14.7701 15.3507 15.387C14.6975 16.0039 13.7902 16.3306 12.7015 16.3306H5.29836C4.20965 16.3306 3.3024 16.0039 2.64918 15.387C1.99596 14.7338 1.66935 13.8265 1.66935 12.7015V5.26207C1.66935 4.17336 1.99596 3.26611 2.64918 2.61289C3.26611 1.99596 4.20965 1.66935 5.29836 1.66935H12.7741C13.8628 1.66935 14.7701 1.99596 15.4233 2.64918C16.0402 3.3024 16.4031 4.20965 16.4031 5.26207V12.7378Z"
                                                        fill="#1D2977" />
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_1_4241">
                                                        <rect width="17.9999" height="17.9999" fill="white" />
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </a>
                                    <?php endif; ?>
                                </div>
                                <div class="footer-body-top-section-one-about-us-right-text-social-media">
                                    <span>
                                        <?php echo wp_kses_post($settings['social_text']); ?>
                                    </span>
                                </div>
                            </div>

                            <!-- تماس و ایمیل -->
                            <div class="footer-body-top-section-one-about-us-left">
                                <div class="footer-body-top-section-one-about-us-left-phone">
                                    <?php echo $settings['phone_shop']; ?>
                                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.29026 4.12286C7.92517 2.40161 10.6295 2.72409 11.9809 4.63554L13.6622 7.01352C14.7432 8.54241 14.6519 10.668 13.3618 12.0262L13.0353 12.3699C13.0344 12.3723 13.0335 12.3749 13.0325 12.3776C13.0152 12.4261 12.9716 12.5805 13.0145 12.8735C13.1035 13.4809 13.5724 14.7151 15.4759 16.7192C17.3855 18.7296 18.5437 19.2034 19.0804 19.2906C19.312 19.3282 19.4331 19.2955 19.4717 19.2819L20.0165 18.7083C21.1816 17.4817 22.9981 17.2401 24.4627 18.0831L27.01 19.5493C29.1872 20.8025 29.694 23.8681 27.954 25.7L26.0599 27.694C25.4688 28.3164 24.6627 28.8477 23.6666 28.946C21.2348 29.186 15.6013 28.8734 9.69547 22.6556C4.18459 16.8537 3.13768 11.8072 3.00534 9.34154L3.89348 9.29387L3.00534 9.34154C2.93995 8.12331 3.48299 7.07839 4.19746 6.32619L6.29026 4.12286ZM10.3479 5.79016C9.66473 4.82396 8.43749 4.76631 7.74038 5.50024L5.64758 7.70356C5.20572 8.16875 4.97389 8.70194 5.00247 9.23435C5.11052 11.2474 5.97742 15.8371 11.1456 21.2782C16.5645 26.9833 21.5569 27.1445 23.4702 26.9557C23.8485 26.9183 24.2378 26.7084 24.6098 26.3167L26.5039 24.3226C27.3209 23.4624 27.1068 21.9127 26.0123 21.2827L23.465 19.8165C22.7814 19.423 21.9806 19.5446 21.4667 20.0857L20.8594 20.725L20.1565 20.0573C20.8594 20.725 20.8585 20.726 20.8575 20.7269L20.8556 20.7289L20.8517 20.733L20.8433 20.7416L20.8241 20.7605C20.8103 20.7737 20.7945 20.7884 20.7766 20.8041C20.7408 20.8355 20.6964 20.8714 20.6431 20.9092C20.5363 20.9849 20.3941 21.0682 20.2142 21.1392C19.8461 21.2843 19.3602 21.3622 18.7598 21.2647C17.5898 21.0747 16.0563 20.2343 14.0258 18.0966C11.9894 15.9526 11.2099 14.3529 11.0357 13.1634C10.947 12.558 11.0179 12.0732 11.1482 11.7071C11.2123 11.5271 11.2879 11.3836 11.3577 11.2745C11.3925 11.2202 11.4256 11.1747 11.4549 11.1376C11.4696 11.1191 11.4833 11.1027 11.4958 11.0884L11.5135 11.0684L11.5217 11.0595L11.5255 11.0554L11.5274 11.0534C11.5283 11.0524 11.5293 11.0515 12.2381 11.7248L11.5293 11.0514L11.9117 10.6488C12.5057 10.0234 12.592 8.96422 12.0292 8.16814L10.3479 5.79016Z"
                                            fill="#F7F8FD" />
                                        <path
                                            d="M17.6794 2.50677C17.7677 1.96158 18.283 1.59175 18.8282 1.68001C18.862 1.68647 18.9706 1.70677 19.0274 1.71944C19.1412 1.74477 19.2999 1.78378 19.4978 1.84142C19.8935 1.95668 20.4463 2.14655 21.1098 2.45073C22.4382 3.05973 24.2059 4.12508 26.0403 5.95947C27.8747 7.79387 28.9401 9.56162 29.5491 10.89C29.8532 11.5535 30.0431 12.1063 30.1584 12.502C30.216 12.6999 30.255 12.8586 30.2804 12.9723C30.293 13.0292 30.3023 13.0749 30.3087 13.1087L30.3164 13.1503C30.4047 13.6954 30.0382 14.2321 29.493 14.3204C28.9494 14.4084 28.4373 14.0404 28.3468 13.4977C28.344 13.4832 28.3364 13.444 28.3282 13.4071C28.3117 13.3333 28.2833 13.2162 28.2382 13.0613C28.1479 12.7515 27.9912 12.2911 27.731 11.7235C27.2112 10.5898 26.2766 9.02417 24.6261 7.37369C22.9756 5.72321 21.41 4.78855 20.2763 4.26877C19.7087 4.00856 19.2483 3.85185 18.9385 3.76162C18.7836 3.71651 18.589 3.67183 18.5151 3.65539C17.9725 3.56496 17.5914 3.0504 17.6794 2.50677Z"
                                            fill="#F7F8FD" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M17.9814 7.1064C18.1331 6.57536 18.6866 6.26787 19.2176 6.41959L18.9429 7.38112C19.2176 6.41959 19.2181 6.41973 19.2186 6.41986L19.2195 6.42014L19.2216 6.42073L19.226 6.42203L19.2363 6.42512L19.2627 6.43334C19.2828 6.43976 19.3079 6.44814 19.3379 6.45876C19.3978 6.48001 19.4769 6.51023 19.574 6.55183C19.7682 6.63508 20.0336 6.76364 20.3597 6.95659C21.0123 7.34283 21.9032 7.9844 22.9498 9.03103C23.9965 10.0777 24.638 10.9686 25.0243 11.6212C25.2172 11.9472 25.3458 12.2126 25.429 12.4069C25.4706 12.504 25.5008 12.5831 25.5221 12.643C25.5327 12.6729 25.5411 12.698 25.5475 12.7181L25.5557 12.7445L25.5588 12.7548L25.5601 12.7593L25.5607 12.7613L25.561 12.7623C25.5611 12.7628 25.5613 12.7632 24.5997 13.038L25.5613 12.7632C25.713 13.2943 25.4055 13.8478 24.8745 13.9995C24.3479 14.1499 23.7993 13.8489 23.6422 13.3262L23.6372 13.3118C23.6301 13.2918 23.6154 13.2523 23.5907 13.1947C23.5414 13.0796 23.4519 12.8913 23.3031 12.6398C23.0058 12.1375 22.4689 11.3785 21.5356 10.4452C20.6023 9.51198 19.8433 8.97504 19.341 8.67774C19.0896 8.52892 18.9013 8.43946 18.7861 8.39012C18.7285 8.36544 18.6891 8.35073 18.6691 8.34362L18.6547 8.33869C18.1319 8.18152 17.8309 7.63292 17.9814 7.1064Z"
                                            fill="#F7F8FD" />
                                    </svg>
                                </div>
                                <div class="footer-body-top-section-one-about-us-left-line"></div>
                                <div class="footer-body-top-section-one-about-us-left-email">
                                    <?php echo $settings['email_shop']; ?>
                                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M13.2579 4.33301H18.7417C21.1921 4.33299 23.1329 4.33297 24.6519 4.53719C26.2151 4.74736 27.4804 5.19018 28.4782 6.188C29.476 7.18582 29.9188 8.45108 30.129 10.0143C30.3332 11.5333 30.3332 13.4741 30.3332 15.9245V16.0749C30.3332 18.5252 30.3332 20.4661 30.129 21.985C29.9188 23.5483 29.476 24.8135 28.4782 25.8114C27.4804 26.8092 26.2151 27.252 24.6519 27.4622C23.1329 27.6664 21.1921 27.6664 18.7417 27.6663H13.258C10.8076 27.6664 8.86676 27.6664 7.34781 27.4622C5.78458 27.252 4.51931 26.8092 3.5215 25.8114C2.52368 24.8135 2.08085 23.5483 1.87068 21.985C1.66647 20.4661 1.66648 18.5252 1.6665 16.0749V15.9245C1.66648 13.4741 1.66647 11.5333 1.87068 10.0143C2.08085 8.45108 2.52368 7.18582 3.5215 6.188C4.51931 5.19018 5.78458 4.74736 7.34781 4.53719C8.86676 4.33297 10.8076 4.33299 13.2579 4.33301ZM7.6143 6.51935C6.27285 6.69971 5.49999 7.03793 4.93571 7.60221C4.37143 8.16649 4.0332 8.93935 3.85285 10.2808C3.66863 11.651 3.6665 13.4572 3.6665 15.9997C3.6665 18.5421 3.66863 20.3483 3.85285 21.7185C4.0332 23.06 4.37143 23.8329 4.93571 24.3971C5.49999 24.9614 6.27285 25.2996 7.6143 25.48C8.98452 25.6642 10.7907 25.6663 13.3332 25.6663H18.6665C21.2089 25.6663 23.0152 25.6642 24.3854 25.48C25.7268 25.2996 26.4997 24.9614 27.064 24.3971C27.6282 23.8329 27.9665 23.06 28.1468 21.7185C28.331 20.3483 28.3332 18.5421 28.3332 15.9997C28.3332 13.4572 28.331 11.651 28.1468 10.2808C27.9665 8.93935 27.6282 8.16649 27.064 7.60221C26.4997 7.03793 25.7268 6.69971 24.3854 6.51935C23.0152 6.33513 21.2089 6.33301 18.6665 6.33301L13.3332 6.33301C10.7907 6.33301 8.98452 6.33513 7.6143 6.51935ZM7.23162 10.0262C7.58518 9.60188 8.21575 9.54456 8.64002 9.89812L11.5186 12.2969C12.7625 13.3335 13.6261 14.0509 14.3553 14.5198C15.0611 14.9738 15.5397 15.1262 15.9998 15.1262C16.4599 15.1262 16.9386 14.9738 17.6444 14.5198C18.3735 14.0509 19.2372 13.3335 20.4811 12.2969L23.3597 9.89812C23.7839 9.54456 24.4145 9.60188 24.7681 10.0262C25.1216 10.4504 25.0643 11.081 24.64 11.4346L21.7114 13.8751C20.5296 14.86 19.5717 15.6582 18.7263 16.202C17.8456 16.7684 16.9879 17.1262 15.9998 17.1262C15.0117 17.1262 14.1541 16.7684 13.2734 16.202C12.428 15.6582 11.4701 14.86 10.2883 13.8751L7.35965 11.4346C6.93538 11.081 6.87805 10.4504 7.23162 10.0262Z"
                                            fill="#F7F8FD" />
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <div class="underline-lamkadeh">
                            <div class="underline-lamkadeh-line"></div>
                            <div class="underline-lamkadeh-circle"></div>
                        </div>
                    </section>

                    <section class="footer-body-top-section-two">
                        <section class="footer-body-top-section-two-about">
                            <a href="<?php echo esc_url(home_url()) ?>" class="footer-body-top-section-two-about-logo">
                                <?php
                                $logo_width = get_option('site_logo_width');
                                $logo_height = get_option('site_logo_height');
                                ?>
                                <img src="<?php echo esc_url(get_option('site_logo')); ?>"
                                    height="<?php echo esc_attr((!empty($logo_height) && $logo_height != 0) ? $logo_height : 'auto'); ?>"
                                    width="<?php echo esc_attr((!empty($logo_width) && $logo_width != 0) ? $logo_width : 'auto'); ?>"
                                    alt="<?php bloginfo("name") ?>">
                                <div>
                                    <?php
                                    $site_text_one = get_option("site_text_one");
                                    $site_text_two = get_option("site_text_two");
                                    ?>
                                    <strong><?php echo esc_html($site_text_one); ?></strong>
                                    <span><?php echo esc_html($site_text_two); ?></span>
                                </div>
                            </a>
                            <div class="footer-body-top-section-two-about-description">
                                <p>
                                    <?php echo wp_kses_post(wp_strip_all_tags($settings['short_description_shop'], true)); ?>
                                    <span
                                        class="more-text"><?php echo wp_kses_post(wp_strip_all_tags($settings['long_description_shop'], true)); ?></span>
                                    <button aria-expanded="false"
                                        class="more-description"><?php echo __("مشاهده بیشتر ...", "lamkadeh") ?></button>
                                </p>
                            </div>
                            <svg width="55" height="41" viewBox="0 0 55 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M12.5 24.4618C11.1193 24.4618 10 23.3666 10 22.0156C10 20.6647 11.1193 19.5695 12.5 19.5695C13.8807 19.5695 15 20.6647 15 22.0156C15 23.3666 13.8807 24.4618 12.5 24.4618Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M32.5 24.4618C31.1193 24.4618 30 23.3666 30 22.0156C30 20.6647 31.1193 19.5695 32.5 19.5695C33.8807 19.5695 35 20.6647 35 22.0156C35 23.3666 33.8807 24.4618 32.5 24.4618Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M42.5 24.4618C41.1193 24.4618 40 23.3666 40 22.0156C40 20.6647 41.1193 19.5695 42.5 19.5695C43.8807 19.5695 45 20.6647 45 22.0156C45 23.3666 43.8807 24.4618 42.5 24.4618Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M2.5 14.6772C1.11929 14.6772 4.91564e-07 13.582 4.31927e-07 12.231C3.72291e-07 10.88 1.11929 9.78486 2.5 9.78486C3.88071 9.78486 5 10.88 5 12.231C5 13.582 3.88071 14.6772 2.5 14.6772Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M12.5 14.6772C11.1193 14.6772 10 13.582 10 12.231C10 10.88 11.1193 9.78486 12.5 9.78486C13.8807 9.78486 15 10.88 15 12.231C15 13.582 13.8807 14.6772 12.5 14.6772Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M22.5 14.6772C21.1193 14.6772 20 13.582 20 12.231C20 10.88 21.1193 9.78486 22.5 9.78486C23.8807 9.78486 25 10.88 25 12.231C25 13.582 23.8807 14.6772 22.5 14.6772Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M42.5 14.6772C41.1193 14.6772 40 13.582 40 12.231C40 10.88 41.1193 9.78486 42.5 9.78486C43.8807 9.78486 45 10.88 45 12.231C45 13.582 43.8807 14.6772 42.5 14.6772Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M52.5 14.6772C51.1193 14.6772 50 13.582 50 12.231C50 10.88 51.1193 9.78486 52.5 9.78486C53.8807 9.78486 55 10.88 55 12.231C55 13.582 53.8807 14.6772 52.5 14.6772Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M2.5 4.89255C1.11929 4.89255 5.96368e-08 3.79737 0 2.4464C-5.96368e-08 1.09543 1.11929 0.000246365 2.5 0.000246305C3.88071 0.000246245 5 1.09543 5 2.4464C5 3.79737 3.88071 4.89255 2.5 4.89255Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M22.5 4.89255C21.1193 4.89255 20 3.79737 20 2.4464C20 1.09543 21.1193 0.000245499 22.5 0.000245439C23.8807 0.000245379 25 1.09543 25 2.4464C25 3.79737 23.8807 4.89255 22.5 4.89255Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M32.5 4.89255C31.1193 4.89255 30 3.79737 30 2.4464C30 1.09542 31.1193 0.000245066 32.5 0.000245006C33.8807 0.000244947 35 1.09542 35 2.4464C35 3.79737 33.8807 4.89255 32.5 4.89255Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M42.5 4.89255C41.1193 4.89255 40 3.79737 40 2.4464C40 1.09542 41.1193 0.000244633 42.5 0.000244573C43.8807 0.000244514 45 1.09542 45 2.4464C45 3.79737 43.8807 4.89255 42.5 4.89255Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M52.5 4.89255C51.1193 4.89255 50 3.79737 50 2.4464C50 1.09542 51.1193 0.0002442 52.5 0.000244141C53.8807 0.000244081 55 1.09542 55 2.4464C55 3.79737 53.8807 4.89255 52.5 4.89255Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M32.5 14.6772C31.1193 14.6772 30 13.582 30 12.231C30 10.88 31.1193 9.78486 32.5 9.78486C33.8807 9.78486 35 10.88 35 12.231C35 13.582 33.8807 14.6772 32.5 14.6772Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M12.5 4.89255C11.1193 4.89255 10 3.79737 10 2.4464C10 1.09543 11.1193 0.000245932 12.5 0.000245872C13.8807 0.000245812 15 1.09543 15 2.4464C15 3.79737 13.8807 4.89255 12.5 4.89255Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M22.5 24.4618C21.1193 24.4618 20 23.3666 20 22.0156C20 20.6647 21.1193 19.5695 22.5 19.5695C23.8807 19.5695 25 20.6647 25 22.0156C25 23.3666 23.8807 24.4618 22.5 24.4618Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M52.5 24.4618C51.1193 24.4618 50 23.3666 50 22.0156C50 20.6647 51.1193 19.5695 52.5 19.5695C53.8807 19.5695 55 20.6647 55 22.0156C55 23.3666 53.8807 24.4618 52.5 24.4618Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M2.5 24.4618C1.11929 24.4618 9.23492e-07 23.3666 8.63855e-07 22.0156C8.04219e-07 20.6647 1.11929 19.5695 2.5 19.5695C3.88071 19.5695 5 20.6647 5 22.0156C5 23.3666 3.88071 24.4618 2.5 24.4618Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M12.5 54.0002C11.1193 54.0002 10 52.9051 10 51.5541C10 50.2031 11.1193 49.1079 12.5 49.1079C13.8807 49.1079 15 50.2031 15 51.5541C15 52.9051 13.8807 54.0002 12.5 54.0002Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M32.5 54.0002C31.1193 54.0002 30 52.9051 30 51.5541C30 50.2031 31.1193 49.1079 32.5 49.1079C33.8807 49.1079 35 50.2031 35 51.5541C35 52.9051 33.8807 54.0002 32.5 54.0002Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M42.5 54.0002C41.1193 54.0002 40 52.9051 40 51.5541C40 50.2031 41.1193 49.1079 42.5 49.1079C43.8807 49.1079 45 50.2031 45 51.5541C45 52.9051 43.8807 54.0002 42.5 54.0002Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M2.5 44.2156C1.11929 44.2156 4.91564e-07 43.1204 4.31927e-07 41.7695C3.72291e-07 40.4185 1.11929 39.3233 2.5 39.3233C3.88071 39.3233 5 40.4185 5 41.7695C5 43.1204 3.88071 44.2156 2.5 44.2156Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M12.5 44.2156C11.1193 44.2156 10 43.1204 10 41.7695C10 40.4185 11.1193 39.3233 12.5 39.3233C13.8807 39.3233 15 40.4185 15 41.7695C15 43.1204 13.8807 44.2156 12.5 44.2156Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M22.5 44.2156C21.1193 44.2156 20 43.1204 20 41.7695C20 40.4185 21.1193 39.3233 22.5 39.3233C23.8807 39.3233 25 40.4185 25 41.7695C25 43.1204 23.8807 44.2156 22.5 44.2156Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M42.5 44.2156C41.1193 44.2156 40 43.1204 40 41.7695C40 40.4185 41.1193 39.3233 42.5 39.3233C43.8807 39.3233 45 40.4185 45 41.7695C45 43.1204 43.8807 44.2156 42.5 44.2156Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M52.5 44.2156C51.1193 44.2156 50 43.1204 50 41.7695C50 40.4185 51.1193 39.3233 52.5 39.3233C53.8807 39.3233 55 40.4185 55 41.7695C55 43.1204 53.8807 44.2156 52.5 44.2156Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M2.5 34.431C1.11929 34.431 5.96368e-08 33.3358 0 31.9849C-5.96368e-08 30.6339 1.11929 29.5387 2.5 29.5387C3.88071 29.5387 5 30.6339 5 31.9849C5 33.3358 3.88071 34.431 2.5 34.431Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M22.5 34.431C21.1193 34.431 20 33.3358 20 31.9849C20 30.6339 21.1193 29.5387 22.5 29.5387C23.8807 29.5387 25 30.6339 25 31.9849C25 33.3358 23.8807 34.431 22.5 34.431Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M32.5 34.431C31.1193 34.431 30 33.3358 30 31.9849C30 30.6339 31.1193 29.5387 32.5 29.5387C33.8807 29.5387 35 30.6339 35 31.9849C35 33.3358 33.8807 34.431 32.5 34.431Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M42.5 34.431C41.1193 34.431 40 33.3358 40 31.9849C40 30.6339 41.1193 29.5387 42.5 29.5387C43.8807 29.5387 45 30.6339 45 31.9849C45 33.3358 43.8807 34.431 42.5 34.431Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M52.5 34.431C51.1193 34.431 50 33.3358 50 31.9849C50 30.6339 51.1193 29.5387 52.5 29.5387C53.8807 29.5387 55 30.6339 55 31.9849C55 33.3358 53.8807 34.431 52.5 34.431Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M32.5 44.2156C31.1193 44.2156 30 43.1204 30 41.7695C30 40.4185 31.1193 39.3233 32.5 39.3233C33.8807 39.3233 35 40.4185 35 41.7695C35 43.1204 33.8807 44.2156 32.5 44.2156Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M12.5 34.431C11.1193 34.431 10 33.3358 10 31.9849C10 30.6339 11.1193 29.5387 12.5 29.5387C13.8807 29.5387 15 30.6339 15 31.9849C15 33.3358 13.8807 34.431 12.5 34.431Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M22.5 54.0002C21.1193 54.0002 20 52.9051 20 51.5541C20 50.2031 21.1193 49.1079 22.5 49.1079C23.8807 49.1079 25 50.2031 25 51.5541C25 52.9051 23.8807 54.0002 22.5 54.0002Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M52.5 54.0002C51.1193 54.0002 50 52.9051 50 51.5541C50 50.2031 51.1193 49.1079 52.5 49.1079C53.8807 49.1079 55 50.2031 55 51.5541C55 52.9051 53.8807 54.0002 52.5 54.0002Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                                <path
                                    d="M2.5 54.0002C1.11929 54.0002 9.23492e-07 52.9051 8.63855e-07 51.5541C8.04219e-07 50.2031 1.11929 49.1079 2.5 49.1079C3.88071 49.1079 5 50.2031 5 51.5541C5 52.9051 3.88071 54.0002 2.5 54.0002Z"
                                    fill="#1D2977" fill-opacity="0.12" />
                            </svg>
                        </section>
                        <section class="footer-body-top-section-two-enamad">
                            <?php echo wp_kses_post($settings['namad']); ?>
                            <svg class="footer-body-top-section-two-svg" width="92" height="88" viewBox="0 0 92 88" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20.9091 39.8633C18.5995 39.8633 16.7273 38.0785 16.7273 35.8769C16.7273 33.6753 18.5995 31.8906 20.9091 31.8906C23.2186 31.8906 25.0909 33.6753 25.0909 35.8769C25.0909 38.0785 23.2186 39.8633 20.9091 39.8633Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M54.3636 39.8633C52.0541 39.8633 50.1818 38.0785 50.1818 35.8769C50.1818 33.6753 52.0541 31.8906 54.3636 31.8906C56.6732 31.8906 58.5455 33.6753 58.5455 35.8769C58.5455 38.0785 56.6732 39.8633 54.3636 39.8633Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M71.0909 39.8632C68.7814 39.8632 66.9091 38.0785 66.9091 35.8769C66.9091 33.6753 68.7813 31.8906 71.0909 31.8906C73.4005 31.8906 75.2727 33.6753 75.2727 35.8769C75.2727 38.0785 73.4005 39.8632 71.0909 39.8632Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M4.18182 23.9179C1.87226 23.9179 8.22253e-07 22.1332 7.22497e-07 19.9316C6.22741e-07 17.73 1.87226 15.9453 4.18182 15.9453C6.49137 15.9453 8.36364 17.73 8.36364 19.9316C8.36364 22.1332 6.49137 23.9179 4.18182 23.9179Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M20.9091 23.9179C18.5995 23.9179 16.7273 22.1332 16.7273 19.9316C16.7273 17.73 18.5995 15.9453 20.9091 15.9453C23.2186 15.9453 25.0909 17.73 25.0909 19.9316C25.0909 22.1332 23.2186 23.9179 20.9091 23.9179Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M37.6364 23.9179C35.3268 23.9179 33.4545 22.1332 33.4545 19.9316C33.4545 17.73 35.3268 15.9453 37.6364 15.9453C39.9459 15.9453 41.8182 17.73 41.8182 19.9316C41.8182 22.1332 39.9459 23.9179 37.6364 23.9179Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M71.0909 23.9179C68.7813 23.9179 66.9091 22.1332 66.9091 19.9316C66.9091 17.73 68.7813 15.9453 71.0909 15.9453C73.4005 15.9453 75.2727 17.73 75.2727 19.9316C75.2727 22.1332 73.4005 23.9179 71.0909 23.9179Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M87.8182 23.9179C85.5086 23.9179 83.6364 22.1332 83.6364 19.9316C83.6364 17.73 85.5086 15.9453 87.8182 15.9453C90.1277 15.9453 92 17.73 92 19.9316C92 22.1332 90.1277 23.9179 87.8182 23.9179Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M4.18182 7.97265C1.87226 7.97265 9.97561e-08 6.18791 0 3.98633C-9.97561e-08 1.78474 1.87226 3.62419e-06 4.18182 3.5268e-06C6.49137 3.42941e-06 8.36364 1.78474 8.36364 3.98633C8.36364 6.18791 6.49137 7.97265 4.18182 7.97265Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M37.6364 7.97265C35.3268 7.97265 33.4545 6.18791 33.4545 3.98633C33.4545 1.78474 35.3268 2.21347e-06 37.6364 2.11608e-06C39.9459 2.01869e-06 41.8182 1.78474 41.8182 3.98633C41.8182 6.18791 39.9459 7.97265 37.6364 7.97265Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M54.3636 7.97265C52.0541 7.97265 50.1818 6.18791 50.1818 3.98633C50.1818 1.78474 52.0541 1.50811e-06 54.3636 1.41072e-06C56.6732 1.31333e-06 58.5455 1.78474 58.5455 3.98632C58.5455 6.18791 56.6732 7.97265 54.3636 7.97265Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M71.0909 7.97265C68.7813 7.97265 66.9091 6.18791 66.9091 3.98632C66.9091 1.78474 68.7813 8.02749e-07 71.0909 7.05359e-07C73.4005 6.07969e-07 75.2727 1.78474 75.2727 3.98632C75.2727 6.18791 73.4005 7.97265 71.0909 7.97265Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M87.8182 7.97265C85.5086 7.97265 83.6364 6.18791 83.6364 3.98632C83.6364 1.78474 85.5086 9.73899e-08 87.8182 0C90.1277 -9.73899e-08 92 1.78474 92 3.98632C92 6.18791 90.1277 7.97265 87.8182 7.97265Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M54.3636 23.9179C52.0541 23.9179 50.1818 22.1332 50.1818 19.9316C50.1818 17.73 52.0541 15.9453 54.3636 15.9453C56.6732 15.9453 58.5455 17.73 58.5455 19.9316C58.5455 22.1332 56.6732 23.9179 54.3636 23.9179Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M20.9091 7.97265C18.5995 7.97265 16.7273 6.18791 16.7273 3.98633C16.7273 1.78474 18.5995 2.91883e-06 20.9091 2.82144e-06C23.2186 2.72405e-06 25.0909 1.78474 25.0909 3.98633C25.0909 6.18791 23.2186 7.97265 20.9091 7.97265Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M37.6364 39.8633C35.3268 39.8633 33.4545 38.0785 33.4545 35.8769C33.4545 33.6753 35.3268 31.8906 37.6364 31.8906C39.9459 31.8906 41.8182 33.6753 41.8182 35.8769C41.8182 38.0785 39.9459 39.8633 37.6364 39.8633Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M87.8182 39.8632C85.5086 39.8632 83.6364 38.0785 83.6364 35.8769C83.6364 33.6753 85.5086 31.8906 87.8182 31.8906C90.1277 31.8906 92 33.6753 92 35.8769C92 38.0785 90.1277 39.8632 87.8182 39.8632Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M4.18182 39.8633C1.87227 39.8633 1.54475e-06 38.0785 1.44499e-06 35.8769C1.34524e-06 33.6753 1.87226 31.8906 4.18182 31.8906C6.49137 31.8906 8.36364 33.6753 8.36364 35.8769C8.36364 38.0785 6.49137 39.8633 4.18182 39.8633Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M20.9091 88C18.5995 88 16.7273 86.2153 16.7273 84.0137C16.7273 81.8121 18.5995 80.0274 20.9091 80.0274C23.2186 80.0274 25.0909 81.8121 25.0909 84.0137C25.0909 86.2153 23.2186 88 20.9091 88Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M54.3636 88C52.0541 88 50.1818 86.2153 50.1818 84.0137C50.1818 81.8121 52.0541 80.0274 54.3636 80.0274C56.6732 80.0274 58.5455 81.8121 58.5455 84.0137C58.5455 86.2153 56.6732 88 54.3636 88Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M71.0909 88C68.7814 88 66.9091 86.2153 66.9091 84.0137C66.9091 81.8121 68.7813 80.0274 71.0909 80.0274C73.4005 80.0274 75.2727 81.8121 75.2727 84.0137C75.2727 86.2153 73.4005 88 71.0909 88Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M4.18182 72.0547C1.87226 72.0547 8.22253e-07 70.27 7.22497e-07 68.0684C6.22741e-07 65.8668 1.87226 64.0821 4.18182 64.0821C6.49137 64.0821 8.36364 65.8668 8.36364 68.0684C8.36364 70.27 6.49137 72.0547 4.18182 72.0547Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M20.9091 72.0547C18.5995 72.0547 16.7273 70.27 16.7273 68.0684C16.7273 65.8668 18.5995 64.0821 20.9091 64.0821C23.2186 64.0821 25.0909 65.8668 25.0909 68.0684C25.0909 70.27 23.2186 72.0547 20.9091 72.0547Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M37.6364 72.0547C35.3268 72.0547 33.4545 70.27 33.4545 68.0684C33.4545 65.8668 35.3268 64.0821 37.6364 64.0821C39.9459 64.0821 41.8182 65.8668 41.8182 68.0684C41.8182 70.27 39.9459 72.0547 37.6364 72.0547Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M71.0909 72.0547C68.7813 72.0547 66.9091 70.27 66.9091 68.0684C66.9091 65.8668 68.7813 64.0821 71.0909 64.0821C73.4005 64.0821 75.2727 65.8668 75.2727 68.0684C75.2727 70.27 73.4005 72.0547 71.0909 72.0547Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M87.8182 72.0547C85.5086 72.0547 83.6364 70.27 83.6364 68.0684C83.6364 65.8668 85.5086 64.0821 87.8182 64.0821C90.1277 64.0821 92 65.8668 92 68.0684C92 70.27 90.1277 72.0547 87.8182 72.0547Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M4.18182 56.1094C1.87226 56.1094 9.97561e-08 54.3247 0 52.1231C-9.97561e-08 49.9215 1.87226 48.1368 4.18182 48.1368C6.49137 48.1368 8.36364 49.9215 8.36364 52.1231C8.36364 54.3247 6.49137 56.1094 4.18182 56.1094Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M37.6364 56.1094C35.3268 56.1094 33.4545 54.3247 33.4545 52.1231C33.4545 49.9215 35.3268 48.1368 37.6364 48.1368C39.9459 48.1368 41.8182 49.9215 41.8182 52.1231C41.8182 54.3247 39.9459 56.1094 37.6364 56.1094Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M54.3636 56.1094C52.0541 56.1094 50.1818 54.3247 50.1818 52.1231C50.1818 49.9215 52.0541 48.1368 54.3636 48.1368C56.6732 48.1368 58.5455 49.9215 58.5455 52.1231C58.5455 54.3247 56.6732 56.1094 54.3636 56.1094Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M71.0909 56.1094C68.7813 56.1094 66.9091 54.3247 66.9091 52.1231C66.9091 49.9215 68.7813 48.1368 71.0909 48.1368C73.4005 48.1368 75.2727 49.9215 75.2727 52.1231C75.2727 54.3247 73.4005 56.1094 71.0909 56.1094Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M87.8182 56.1094C85.5086 56.1094 83.6364 54.3247 83.6364 52.1231C83.6364 49.9215 85.5086 48.1368 87.8182 48.1368C90.1277 48.1368 92 49.9215 92 52.1231C92 54.3247 90.1277 56.1094 87.8182 56.1094Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M54.3636 72.0547C52.0541 72.0547 50.1818 70.27 50.1818 68.0684C50.1818 65.8668 52.0541 64.0821 54.3636 64.0821C56.6732 64.0821 58.5455 65.8668 58.5455 68.0684C58.5455 70.27 56.6732 72.0547 54.3636 72.0547Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M20.9091 56.1094C18.5995 56.1094 16.7273 54.3247 16.7273 52.1231C16.7273 49.9215 18.5995 48.1368 20.9091 48.1368C23.2186 48.1368 25.0909 49.9215 25.0909 52.1231C25.0909 54.3247 23.2186 56.1094 20.9091 56.1094Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M37.6364 88C35.3268 88 33.4545 86.2153 33.4545 84.0137C33.4545 81.8121 35.3268 80.0274 37.6364 80.0274C39.9459 80.0274 41.8182 81.8121 41.8182 84.0137C41.8182 86.2153 39.9459 88 37.6364 88Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M87.8182 88C85.5086 88 83.6364 86.2153 83.6364 84.0137C83.6364 81.8121 85.5086 80.0274 87.8182 80.0274C90.1277 80.0274 92 81.8121 92 84.0137C92 86.2153 90.1277 88 87.8182 88Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                                <path
                                    d="M4.18182 88C1.87227 88 1.54475e-06 86.2153 1.44499e-06 84.0137C1.34524e-06 81.8121 1.87226 80.0274 4.18182 80.0274C6.49137 80.0274 8.36364 81.8121 8.36364 84.0137C8.36364 86.2153 6.49137 88 4.18182 88Z"
                                    fill="#F7F8FD" fill-opacity="0.4" />
                            </svg>
                        </section>
                    </section>
                </section>

                <section class="footer-footer container">
                    <div class="footer-footer-line"></div>
                    <a href="#">
                        برگشت به بالا
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M15.0584 8.60019C14.9001 8.60019 14.7418 8.54186 14.6168 8.41686L10.0001 3.8002L5.38343 8.41686C5.14176 8.65853 4.74176 8.65853 4.5001 8.41686C4.25843 8.1752 4.25843 7.7752 4.5001 7.53353L9.55843 2.4752C9.8001 2.23353 10.2001 2.23353 10.4418 2.4752L15.5001 7.53353C15.7418 7.7752 15.7418 8.1752 15.5001 8.41686C15.3834 8.54186 15.2168 8.60019 15.0584 8.60019Z"
                                fill="#1D2977" />
                            <path
                                d="M10 17.7086C9.65833 17.7086 9.375 17.4253 9.375 17.0836V3.05859C9.375 2.71693 9.65833 2.43359 10 2.43359C10.3417 2.43359 10.625 2.71693 10.625 3.05859V17.0836C10.625 17.4253 10.3417 17.7086 10 17.7086Z"
                                fill="#1D2977" />
                        </svg>
                    </a>
                </section>

                <section class="footer-copyright container">
                    <div>
                        <span class="footer-text-copyright"><?php echo esc_html($settings['copyright']); ?></span>
                    </div>
                    <div class="footer-copyright-footer">
                        <div class="footer-developer"><?php echo esc_html($settings['copyright_two']); ?></div>
                        <div class="footer-copyright-line"></div>
                        <div>
                            <a
                                href="<?php echo esc_url($settings['link_one_footer']['url']); ?>"><?php echo esc_html($settings['text_link_one_footer']); ?></a>
                            <a
                                href="<?php echo esc_url($settings['link_two_footer']['url']); ?>"><?php echo esc_html($settings['text_link_two_footer']); ?></a>
                        </div>
                    </div>
                </section>
            </section>
        </footer>
        <?php
    }
}