<?php

add_filter('woocommerce_gateway_description', 'remove_gateway_description_on_checkout', 10, 2);
function remove_gateway_description_on_checkout($description, $payment_id)
{
    if (is_checkout()) {
        return '';
    }
    return $description;
}

add_action('wp_footer', function () { ?>
    <script>
        jQuery(function($) {
            function replaceCheckoutButton() {
                const buttonWrapper = $('.woocommerce-checkout-payment, .wc-proceed-to-checkout');
                const oldButton = $('#place_order');

                if (oldButton.length) {
                    const newButton = `
				<button type="submit"
					class="woocommerce-order-button-html"
					name="woocommerce_checkout_place_order"
					id="place_order"
					value="${oldButton.val()}"
					data-value="${oldButton.data('value')}">
					<span><?php echo __("ادامه و پرداخت", "lamkadeh") ?></span>
					<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M23.4214 13.4056C23.2646 13.5623 23.0502 13.6613 22.8027 13.6613L13.6621 13.6613L13.6621 22.8019C13.6621 23.2803 13.2662 23.6763 12.7877 23.6763C12.3092 23.6763 11.9132 23.2803 11.9132 22.8019L11.9132 12.7869C11.9132 12.3084 12.3092 11.9124 12.7877 11.9124L22.8027 11.9124C23.2811 11.9124 23.6771 12.3084 23.6771 12.7869C23.6854 13.0261 23.5781 13.2489 23.4214 13.4056Z" fill="white" />
						<path d="M27.4297 27.4298C27.0914 27.7681 26.5304 27.7681 26.1922 27.4298L12.3082 13.5458C11.9699 13.2075 11.9699 12.6466 12.3082 12.3083C12.6464 11.9701 13.2074 11.9701 13.5456 12.3083L27.4297 26.1924C27.7679 26.5306 27.7679 27.0916 27.4297 27.4298Z" fill="white" />
					</svg>
				</button>
			`;
                    oldButton.replaceWith(newButton);
                }
            }
            replaceCheckoutButton();
            $(document.body).on('updated_checkout', replaceCheckoutButton);
        });
    </script>
<?php });

add_action('template_redirect', function () {
    if (is_checkout() && !is_wc_endpoint_url()) {
        $template_path = get_template_directory() . '/woocommerce/checkout/form-checkout.php';
        if (file_exists($template_path)) {
            include $template_path;
            exit;
        }
    } else if (is_wc_endpoint_url('order-received')) {
        $template_path = get_template_directory() . '/woocommerce/checkout/thankyou.php';
        if (file_exists($template_path)) {
            include $template_path;
            exit;
        }
    }
});

function disable_email_requirement($errors, $sanitized_user_login, $user_email)
{
    if (empty($user_email)) {
        unset($errors->errors['empty_email']);
    }
    return $errors;
}
add_filter('registration_errors', 'disable_email_requirement', 10, 3);

function add_phone_requirement($errors, $sanitized_user_login, $user_email)
{
    if (empty($_POST['phone_number'])) {
        $errors->add('empty_phone', __('<strong>ارور</strong>: شماره تلفن همراه الزامی می باشد.', "lamkadeh"));
    }
    return $errors;
}
add_filter('registration_errors', 'add_phone_requirement', 10, 3);

function modify_checkout_fields($fields)
{
    unset($fields['billing']['billing_email']);

    $fields['billing']['billing_phone']['required'] = true;

    return $fields;
}
add_filter('woocommerce_checkout_fields', 'modify_checkout_fields');

add_filter('woocommerce_checkout_fields', 'lamkadeh_custom_checkout_fields');

function lamkadeh_custom_checkout_fields($fields)
{
    $enable_phone_login = get_option('enable_phone_login');

    if ($enable_phone_login === 'yes') {
        if (isset($fields['billing']['billing_email'])) {
            unset($fields['billing']['billing_email']);
        }

        $fields['billing'] = array_filter($fields['billing'], function ($field) {
            return isset($field['required']) ? $field['required'] !== true || $field['type'] !== 'email' : true;
        });
    }

    return $fields;
}

add_action('woocommerce_checkout_update_order_meta', function ($order_id) {
    if (!empty($_POST['recive_date_shipping'])) {
        update_post_meta($order_id, '_recive_date_shipping', sanitize_text_field($_POST['recive_date_shipping']));
    }
});

add_action('woocommerce_admin_order_data_after_billing_address', function ($order) {
    $shipping_date = get_post_meta($order->get_id(), '_recive_date_shipping', true);
    if ($shipping_date) {
        echo '<p><strong>' . __("تاریخ ارسال:", "lamkadeh") . '</strong> ' . esc_html($shipping_date) . '</p>';
    }
});

add_filter('woocommerce_email_order_meta_fields', function ($fields, $sent_to_admin, $order) {
    $shipping_date = get_post_meta($order->get_id(), '_recive_date_shipping', true);
    if ($shipping_date) {
        $fields['recive_date_shipping'] = array(
            'label' => __('تاریخ ارسال', "lamkadeh"),
            'value' => $shipping_date,
        );
    }
    return $fields;
}, 10, 3);

add_action('woocommerce_checkout_update_order_meta', function ($order_id) {
    if (isset($_POST['address_choice']) && $_POST['address_choice'] === 'custom') {
        $user_id = get_current_user_id();
        $addresses = get_user_meta($user_id, 'additional_addresses', true);
        if (!is_array($addresses)) $addresses = [];

        if (!empty($_POST['new_address']) && !empty($_POST['new_city'])) {
            $addresses[] = [
                'address'  => sanitize_text_field($_POST['new_address']),
                'city'     => sanitize_text_field($_POST['new_city']),
                'postcode' => sanitize_text_field($_POST['new_postcode']),
            ];
            update_user_meta($user_id, 'additional_addresses', $addresses);
        }

        if (isset($_POST['saved_address']) && $_POST['saved_address'] !== '') {
            $selected = intval($_POST['saved_address']);
            if (isset($addresses[$selected])) {
                $addr = $addresses[$selected];
                update_post_meta($order_id, '_shipping_address_1', $addr['address']);
                update_post_meta($order_id, '_shipping_city', $addr['city']);
                update_post_meta($order_id, '_shipping_postcode', $addr['postcode']);
            }
        }
    }
});

add_filter('wc_order_statuses', function ($order_statuses) {
    if (isset($order_statuses['wc-processing'])) {
        $order_statuses['wc-processing'] = __('جاری', "lamkadeh");
    }
    return $order_statuses;
});

add_filter('woocommerce_reports_order_statuses', function ($statuses) {
    $key = array_search('processing', $statuses);
    if ($key !== false) {
        $statuses[$key] = __('جاری', "lamkadeh");
    }
    return $statuses;
});

add_filter('gettext', function ($translated, $text, $domain) {
    if ($domain === 'woocommerce' && $text === 'Processing') {
        $translated = __('جاری', "lamkadeh");
    }
    if ($domain === 'woocommerce' && $text === 'در حال انجام') {
        $translated = __('جاری', "lamkadeh");
    }
    return $translated;
}, 20, 3);

add_filter('wc_order_statuses', function ($order_statuses) {
    if (isset($order_statuses['wc-completed'])) {
        $order_statuses['wc-completed'] = __('به اتمام رسیده', "lamkadeh");
    }
    return $order_statuses;
});

add_filter('woocommerce_reports_order_statuses', function ($statuses) {
    $key = array_search('completed', $statuses);
    if ($key !== false) {
        $statuses[$key] = __('به اتمام رسیده', "lamkadeh");
    }
    return $statuses;
});

add_filter('gettext', function ($translated, $text, $domain) {
    if ($domain === 'woocommerce' && $text === 'Processing') {
        $translated = __('به اتمام رسیده', "lamkadeh");
    }
    if ($domain === 'woocommerce' && $text === 'در حال انجام') {
        $translated = __('به اتمام رسیده', "lamkadeh");
    }
    return $translated;
}, 20, 3);

add_action('woocommerce_save_account_details', function ($user_id) {
    if (!empty($_FILES['profile_image_upload']['name'])) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . 'wp-admin/includes/image.php';
        require_once ABSPATH . 'wp-admin/includes/media.php';

        $uploaded = media_handle_upload('profile_image_upload', 0);
        if (!is_wp_error($uploaded)) {
            update_user_meta($user_id, 'profile_image', wp_get_attachment_url($uploaded));
        }
    }
});
