<?php

function lamkadeh_register_menus()
{
    register_nav_menus([
        'primary_menu' => __('فهرست اصلی', 'lamkadeh'),
    ]);
}
add_action('after_setup_theme', 'lamkadeh_register_menus');

function lamkadeh_menu_item_custom_fields($item_id, $item)
{
    $icon_code = get_post_meta($item_id, '_lamkadeh_icon_code', true);
    $mega_shortcode = get_post_meta($item_id, '_lamkadeh_mega_shortcode', true);
?>
    <p class="field-custom description description-wide">
        <label for="lamkadeh-icon-<?php echo $item_id; ?>">
            <?php _e('کد SVG یا Font Awesome', 'lamkadeh'); ?><br>
            <textarea id="lamkadeh-icon-<?php echo $item_id; ?>" class="widefat" name="lamkadeh_icon[<?php echo $item_id; ?>]"><?php echo esc_textarea($icon_code); ?></textarea>
        </label>
    </p>
    <p class="field-custom description description-wide">
        <label for="lamkadeh-mega-<?php echo $item_id; ?>">
            <?php _e('شورتکد مگا منو', 'lamkadeh'); ?><br>
            <input type="text" id="lamkadeh-mega-<?php echo $item_id; ?>" class="widefat" name="lamkadeh_mega[<?php echo $item_id; ?>]" value="<?php echo esc_attr($mega_shortcode); ?>">
        </label>
    </p>
<?php
}
add_action('wp_nav_menu_item_custom_fields', 'lamkadeh_menu_item_custom_fields', 10, 2);

function lamkadeh_save_menu_item_custom_fields($menu_id, $menu_item_db_id)
{
    if (isset($_POST['lamkadeh_icon'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_lamkadeh_icon_code', $_POST['lamkadeh_icon'][$menu_item_db_id]);
    }
    if (isset($_POST['lamkadeh_mega'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_lamkadeh_mega_shortcode', sanitize_text_field($_POST['lamkadeh_mega'][$menu_item_db_id]));
    }
}
add_action('wp_update_nav_menu_item', 'lamkadeh_save_menu_item_custom_fields', 10, 2);

class Lamkadeh_Walker_Nav_Menu extends Walker_Nav_Menu
{
    function start_el(&$output, $item, $depth = 0, $args = [], $id = 0)
    {
        $icon_code = get_post_meta($item->ID, '_lamkadeh_icon_code', true);
        $mega_shortcode = get_post_meta($item->ID, '_lamkadeh_mega_shortcode', true);

        $is_active = (in_array('current-menu-item', $item->classes) || in_array('current-menu-parent', $item->classes)) ? 'active' : '';

        $li_classes = $item->classes;
        if ($mega_shortcode) {
            $li_classes[] = 'mega-menu-trigger';
        }

        $link_classes = $is_active;
        if ($mega_shortcode) {
            $link_classes .= ' mega-trigger';
        }
        $link_classes = trim($link_classes);

        $output .= '<li class="' . esc_attr(implode(' ', $li_classes)) . '">';

        $output .= '<a href="' . esc_url($item->url) . '" class="' . esc_attr($link_classes) . '">';
        if ($icon_code) {
            $output .= '<span class="menu-icon">' . $icon_code . '</span>';
        }

        $output .= '<div class="shape-navbar"><div></div></div>';

        $output .= esc_html($item->title);
        
        if (in_array('menu-item-has-children', $item->classes)) {
            $output .= '<svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.27605 6.38393C4.47823 6.14806 4.83333 6.12075 5.06921 6.32292L9.95313 10.5091L14.8371 6.32292C15.0729 6.12075 15.428 6.14806 15.6302 6.38393C15.8324 6.6198 15.8051 6.97491 15.5692 7.17708L10.3192 11.6771C10.1086 11.8576 9.79771 11.8576 9.58706 11.6771L4.33706 7.17708C4.10119 6.97491 4.07388 6.6198 4.27605 6.38393Z" fill="#1D2977" /></svg>';
        }
        
        if ($mega_shortcode) {
            $output .= '<svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.27605 6.38393C4.47823 6.14806 4.83333 6.12075 5.06921 6.32292L9.95313 10.5091L14.8371 6.32292C15.0729 6.12075 15.428 6.14806 15.6302 6.38393C15.8324 6.6198 15.8051 6.97491 15.5692 7.17708L10.3192 11.6771C10.1086 11.8576 9.79771 11.8576 9.58706 11.6771L4.33706 7.17708C4.10119 6.97491 4.07388 6.6198 4.27605 6.38393Z" fill="#1D2977" /></svg>';
        }
        $output .= '</a>';

        if ($mega_shortcode) {
            $output .= '<div class="mega-menu">';
            if (class_exists('\Elementor\Plugin')) {
                if (preg_match('/id="(\d+)"/', $mega_shortcode, $matches)) {
                    $block_id = intval($matches[1]);
                    if ($block_id) {
                        $elementor_post = \Elementor\Plugin::$instance->documents->get($block_id);
                        if ($elementor_post && $elementor_post->is_built_with_elementor()) {
                            $output .= \Elementor\Plugin::instance()->frontend->get_builder_content($block_id);
                        } else {
                            $post = get_post($block_id);
                            if ($post) {
                                setup_postdata($post);
                                $output .= apply_filters('the_content', $post->post_content);
                                wp_reset_postdata();
                            } else {
                                $output .= '<!-- پست پیدا نشد -->';
                            }
                        }
                    }
                } else {
                    $output .= apply_filters('the_content', $mega_shortcode);
                }
            } else {
                $output .= apply_filters('the_content', $mega_shortcode);
            }
            $output .= '</div><div class="overly-mega-menu"></div>';
        }
    }

    function start_lvl(&$output, $depth = 0, $args = [])
    {
        $output .= '<ul class="sub-menu">';
    }

    function end_lvl(&$output, $depth = 0, $args = [])
    {
        $output .= '</ul><div class="overly-mega-menu"></div>';
    }

    function end_el(&$output, $item, $depth = 0, $args = [])
    {
        $output .= '</li>';
    }
}

function lamkadeh_responsive_navbar_menu($menu_location = 'primary_menu') {
    $locations = get_nav_menu_locations();
        if (!isset($locations[$menu_location])) {
        echo "منوی $menu_location پیدا نشد.";
        return;
    }

    $menu = wp_get_nav_menu_object($locations[$menu_location]);
    $menu_items = wp_get_nav_menu_items($menu->term_id);

    if (!$menu_items) return;

    echo '<div class="navbar-sidebar-responsive-tab"><ul>';
    echo '<li data-tab-navbar="tab-1"><a href="#">' . __('منوی اصلی','lamkadeh') . '</a></li>';

    $tab_index = 2;
    foreach ($menu_items as $item) {
        $mega_menu_shortcode = get_post_meta($item->ID, '_lamkadeh_mega_shortcode', true);
        if (!empty($mega_menu_shortcode)) {
            echo '<li data-tab-navbar="tab-' . $tab_index . '"><a href="#">' . esc_html($item->title) . '</a></li>';
            $tab_index++;
        }
    }
    echo '</ul></div>';

    echo '<div class="navbar-sidebar-responsive-content">';

    echo '<div id="tab-1" class="navbar-sidebar-responsive-content-item"><ul>';
    foreach ($menu_items as $item) {
        $mega_menu_shortcode = get_post_meta($item->ID, '_lamkadeh_mega_shortcode', true);
        if (empty($mega_menu_shortcode)) {
            echo '<li><a href="' . esc_url($item->url) . '">' . esc_html($item->title) . '</a></li>';
        }
    }
    echo '</ul></div>';

    $tab_index = 2;
    foreach ($menu_items as $item) {
        $mega_menu_shortcode = get_post_meta($item->ID, '_lamkadeh_mega_shortcode', true);
        if (!empty($mega_menu_shortcode)) {
            echo '<div id="tab-' . $tab_index . '" class="navbar-sidebar-responsive-content-item">';
            echo do_shortcode($mega_menu_shortcode);
            echo '</div>';
            $tab_index++;
        }
    }

    echo '</div>';
}

