<?php
class Lamkadeh_Blog_Categories_Widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            'lamkadeh_blog_categories_widget',
            __('فیلتر دسته بندی وبلاگ - لمکده', 'lamkadeh'),
            array('description' => __('نمایش دسته‌بندی‌های وبلاگ', 'lamkadeh'))
        );
    }

    function widget($args, $instance)
    {
        echo $args['before_widget'];

        $categories = get_categories(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        // پیدا کردن صفحه‌ای که از تمپلیت archive.php استفاده می‌کند
        $archive_page_url = $this->get_archive_page_url();
        
        // اگر صفحه آرشیو پیدا نشد، از لینک آرشیو پست‌ها استفاده کن
        if (!$archive_page_url) {
            $archive_page_url = get_post_type_archive_link('post');
        }
        
        // اگر باز هم مقداری پیدا نشد، از صفحه اصلی پست‌ها استفاده کن
        if (!$archive_page_url) {
            $archive_page_url = get_permalink(get_option('page_for_posts'));
        }
        
        // اگر باز هم مقداری پیدا نشد، از صفحه اصلی استفاده کن
        if (!$archive_page_url) {
            $archive_page_url = home_url('/blog/');
        }
?>
        <section class="header-categories-main">
            <div class="title-header-categories-main">
                <span>BLOG CATEGORY</span>
                <div class="text-header-categories-main">
                    <span><?php echo __("<strong>دسته بندی های وبلاگ</strong>", "lamkadeh"); ?></span>
                    <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_42_15383)">
                            <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
                            <path d="M48.4163 13.75H35.583C34.2866 13.75 33.6385 13.75 33.2357 14.1278C32.833 14.5057 32.833 15.1138 32.833 16.3301V16.9624C32.833 17.9138 32.833 18.3895 33.071 18.7838C33.3089 19.1781 33.7437 19.4229 34.6132 19.9123L37.2835 21.4155C37.8668 21.7439 38.1585 21.9081 38.3674 22.0894C38.8023 22.467 39.0701 22.9107 39.1914 23.4549C39.2497 23.7162 39.2497 24.022 39.2497 24.6335L39.2497 27.0805C39.2497 27.9143 39.2497 28.3312 39.4806 28.6562C39.7115 28.9812 40.1217 29.1415 40.942 29.4622C42.6641 30.1354 43.5251 30.472 44.1374 30.089C44.7497 29.706 44.7497 28.8309 44.7497 27.0805V24.6335C44.7497 24.022 44.7497 23.7162 44.8079 23.4549C44.9293 22.9107 45.197 22.467 45.632 22.0894C45.8408 21.9081 46.1325 21.7439 46.7159 21.4155L49.3862 19.9123C50.2557 19.4229 50.6904 19.1781 50.9284 18.7838C51.1663 18.3895 51.1663 17.9138 51.1663 16.9624V16.3301C51.1663 15.1138 51.1663 14.5057 50.7636 14.1278C50.3609 13.75 49.7127 13.75 48.4163 13.75Z" stroke="#1D2977" stroke-width="1.5" />
                            <circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                        </g>
                        <defs>
                            <clipPath id="clip0_42_15383">
                                <rect width="64" height="64" rx="32" fill="white" />
                            </clipPath>
                        </defs>
                    </svg>
                </div>
                <div class="shape-header-categories-main"></div>
            </div>
        </section>

        <section class="filter-category">
            <a href="<?php echo esc_url($archive_page_url); ?>">
                <span><?php echo __("همه‌ی مقالات", "lamkadeh"); ?></span>
                <svg width="25" height="25" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12.0397 21.0818C12.0397 20.8601 11.958 20.6385 11.783 20.4635L5.31969 14.0001L11.783 7.5368C12.1214 7.19847 12.1214 6.63847 11.783 6.30014C11.4447 5.9618 10.8847 5.9618 10.5464 6.30014L3.46469 13.3818C3.12635 13.7201 3.12635 14.2801 3.46469 14.6185L10.5464 21.7001C10.8847 22.0385 11.4447 22.0385 11.783 21.7001C11.958 21.5368 12.0397 21.3035 12.0397 21.0818Z" fill="white" />
                    <path d="M24.7912 14C24.7912 13.5217 24.3946 13.125 23.9162 13.125L4.28125 13.125C3.80292 13.125 3.40625 13.5217 3.40625 14C3.40625 14.4783 3.80292 14.875 4.28125 14.875L23.9162 14.875C24.3946 14.875 24.7912 14.4783 24.7912 14Z" fill="white" />
                </svg>
            </a>

            <?php foreach ($categories as $cat) : ?>
                <a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>">
                    <span><?php echo esc_html($cat->name); ?></span>
                    <svg width="25" height="25" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12.0397 21.0818C12.0397 20.8601 11.958 20.6385 11.783 20.4635L5.31969 14.0001L11.783 7.5368C12.1214 7.19847 12.1214 6.63847 11.783 6.30014C11.4447 5.9618 10.8847 5.9618 10.5464 6.30014L3.46469 13.3818C3.12635 13.7201 3.12635 14.2801 3.46469 14.6185L10.5464 21.7001C10.8847 22.0385 11.4447 22.0385 11.783 21.7001C11.958 21.5368 12.0397 21.3035 12.0397 21.0818Z" fill="white" />
                        <path d="M24.7912 14C24.7912 13.5217 24.3946 13.125 23.9162 13.125L4.28125 13.125C3.80292 13.125 3.40625 13.5217 3.40625 14C3.40625 14.4783 3.80292 14.875 4.28125 14.875L23.9162 14.875C24.3946 14.875 24.7912 14.4783 24.7912 14Z" fill="white" />
                    </svg>
                </a>
            <?php endforeach; ?>
        </section>
<?php
        echo $args['after_widget'];
    }

    /**
     * پیدا کردن صفحه‌ای که از تمپلیت archive.php استفاده می‌کند
     */
    private function get_archive_page_url()
    {
        // جستجو در بین تمام صفحات
        $pages = get_pages(array(
            'post_status' => 'publish',
        ));

        foreach ($pages as $page) {
            // بررسی اینکه آیا این صفحه از تمپلیت archive.php استفاده می‌کند
            $template = get_page_template_slug($page->ID);
            if ($template === 'archive.php') {
                return get_permalink($page->ID);
            }
        }

        return false;
    }
}

add_action('widgets_init', function () {
    register_widget('Lamkadeh_Blog_Categories_Widget');
});