<?php get_header(); ?>
<main class="container">
    <?php breadcrumb() ?>
    <?php
    if (have_posts()) : ?>
        <section class="single-blog">
            <section class="content-blog">
                <?php
                while (have_posts()) : the_post();
                ?>
                    <div class="content-blog-header">
                        <h1><?php the_title(); ?></h1>
                        <div class="content-blog-header-icon">
                            <div id="share-single-blog">
                                <svg width="22" height="22" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M12.375 1.6875C11.0288 1.6875 9.9375 2.77881 9.9375 4.125C9.9375 4.27193 9.9505 4.41582 9.97541 4.55559L6.42743 7.03918C6.4094 7.0518 6.39234 7.06529 6.37626 7.07955C5.96244 6.7556 5.44127 6.5625 4.875 6.5625C3.52881 6.5625 2.4375 7.65381 2.4375 9C2.4375 10.3462 3.52881 11.4375 4.875 11.4375C5.44127 11.4375 5.96245 11.2444 6.37626 10.9205C6.39234 10.9347 6.4094 10.9482 6.42743 10.9608L9.97541 13.4444C9.9505 13.5842 9.9375 13.7281 9.9375 13.875C9.9375 15.2212 11.0288 16.3125 12.375 16.3125C13.7212 16.3125 14.8125 15.2212 14.8125 13.875C14.8125 12.5288 13.7212 11.4375 12.375 11.4375C11.5854 11.4375 10.8835 11.8129 10.4381 12.395L7.07854 10.0434C7.22857 9.72707 7.3125 9.37334 7.3125 9C7.3125 8.62666 7.22857 8.27293 7.07854 7.95664L10.4381 5.60497C10.8835 6.18707 11.5854 6.5625 12.375 6.5625C13.7212 6.5625 14.8125 5.47119 14.8125 4.125C14.8125 2.77881 13.7212 1.6875 12.375 1.6875ZM11.0625 4.125C11.0625 3.40013 11.6501 2.8125 12.375 2.8125C13.0999 2.8125 13.6875 3.40013 13.6875 4.125C13.6875 4.84987 13.0999 5.4375 12.375 5.4375C11.6501 5.4375 11.0625 4.84987 11.0625 4.125ZM4.875 7.6875C4.15013 7.6875 3.5625 8.27513 3.5625 9C3.5625 9.72487 4.15013 10.3125 4.875 10.3125C5.59987 10.3125 6.1875 9.72487 6.1875 9C6.1875 8.27513 5.59987 7.6875 4.875 7.6875ZM12.375 12.5625C11.6501 12.5625 11.0625 13.1501 11.0625 13.875C11.0625 14.5999 11.6501 15.1875 12.375 15.1875C13.0999 15.1875 13.6875 14.5999 13.6875 13.875C13.6875 13.1501 13.0999 12.5625 12.375 12.5625Z" fill="#1D2977" />
                                </svg>
                            </div>
                            <div id="like-post" class="like-button" data-postid="<?php the_ID(); ?>">
                                <svg width="22" height="22" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1.33301 6.0914C1.33301 9.33335 4.01263 11.0609 5.97416 12.6073C6.66634 13.1529 7.33301 13.6667 7.99967 13.6667C8.66634 13.6667 9.33301 13.1529 10.0252 12.6073C11.9867 11.0609 14.6663 9.33335 14.6663 6.0914C14.6663 2.84944 10.9996 0.550309 7.99967 3.66709C4.99978 0.550309 1.33301 2.84944 1.33301 6.0914Z" fill="#1D2977" />
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="content-blog-bottom">
                        <div class="text-single-blog">
                            <?php the_content(); ?>
                        </div>
                    </div>
                <?php
                endwhile;
                ?>
            </section>
            <section class="sidebar-blog">
                <h4><?php echo __("مقالات مرتبط", "lamkadeh"); ?></h4>

                <?php
                global $post;

                $current_post_id = get_the_ID();

                $related_query = new WP_Query(array(
                    'post_type' => 'post',
                    'posts_per_page' => 4,
                    'post__not_in' => array($current_post_id),
                    'orderby' => 'date',
                    'order' => 'DESC'
                ));

                if ($related_query->have_posts()) :
                    while ($related_query->have_posts()) : $related_query->the_post();

                        if (has_post_thumbnail()) {
                            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                        } else {
                            $image_url = 'https://via.placeholder.com/400x250?text=No+Image';
                        }

                        // محاسبه زمان مطالعه
                        $reading_time = calculate_reading_time(get_the_content());
                ?>

                        <div class="sidebar-blog-item">
                            <div class="sidebar-blog-item-right" style="background-image: url('<?php echo esc_url($image_url); ?>');"></div>
                            <div class="sidebar-blog-item-left">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                <div class="sidebar-blog-item-left-meta">
                                    <div class="sidebar-blog-item-left-meta-time">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M10.0003 2.2915C5.74313 2.2915 2.29199 5.74264 2.29199 9.99984C2.29199 14.257 5.74313 17.7082 10.0003 17.7082C14.2575 17.7082 17.7087 14.257 17.7087 9.99984C17.7087 5.74264 14.2575 2.2915 10.0003 2.2915ZM1.04199 9.99984C1.04199 5.05229 5.05277 1.0415 10.0003 1.0415C14.9479 1.0415 18.9587 5.05229 18.9587 9.99984C18.9587 14.9474 14.9479 18.9582 10.0003 18.9582C5.05277 18.9582 1.04199 14.9474 1.04199 9.99984ZM10.0003 6.0415C10.3455 6.0415 10.6253 6.32133 10.6253 6.6665V9.74095L12.5256 11.6412C12.7697 11.8853 12.7697 12.281 12.5256 12.5251C12.2815 12.7692 11.8858 12.7692 11.6417 12.5251L9.55838 10.4418C9.44117 10.3246 9.37533 10.1656 9.37533 9.99984V6.6665C9.37533 6.32133 9.65515 6.0415 10.0003 6.0415Z" fill="#020308" fill-opacity="0.64" />
                                        </svg>
                                        <span><?php echo sprintf(__('زمان مطالعه: %d دقیقه', 'lamkadeh'), $reading_time); ?></span>
                                    </div>
                                    <?php
                                    $likes = get_post_meta(get_the_ID(), '_lamkadeh_likes', true);
                                    if (!is_array($likes)) $likes = [];

                                    $user_id = get_current_user_id();
                                    $user_ip = $_SERVER['REMOTE_ADDR'];
                                    $unique_key = $user_id ? 'user_' . $user_id : 'ip_' . $user_ip;
                                    $is_liked = in_array($unique_key, $likes);
                                    ?>

                                    <div class="sidebar-blog-item-left-meta-like <?php echo $is_liked ? 'active' : ''; ?>" data-post-id="<?php echo get_the_ID(); ?>">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M4.68729 3.68675C3.3048 4.31869 2.29199 5.82179 2.29199 7.61417C2.29199 9.44534 3.04134 10.8568 4.11556 12.0664C5.00093 13.0634 6.07269 13.8896 7.11793 14.6954C7.36619 14.8868 7.61295 15.0771 7.85536 15.2682C8.29372 15.6137 8.68476 15.917 9.06167 16.1373C9.43878 16.3576 9.74232 16.4583 10.0003 16.4583C10.2583 16.4583 10.5619 16.3576 10.939 16.1373C11.3159 15.917 11.7069 15.6137 12.1453 15.2682C12.3877 15.0771 12.6345 14.8868 12.8827 14.6954C13.928 13.8896 14.9997 13.0634 15.8851 12.0664C16.9593 10.8568 17.7087 9.44534 17.7087 7.61417C17.7087 5.82179 16.6959 4.31869 15.3134 3.68675C13.9703 3.07282 12.1656 3.23541 10.4506 5.0172C10.3328 5.13962 10.1702 5.20879 10.0003 5.20879C9.83042 5.20879 9.66784 5.13962 9.55002 5.0172C7.83504 3.23541 6.03038 3.07282 4.68729 3.68675ZM10.0003 3.71561C8.07361 1.99179 5.91613 1.75065 4.16763 2.54989C2.32092 3.39403 1.04199 5.35412 1.04199 7.61417C1.04199 9.83545 1.96741 11.53 3.18092 12.8964C4.15272 13.9907 5.34218 14.9066 6.39268 15.7154C6.63081 15.8988 6.86181 16.0766 7.08151 16.2498C7.50837 16.5863 7.96661 16.9452 8.43101 17.2165C8.89521 17.4878 9.42499 17.7083 10.0003 17.7083C10.5757 17.7083 11.1054 17.4878 11.5696 17.2165C12.034 16.9452 12.4923 16.5863 12.9191 16.2498C13.1388 16.0766 13.3698 15.8988 13.608 15.7154C14.6585 14.9066 15.8479 13.9907 16.8197 12.8964C18.0332 11.53 18.9587 9.83545 18.9587 7.61417C18.9587 5.35412 17.6797 3.39403 15.833 2.54989C14.0845 1.75065 11.927 1.99179 10.0003 3.71561Z"
                                                fill="#1D2977" />
                                        </svg>
                                    </div>

                                </div>
                            </div>
                        </div>

                    <?php endwhile;
                    wp_reset_postdata();
                else : ?>
                    <p><?php echo __("مقاله مرتبطی یافت نشد.", "lamkadeh"); ?></p>
                <?php endif; ?>
            </section>
        </section>
        <section class="comment-blog">
            <?php if (comments_open() || get_comments_number()) {
                comments_template();
            } ?>
        </section>

        <section class="all-blogs-widget">
            <div class="header-categories-main">
                <div class="title-header-categories-main">
                    <span>SIMILLAR BLOGS</span>
                    <div class="text-header-categories-main">
                        <span><?php echo __("مقالات <strong>مرتبط</strong>", "lamkadeh") ?></span>
                        <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_46_18332)">
                                <circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M41.0316 12.1458H42.9684C44.653 12.1457 45.9873 12.1457 47.0316 12.2861C48.1063 12.4306 48.9762 12.7351 49.6622 13.4211C50.3482 14.1071 50.6526 14.9769 50.7971 16.0516C50.9375 17.0959 50.9375 18.4303 50.9375 20.1149V23.885C50.9375 25.5696 50.9375 26.9039 50.7971 27.9482C50.6526 29.0229 50.3482 29.8928 49.6622 30.5788C48.9762 31.2648 48.1063 31.5692 47.0316 31.7137C45.9873 31.8541 44.653 31.8541 42.9684 31.8541H41.0316C39.347 31.8541 38.0127 31.8541 36.9684 31.7137C35.8937 31.5692 35.0238 31.2648 34.3378 30.5788C33.6518 29.8928 33.3474 29.0229 33.2029 27.9482C33.0625 26.9039 33.0625 25.5696 33.0625 23.885V20.1149C33.0625 18.4303 33.0625 17.0959 33.2029 16.0516C33.3474 14.9769 33.6518 14.1071 34.3378 13.4211C35.0238 12.7351 35.8937 12.4306 36.9684 12.2861C38.0127 12.1457 39.347 12.1457 41.0316 12.1458ZM37.1516 13.6489C36.2294 13.7729 35.698 14.0054 35.3101 14.3933C34.9221 14.7813 34.6896 15.3126 34.5656 16.2349C34.439 17.1769 34.4375 18.4187 34.4375 20.1666V23.8333C34.4375 25.5812 34.439 26.8229 34.5656 27.765C34.6896 28.6872 34.9221 29.2186 35.3101 29.6065C35.698 29.9944 36.2294 30.227 37.1516 30.351C38.0936 30.4776 39.3354 30.4791 41.0833 30.4791H42.9167C44.6646 30.4791 45.9064 30.4776 46.8484 30.351C47.7706 30.227 48.302 29.9944 48.6899 29.6065C49.0779 29.2186 49.3104 28.6872 49.4344 27.765C49.561 26.8229 49.5625 25.5812 49.5625 23.8333V20.1666C49.5625 18.4187 49.561 17.1769 49.4344 16.2349C49.3104 15.3126 49.0779 14.7813 48.6899 14.3933C48.302 14.0054 47.7706 13.7729 46.8484 13.6489C45.9064 13.5222 44.6646 13.5208 42.9167 13.5208H41.0833C39.3354 13.5208 38.0936 13.5222 37.1516 13.6489ZM37.6458 18.3333C37.6458 17.9536 37.9536 17.6458 38.3333 17.6458H45.6667C46.0464 17.6458 46.3542 17.9536 46.3542 18.3333C46.3542 18.7129 46.0464 19.0208 45.6667 19.0208H38.3333C37.9536 19.0208 37.6458 18.7129 37.6458 18.3333ZM37.6458 21.9999C37.6458 21.6202 37.9536 21.3124 38.3333 21.3124H45.6667C46.0464 21.3124 46.3542 21.6202 46.3542 21.9999C46.3542 22.3796 46.0464 22.6874 45.6667 22.6874H38.3333C37.9536 22.6874 37.6458 22.3796 37.6458 21.9999ZM37.6458 25.6666C37.6458 25.2869 37.9536 24.9791 38.3333 24.9791H42.9167C43.2964 24.9791 43.6042 25.2869 43.6042 25.6666C43.6042 26.0463 43.2964 26.3541 42.9167 26.3541H38.3333C37.9536 26.3541 37.6458 26.0463 37.6458 25.6666Z" fill="#1D2977" />
                                <circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
                            </g>
                            <defs>
                                <clipPath id="clip0_46_18332">
                                    <rect width="64" height="64" rx="32" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                    <div class="shape-header-categories-main"></div>
                </div>
                <div class="line-header-categories-main"></div>
                <p class="description-header-categories-main">
                    <?php echo __("تو <strong>وبــــلاگ ما</strong> کلی مطلب جذاب درباره چیدمان، دکوراسیون و <strong>انتخاب مــــــــبلمان</strong> منتظرته.", "lamkadeh") ?>
                </p>
                <div class="line-header-categories-main-two"></div>
                <a href="<?php echo esc_url(home_url('/blog')); ?>" class="show-more-header-categories-main">
                    <div>
                        <span><?php echo __("همه مقالات", "lamkadeh") ?></span>
                    </div>
                    <div>
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M23.6216 13.6066C23.4648 13.7633 23.2504 13.8623 23.0029 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4664 23.8773 12.9879 23.8773C12.5094 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5094 12.1134 12.9879 12.1134L23.0029 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8856 13.2271 23.7783 13.4498 23.6216 13.6066Z"
                                fill="white" />
                            <path
                                d="M27.6308 27.6308C27.2926 27.969 26.7316 27.969 26.3934 27.6308L12.5093 13.7468C12.1711 13.4085 12.1711 12.8476 12.5093 12.5093C12.8476 12.1711 13.4085 12.1711 13.7468 12.5093L27.6308 26.3934C27.9691 26.7316 27.9691 27.2926 27.6308 27.6308Z"
                                fill="white" />
                        </svg>
                    </div>
                </a>
            </div>

            <div class="all-blogs-widget-body">
                <?php
                $args = array(
                    'post_type' => 'post',
                    'posts_per_page' => 6,
                    'post_status' => 'publish',
                    'orderby' => 'date',
                    'order' => 'DESC'
                );

                $latest_posts = new WP_Query($args);
                $posts = array();

                if ($latest_posts->have_posts()) {
                    while ($latest_posts->have_posts()) {
                        $latest_posts->the_post();
                        $posts[] = array(
                            'id' => get_the_ID(),
                            'title' => get_the_title(),
                            'permalink' => get_permalink(),
                            'excerpt' => get_the_excerpt(),
                            'thumbnail' => get_the_post_thumbnail_url(get_the_ID(), 'medium'),
                            'category' => get_the_category() ? get_the_category()[0]->name : 'دسته بندی',
                            'category_link' => get_the_category() ? get_category_link(get_the_category()[0]->term_id) : '#',
                            'reading_time' => calculate_reading_time(get_the_content()),
                            'comment_count' => get_comments_number()
                        );
                    }
                    wp_reset_postdata();
                }

                if (count($posts) < 6) {
                    $sample_posts = array(
                        array(
                            'title' => 'چطور فضای کوچک رو بزرگ‌تر نشون بدیم؟',
                            'category' => 'دسته بندی',
                            'reading_time' => '۵ دقیقه'
                        ),
                        array(
                            'title' => 'راهنمای انتخاب مبل مناسب برای هر سبک دکوراسیون',
                            'category' => 'دسته بندی',
                            'reading_time' => '۵ دقیقه'
                        ),
                        array(
                            'title' => 'تفاوت مبلمان مدرن و کلاسیک در یک نگاه',
                            'category' => 'دسته بندی',
                            'reading_time' => '۵ دقیقه'
                        )
                    );

                    for ($i = count($posts); $i < 6; $i++) {
                        $sample_index = ($i % count($sample_posts));
                        $posts[] = array(
                            'id' => $i + 1000,
                            'title' => $sample_posts[$sample_index]['title'],
                            'permalink' => '#',
                            'excerpt' => '',
                            'thumbnail' => 'http://lamkadeh.com/wp-content/uploads/2025/08/dba8d879bb1ba37b28a315e437fb8917d7535e2b-300x200.jpg',
                            'category' => $sample_posts[$sample_index]['category'],
                            'category_link' => '#',
                            'reading_time' => $sample_posts[$sample_index]['reading_time'],
                            'comment_count' => 125
                        );
                    }
                }
                ?>

                <div class="all-blogs-widget-body-right">
                    <?php for ($i = 0; $i < 2; $i++): ?>
                        <?php if (isset($posts[$i])): ?>
                            <div class="all-blogs-widget-body-right-item">
                                <div class="all-blogs-widget-body-right-item-image" style="background-image: url('<?php echo esc_url($posts[$i]['thumbnail']); ?>');"></div>
                                <div class="all-blogs-widget-body-right-item-content">
                                    <div class="all-blogs-widget-body-right-item-content-header">
                                        <a href="<?php echo esc_url($posts[$i]['category_link']); ?>"><?php echo esc_html($posts[$i]['category']); ?></a>
                                        <a href="<?php echo esc_url($posts[$i]['permalink']); ?>"><?php echo esc_html($posts[$i]['title']); ?></a>
                                    </div>
                                    <div class="all-blogs-widget-body-right-item-content-bottom">
                                        <div class="all-blogs-widget-body-right-item-content-bottom-time">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M10.0003 2.29175C5.74313 2.29175 2.29199 5.74289 2.29199 10.0001C2.29199 14.2573 5.74313 17.7084 10.0003 17.7084C14.2575 17.7084 17.7087 14.2573 17.7087 10.0001C17.7087 5.74289 14.2575 2.29175 10.0003 2.29175ZM1.04199 10.0001C1.04199 5.05253 5.05277 1.04175 10.0003 1.04175C14.9479 1.04175 18.9587 5.05253 18.9587 10.0001C18.9587 14.9476 14.9479 18.9584 10.0003 18.9584C5.05277 18.9584 1.04199 14.9476 1.04199 10.0001ZM10.0003 6.04175C10.3455 6.04175 10.6253 6.32157 10.6253 6.66675V9.7412L12.5256 11.6415C12.7697 11.8856 12.7697 12.2813 12.5256 12.5254C12.2815 12.7694 11.8858 12.7694 11.6417 12.5254L9.55838 10.442C9.44117 10.3248 9.37533 10.1658 9.37533 10.0001V6.66675C9.37533 6.32157 9.65515 6.04175 10.0003 6.04175Z" fill="#020308" fill-opacity="0.64" />
                                            </svg>
                                            <span>زمان مطالعه : <?php echo esc_html($posts[$i]['reading_time']); ?></span>
                                        </div>
                                        <div class="all-blogs-widget-body-right-item-content-bottom-like">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M4.68729 3.68675C3.3048 4.31869 2.29199 5.82179 2.29199 7.61417C2.29199 9.44534 3.04134 10.8568 4.11556 12.0664C5.00093 13.0634 6.07269 13.8896 7.11793 14.6954C7.36619 14.8868 7.61295 15.0771 7.85536 15.2682C8.29372 15.6137 8.68476 15.917 9.06167 16.1373C9.43878 16.3576 9.74232 16.4583 10.0003 16.4583C10.2583 16.4583 10.5619 16.3576 10.939 16.1373C11.3159 15.917 11.7069 15.6137 12.1453 15.2682C12.3877 15.0771 12.6345 14.8868 12.8827 14.6954C13.928 13.8896 14.9997 13.0634 15.8851 12.0664C16.9593 10.8568 17.7087 9.44534 17.7087 7.61417C17.7087 5.82179 16.6959 4.31869 15.3134 3.68675C13.9703 3.07282 12.1656 3.23541 10.4506 5.0172C10.3328 5.13962 10.1702 5.20879 10.0003 5.20879C9.83042 5.20879 9.66784 5.13962 9.55002 5.0172C7.83504 3.23541 6.03038 3.07282 4.68729 3.68675ZM10.0003 3.71561C8.07361 1.99179 5.91613 1.75065 4.16763 2.54989C2.32092 3.39403 1.04199 5.35412 1.04199 7.61417C1.04199 9.83545 1.96741 11.53 3.18092 12.8964C4.15272 13.9907 5.34218 14.9066 6.39268 15.7154C6.63081 15.8988 6.86181 16.0766 7.08151 16.2498C7.50837 16.5863 7.96661 16.9452 8.43101 17.2165C8.89521 17.4878 9.42499 17.7083 10.0003 17.7083C10.5757 17.7083 11.1054 17.4878 11.5696 17.2165C12.034 16.9452 12.4923 16.5863 12.9191 16.2498C13.1388 16.0766 13.3698 15.8988 13.608 15.7154C14.6585 14.9066 15.8479 13.9907 16.8197 12.8964C18.0332 11.53 18.9587 9.83545 18.9587 7.61417C18.9587 5.35412 17.6797 3.39403 15.833 2.54989C14.0845 1.75065 11.927 1.99179 10.0003 3.71561Z" fill="#1D2977" />
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endfor; ?>
                </div>

                <?php if (isset($posts[2])): ?>
                    <div class="all-blogs-widget-body-center" style="background-image: url('<?php echo esc_url($posts[2]['thumbnail']); ?>');">
                        <a href="<?php echo esc_url($posts[2]['category_link']); ?>" class="all-blogs-widget-body-center-category"><?php echo esc_html($posts[2]['category']); ?></a>
                        <div class="all-blogs-widget-body-center-content">
                            <h4>
                                <a href="<?php echo esc_url($posts[2]['permalink']); ?>">
                                    <?php echo esc_html($posts[2]['title']); ?>
                                </a>
                            </h4>
                            <div class="underline-lamkadeh">
                                <div class="underline-lamkadeh-line"></div>
                                <div class="underline-lamkadeh-circle"></div>
                            </div>
                            <div class="all-blogs-widget-body-center-content-meta">
                                <div class="all-blogs-widget-body-center-content-meta-time">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12ZM12 7.25C12.4142 7.25 12.75 7.58579 12.75 8V11.6893L15.0303 13.9697C15.3232 14.2626 15.3232 14.7374 15.0303 15.0303C14.7374 15.3232 14.2626 15.3232 13.9697 15.0303L11.4697 12.5303C11.329 12.3897 11.25 12.1989 11.25 12V8C11.25 7.58579 11.5858 7.25 12 7.25Z" fill="#F7F8FD" />
                                    </svg>
                                    <span><?php echo __('زمان مطالعه : ', 'lamkadeh') . esc_html($posts[2]['reading_time']); ?></span>
                                </div>
                                <div class="all-blogs-widget-body-center-content-meta-comments">
                                    <span><?php echo esc_html($posts[2]['comment_count']); ?></span>
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_46_18362)">
                                            <path d="M10.333 1.09985C12.855 1.09985 14.8992 3.14431 14.8994 5.66626C14.8994 6.34186 14.753 6.98421 14.4893 7.56177C14.3963 7.76534 14.3674 7.98027 14.4189 8.1731L14.5039 8.49048C14.7227 9.30808 13.9748 10.0567 13.1572 9.83813L12.8398 9.75317C12.6961 9.71472 12.5399 9.72039 12.3867 9.76392L12.2158 9.81274L12.1943 9.9895C11.8698 12.7545 9.51828 14.8997 6.66602 14.8997C5.80689 14.8996 4.99273 14.7048 4.26562 14.3567C4.06714 14.2617 3.85259 14.2337 3.65918 14.2854L2.8418 14.5042C2.02431 14.7226 1.27648 13.975 1.49512 13.1575L1.71387 12.3401C1.74379 12.2282 1.74361 12.1101 1.72266 12.9915L1.96875 11.8743L1.85352 11.6331L1.73828 11.3928L1.53418 11.4895C1.25507 10.8259 1.09961 10.0976 1.09961 9.33325C1.09961 6.4767 3.25148 4.12194 6.02246 3.80298L6.16797 3.78638L6.23145 3.65552C6.97506 2.14184 8.53229 1.09985 10.333 1.09985ZM6.66602 4.23364C3.84951 4.23382 1.56641 6.51671 1.56641 9.33325C1.56641 10.0263 1.705 10.6864 1.95508 11.2883L1.74805 11.3879L1.86328 11.6282L1.97852 11.8694L2.15625 11.7834C2.21552 12.0001 2.22588 12.2325 2.16504 12.4602L1.94629 13.2776C1.82033 13.7484 2.25092 14.1799 2.72168 14.054L3.53906 13.8352C3.85781 13.7499 4.18605 13.8014 4.4668 13.9358C5.13236 14.2544 5.87808 14.4328 6.66602 14.4329C9.48267 14.4329 11.7666 12.1499 11.7666 9.33325C11.7666 6.5166 9.48267 4.23364 6.66602 4.23364ZM4.33301 8.93286C4.55392 8.93286 4.7334 9.11234 4.7334 9.33325C4.7334 9.55417 4.55392 9.73364 4.33301 9.73364C4.11209 9.73364 3.93262 9.55417 3.93262 9.33325C3.93262 9.11234 4.11209 8.93286 4.33301 8.93286ZM6.66602 8.93286C6.88693 8.93286 7.06641 9.11234 7.06641 9.33325C7.06641 9.55417 6.88693 9.73364 6.66602 9.73364C6.44525 9.73347 6.2666 9.55406 6.2666 9.33325C6.2666 9.11245 6.44525 8.93304 6.66602 8.93286ZM9 8.93286C9.22076 8.93304 9.39941 9.11245 9.39941 9.33325C9.39941 9.55406 9.22076 9.73347 9 9.73364C8.77909 9.73364 8.59961 9.55417 8.59961 9.33325C8.59961 9.11234 8.77909 8.93286 9 8.93286ZM10.333 1.56665C8.9197 1.56665 7.67257 2.28192 6.93555 3.37036L6.67969 3.74829L7.13379 3.78638C9.8848 4.01517 12.069 6.2447 12.2246 9.01587L12.2393 9.29321L12.5156 9.26685C12.6617 9.25293 12.8113 9.26228 12.96 9.302L13.2773 9.38696C13.748 9.5129 14.1794 9.08222 14.0537 8.61157L13.9688 8.29419C13.8833 7.97497 13.9368 7.64806 14.0645 7.36841C14.3011 6.8504 14.4326 6.27375 14.4326 5.66626C14.4324 3.40204 12.5973 1.56665 10.333 1.56665Z" fill="#F7F8FD" stroke="#F7F8FD" stroke-width="0.533333" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_46_18362">
                                                <rect width="16" height="16" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="all-blogs-widget-body-responsive">
                    <?php if (isset($posts[1])): ?>
                        <div class="all-blogs-widget-body-center" style="background-image: url('<?php echo esc_url($posts[1]['thumbnail']); ?>');">
                            <a href="<?php echo esc_url($posts[1]['category_link']); ?>" class="all-blogs-widget-body-center-category"><?php echo esc_html($posts[1]['category']); ?></a>
                            <div class="all-blogs-widget-body-center-content">
                                <h4>
                                    <a href="<?php echo esc_url($posts[1]['permalink']); ?>">
                                        <?php echo esc_html($posts[1]['title']); ?>
                                    </a>
                                </h4>
                                <div class="underline-lamkadeh">
                                    <div class="underline-lamkadeh-line"></div>
                                    <div class="underline-lamkadeh-circle"></div>
                                </div>
                                <div class="all-blogs-widget-body-center-content-meta">
                                    <div class="all-blogs-widget-body-center-content-meta-time">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12ZM12 7.25C12.4142 7.25 12.75 7.58579 12.75 8V11.6893L15.0303 13.9697C15.3232 14.2626 15.3232 14.7374 15.0303 15.0303C14.7374 15.3232 14.2626 15.3232 13.9697 15.0303L11.4697 12.5303C11.329 12.3897 11.25 12.1989 11.25 12V8C11.25 7.58579 11.5858 7.25 12 7.25Z" fill="#F7F8FD" />
                                        </svg>
                                        <span><?php echo __('زمان مطالعه : ', 'lamkadeh') . esc_html($posts[1]['reading_time']); ?></span>
                                    </div>
                                    <div class="all-blogs-widget-body-center-content-meta-comments">
                                        <span><?php echo esc_html($posts[1]['comment_count']); ?></span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_46_18362)">
                                                <path d="M10.333 1.09985C12.855 1.09985 14.8992 3.14431 14.8994 5.66626C14.8994 6.34186 14.753 6.98421 14.4893 7.56177C14.3963 7.76534 14.3674 7.98027 14.4189 8.1731L14.5039 8.49048C14.7227 9.30808 13.9748 10.0567 13.1572 9.83813L12.8398 9.75317C12.6961 9.71472 12.5399 9.72039 12.3867 9.76392L12.2158 9.81274L12.1943 9.9895C11.8698 12.7545 9.51828 14.8997 6.66602 14.8997C5.80689 14.8996 4.99273 14.7048 4.26562 14.3567C4.06714 14.2617 3.85259 14.2337 3.65918 14.2854L2.8418 14.5042C2.02431 14.7226 1.27648 13.975 1.49512 13.1575L1.71387 12.3401C1.74379 12.2282 1.74361 12.1101 1.72266 12.9915L1.96875 11.8743L1.85352 11.6331L1.73828 11.3928L1.53418 11.4895C1.25507 10.8259 1.09961 10.0976 1.09961 9.33325C1.09961 6.4767 3.25148 4.12194 6.02246 3.80298L6.16797 3.78638L6.23145 3.65552C6.97506 2.14184 8.53229 1.09985 10.333 1.09985ZM6.66602 4.23364C3.84951 4.23382 1.56641 6.51671 1.56641 9.33325C1.56641 10.0263 1.705 10.6864 1.95508 11.2883L1.74805 11.3879L1.86328 11.6282L1.97852 11.8694L2.15625 11.7834C2.21552 12.0001 2.22588 12.2325 2.16504 12.4602L1.94629 13.2776C1.82033 13.7484 2.25092 14.1799 2.72168 14.054L3.53906 13.8352C3.85781 13.7499 4.18605 13.8014 4.4668 13.9358C5.13236 14.2544 5.87808 14.4328 6.66602 14.4329C9.48267 14.4329 11.7666 12.1499 11.7666 9.33325C11.7666 6.5166 9.48267 4.23364 6.66602 4.23364ZM4.33301 8.93286C4.55392 8.93286 4.7334 9.11234 4.7334 9.33325C4.7334 9.55417 4.55392 9.73364 4.33301 9.73364C4.11209 9.73364 3.93262 9.55417 3.93262 9.33325C3.93262 9.11234 4.11209 8.93286 4.33301 8.93286ZM6.66602 8.93286C6.88693 8.93286 7.06641 9.11234 7.06641 9.33325C7.06641 9.55417 6.88693 9.73364 6.66602 9.73364C6.44525 9.73347 6.2666 9.55406 6.2666 9.33325C6.2666 9.11245 6.44525 8.93304 6.66602 8.93286ZM9 8.93286C9.22076 8.93304 9.39941 9.11245 9.39941 9.33325C9.39941 9.55406 9.22076 9.73347 9 9.73364C8.77909 9.73364 8.59961 9.55417 8.59961 9.33325C8.59961 9.11234 8.77909 8.93286 9 8.93286ZM10.333 1.56665C8.9197 1.56665 7.67257 2.28192 6.93555 3.37036L6.67969 3.74829L7.13379 3.78638C9.8848 4.01517 12.069 6.2447 12.2246 9.01587L12.2393 9.29321L12.5156 9.26685C12.6617 9.25293 12.8113 9.26228 12.96 9.302L13.2773 9.38696C13.748 9.5129 14.1794 9.08222 14.0537 8.61157L13.9688 8.29419C13.8833 7.97497 13.9368 7.64806 14.0645 7.36841C14.3011 6.8504 14.4326 6.27375 14.4326 5.66626C14.4324 3.40204 12.5973 1.56665 10.333 1.56665Z" fill="#F7F8FD" stroke="#F7F8FD" stroke-width="0.533333" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_46_18362">
                                                    <rect width="16" height="16" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($posts[2])): ?>
                        <div class="all-blogs-widget-body-center" style="background-image: url('<?php echo esc_url($posts[2]['thumbnail']); ?>');">
                            <a href="<?php echo esc_url($posts[2]['category_link']); ?>" class="all-blogs-widget-body-center-category"><?php echo esc_html($posts[2]['category']); ?></a>
                            <div class="all-blogs-widget-body-center-content">
                                <h4>
                                    <a href="<?php echo esc_url($posts[2]['permalink']); ?>">
                                        <?php echo esc_html($posts[2]['title']); ?>
                                    </a>
                                </h4>
                                <div class="underline-lamkadeh">
                                    <div class="underline-lamkadeh-line"></div>
                                    <div class="underline-lamkadeh-circle"></div>
                                </div>
                                <div class="all-blogs-widget-body-center-content-meta">
                                    <div class="all-blogs-widget-body-center-content-meta-time">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12ZM12 7.25C12.4142 7.25 12.75 7.58579 12.75 8V11.6893L15.0303 13.9697C15.3232 14.2626 15.3232 14.7374 15.0303 15.0303C14.7374 15.3232 14.2626 15.3232 13.9697 15.0303L11.4697 12.5303C11.329 12.3897 11.25 12.1989 11.25 12V8C11.25 7.58579 11.5858 7.25 12 7.25Z" fill="#F7F8FD" />
                                        </svg>
                                        <span><?php echo __('زمان مطالعه : ', 'lamkadeh') . esc_html($posts[2]['reading_time']); ?></span>
                                    </div>
                                    <div class="all-blogs-widget-body-center-content-meta-comments">
                                        <span><?php echo esc_html($posts[2]['comment_count']); ?></span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_46_18362)">
                                                <path d="M10.333 1.09985C12.855 1.09985 14.8992 3.14431 14.8994 5.66626C14.8994 6.34186 14.753 6.98421 14.4893 7.56177C14.3963 7.76534 14.3674 7.98027 14.4189 8.1731L14.5039 8.49048C14.7227 9.30808 13.9748 10.0567 13.1572 9.83813L12.8398 9.75317C12.6961 9.71472 12.5399 9.72039 12.3867 9.76392L12.2158 9.81274L12.1943 9.9895C11.8698 12.7545 9.51828 14.8997 6.66602 14.8997C5.80689 14.8996 4.99273 14.7048 4.26562 14.3567C4.06714 14.2617 3.85259 14.2337 3.65918 14.2854L2.8418 14.5042C2.02431 14.7226 1.27648 13.975 1.49512 13.1575L1.71387 12.3401C1.74379 12.2282 1.74361 12.1101 1.72266 12.9915L1.96875 11.8743L1.85352 11.6331L1.73828 11.3928L1.53418 11.4895C1.25507 10.8259 1.09961 10.0976 1.09961 9.33325C1.09961 6.4767 3.25148 4.12194 6.02246 3.80298L6.16797 3.78638L6.23145 3.65552C6.97506 2.14184 8.53229 1.09985 10.333 1.09985ZM6.66602 4.23364C3.84951 4.23382 1.56641 6.51671 1.56641 9.33325C1.56641 10.0263 1.705 10.6864 1.95508 11.2883L1.74805 11.3879L1.86328 11.6282L1.97852 11.8694L2.15625 11.7834C2.21552 12.0001 2.22588 12.2325 2.16504 12.4602L1.94629 13.2776C1.82033 13.7484 2.25092 14.1799 2.72168 14.054L3.53906 13.8352C3.85781 13.7499 4.18605 13.8014 4.4668 13.9358C5.13236 14.2544 5.87808 14.4328 6.66602 14.4329C9.48267 14.4329 11.7666 12.1499 11.7666 9.33325C11.7666 6.5166 9.48267 4.23364 6.66602 4.23364ZM4.33301 8.93286C4.55392 8.93286 4.7334 9.11234 4.7334 9.33325C4.7334 9.55417 4.55392 9.73364 4.33301 9.73364C4.11209 9.73364 3.93262 9.55417 3.93262 9.33325C3.93262 9.11234 4.11209 8.93286 4.33301 8.93286ZM6.66602 8.93286C6.88693 8.93286 7.06641 9.11234 7.06641 9.33325C7.06641 9.55417 6.88693 9.73364 6.66602 9.73364C6.44525 9.73347 6.2666 9.55406 6.2666 9.33325C6.2666 9.11245 6.44525 8.93304 6.66602 8.93286ZM9 8.93286C9.22076 8.93304 9.39941 9.11245 9.39941 9.33325C9.39941 9.55406 9.22076 9.73347 9 9.73364C8.77909 9.73364 8.59961 9.55417 8.59961 9.33325C8.59961 9.11234 8.77909 8.93286 9 8.93286ZM10.333 1.56665C8.9197 1.56665 7.67257 2.28192 6.93555 3.37036L6.67969 3.74829L7.13379 3.78638C9.8848 4.01517 12.069 6.2447 12.2246 9.01587L12.2393 9.29321L12.5156 9.26685C12.6617 9.25293 12.8113 9.26228 12.96 9.302L13.2773 9.38696C13.748 9.5129 14.1794 9.08222 14.0537 8.61157L13.9688 8.29419C13.8833 7.97497 13.9368 7.64806 14.0645 7.36841C14.3011 6.8504 14.4326 6.27375 14.4326 5.66626C14.4324 3.40204 12.5973 1.56665 10.333 1.56665Z" fill="#F7F8FD" stroke="#F7F8FD" stroke-width="0.533333" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_46_18362">
                                                    <rect width="16" height="16" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($posts[3])): ?>
                        <div class="all-blogs-widget-body-center" style="background-image: url('<?php echo esc_url($posts[3]['thumbnail']); ?>');">
                            <a href="<?php echo esc_url($posts[3]['category_link']); ?>" class="all-blogs-widget-body-center-category"><?php echo esc_html($posts[3]['category']); ?></a>
                            <div class="all-blogs-widget-body-center-content">
                                <h4>
                                    <a href="<?php echo esc_url($posts[3]['permalink']); ?>">
                                        <?php echo esc_html($posts[3]['title']); ?>
                                    </a>
                                </h4>
                                <div class="underline-lamkadeh">
                                    <div class="underline-lamkadeh-line"></div>
                                    <div class="underline-lamkadeh-circle"></div>
                                </div>
                                <div class="all-blogs-widget-body-center-content-meta">
                                    <div class="all-blogs-widget-body-center-content-meta-time">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12ZM12 7.25C12.4142 7.25 12.75 7.58579 12.75 8V11.6893L15.0303 13.9697C15.3232 14.2626 15.3232 14.7374 15.0303 15.0303C14.7374 15.3232 14.2626 15.3232 13.9697 15.0303L11.4697 12.5303C11.329 12.3897 11.25 12.1989 11.25 12V8C11.25 7.58579 11.5858 7.25 12 7.25Z" fill="#F7F8FD" />
                                        </svg>
                                        <span><?php echo __('زمان مطالعه : ', 'lamkadeh') . esc_html($posts[3]['reading_time']); ?></span>
                                    </div>
                                    <div class="all-blogs-widget-body-center-content-meta-comments">
                                        <span><?php echo esc_html($posts[3]['comment_count']); ?></span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_46_18362)">
                                                <path d="M10.333 1.09985C12.855 1.09985 14.8992 3.14431 14.8994 5.66626C14.8994 6.34186 14.753 6.98421 14.4893 7.56177C14.3963 7.76534 14.3674 7.98027 14.4189 8.1731L14.5039 8.49048C14.7227 9.30808 13.9748 10.0567 13.1572 9.83813L12.8398 9.75317C12.6961 9.71472 12.5399 9.72039 12.3867 9.76392L12.2158 9.81274L12.1943 9.9895C11.8698 12.7545 9.51828 14.8997 6.66602 14.8997C5.80689 14.8996 4.99273 14.7048 4.26562 14.3567C4.06714 14.2617 3.85259 14.2337 3.65918 14.2854L2.8418 14.5042C2.02431 14.7226 1.27648 13.975 1.49512 13.1575L1.71387 12.3401C1.74379 12.2282 1.74361 12.1101 1.72266 12.9915L1.96875 11.8743L1.85352 11.6331L1.73828 11.3928L1.53418 11.4895C1.25507 10.8259 1.09961 10.0976 1.09961 9.33325C1.09961 6.4767 3.25148 4.12194 6.02246 3.80298L6.16797 3.78638L6.23145 3.65552C6.97506 2.14184 8.53229 1.09985 10.333 1.09985ZM6.66602 4.23364C3.84951 4.23382 1.56641 6.51671 1.56641 9.33325C1.56641 10.0263 1.705 10.6864 1.95508 11.2883L1.74805 11.3879L1.86328 11.6282L1.97852 11.8694L2.15625 11.7834C2.21552 12.0001 2.22588 12.2325 2.16504 12.4602L1.94629 13.2776C1.82033 13.7484 2.25092 14.1799 2.72168 14.054L3.53906 13.8352C3.85781 13.7499 4.18605 13.8014 4.4668 13.9358C5.13236 14.2544 5.87808 14.4328 6.66602 14.4329C9.48267 14.4329 11.7666 12.1499 11.7666 9.33325C11.7666 6.5166 9.48267 4.23364 6.66602 4.23364ZM4.33301 8.93286C4.55392 8.93286 4.7334 9.11234 4.7334 9.33325C4.7334 9.55417 4.55392 9.73364 4.33301 9.73364C4.11209 9.73364 3.93262 9.55417 3.93262 9.33325C3.93262 9.11234 4.11209 8.93286 4.33301 8.93286ZM6.66602 8.93286C6.88693 8.93286 7.06641 9.11234 7.06641 9.33325C7.06641 9.55417 6.88693 9.73364 6.66602 9.73364C6.44525 9.73347 6.2666 9.55406 6.2666 9.33325C6.2666 9.11245 6.44525 8.93304 6.66602 8.93286ZM9 8.93286C9.22076 8.93304 9.39941 9.11245 9.39941 9.33325C9.39941 9.55406 9.22076 9.73347 9 9.73364C8.77909 9.73364 8.59961 9.55417 8.59961 9.33325C8.59961 9.11234 8.77909 8.93286 9 8.93286ZM10.333 1.56665C8.9197 1.56665 7.67257 2.28192 6.93555 3.37036L6.67969 3.74829L7.13379 3.78638C9.8848 4.01517 12.069 6.2447 12.2246 9.01587L12.2393 9.29321L12.5156 9.26685C12.6617 9.25293 12.8113 9.26228 12.96 9.302L13.2773 9.38696C13.748 9.5129 14.1794 9.08222 14.0537 8.61157L13.9688 8.29419C13.8833 7.97497 13.9368 7.64806 14.0645 7.36841C14.3011 6.8504 14.4326 6.27375 14.4326 5.66626C14.4324 3.40204 12.5973 1.56665 10.333 1.56665Z" fill="#F7F8FD" stroke="#F7F8FD" stroke-width="0.533333" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_46_18362">
                                                    <rect width="16" height="16" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($posts[4])): ?>
                        <div class="all-blogs-widget-body-center" style="background-image: url('<?php echo esc_url($posts[4]['thumbnail']); ?>');">
                            <a href="<?php echo esc_url($posts[4]['category_link']); ?>" class="all-blogs-widget-body-center-category"><?php echo esc_html($posts[4]['category']); ?></a>
                            <div class="all-blogs-widget-body-center-content">
                                <h4>
                                    <a href="<?php echo esc_url($posts[4]['permalink']); ?>">
                                        <?php echo esc_html($posts[4]['title']); ?>
                                    </a>
                                </h4>
                                <div class="underline-lamkadeh">
                                    <div class="underline-lamkadeh-line"></div>
                                    <div class="underline-lamkadeh-circle"></div>
                                </div>
                                <div class="all-blogs-widget-body-center-content-meta">
                                    <div class="all-blogs-widget-body-center-content-meta-time">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12ZM12 7.25C12.4142 7.25 12.75 7.58579 12.75 8V11.6893L15.0303 13.9697C15.3232 14.2626 15.3232 14.7374 15.0303 15.0303C14.7374 15.3232 14.2626 15.3232 13.9697 15.0303L11.4697 12.5303C11.329 12.3897 11.25 12.1989 11.25 12V8C11.25 7.58579 11.5858 7.25 12 7.25Z" fill="#F7F8FD" />
                                        </svg>
                                        <span><?php echo __('زمان مطالعه : ', 'lamkadeh') . esc_html($posts[4]['reading_time']); ?></span>
                                    </div>
                                    <div class="all-blogs-widget-body-center-content-meta-comments">
                                        <span><?php echo esc_html($posts[4]['comment_count']); ?></span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_46_18362)">
                                                <path d="M10.333 1.09985C12.855 1.09985 14.8992 3.14431 14.8994 5.66626C14.8994 6.34186 14.753 6.98421 14.4893 7.56177C14.3963 7.76534 14.3674 7.98027 14.4189 8.1731L14.5039 8.49048C14.7227 9.30808 13.9748 10.0567 13.1572 9.83813L12.8398 9.75317C12.6961 9.71472 12.5399 9.72039 12.3867 9.76392L12.2158 9.81274L12.1943 9.9895C11.8698 12.7545 9.51828 14.8997 6.66602 14.8997C5.80689 14.8996 4.99273 14.7048 4.26562 14.3567C4.06714 14.2617 3.85259 14.2337 3.65918 14.2854L2.8418 14.5042C2.02431 14.7226 1.27648 13.975 1.49512 13.1575L1.71387 12.3401C1.74379 12.2282 1.74361 12.1101 1.72266 12.9915L1.96875 11.8743L1.85352 11.6331L1.73828 11.3928L1.53418 11.4895C1.25507 10.8259 1.09961 10.0976 1.09961 9.33325C1.09961 6.4767 3.25148 4.12194 6.02246 3.80298L6.16797 3.78638L6.23145 3.65552C6.97506 2.14184 8.53229 1.09985 10.333 1.09985ZM6.66602 4.23364C3.84951 4.23382 1.56641 6.51671 1.56641 9.33325C1.56641 10.0263 1.705 10.6864 1.95508 11.2883L1.74805 11.3879L1.86328 11.6282L1.97852 11.8694L2.15625 11.7834C2.21552 12.0001 2.22588 12.2325 2.16504 12.4602L1.94629 13.2776C1.82033 13.7484 2.25092 14.1799 2.72168 14.054L3.53906 13.8352C3.85781 13.7499 4.18605 13.8014 4.4668 13.9358C5.13236 14.2544 5.87808 14.4328 6.66602 14.4329C9.48267 14.4329 11.7666 12.1499 11.7666 9.33325C11.7666 6.5166 9.48267 4.23364 6.66602 4.23364ZM4.33301 8.93286C4.55392 8.93286 4.7334 9.11234 4.7334 9.33325C4.7334 9.55417 4.55392 9.73364 4.33301 9.73364C4.11209 9.73364 3.93262 9.55417 3.93262 9.33325C3.93262 9.11234 4.11209 8.93286 4.33301 8.93286ZM6.66602 8.93286C6.88693 8.93286 7.06641 9.11234 7.06641 9.33325C7.06641 9.55417 6.88693 9.73364 6.66602 9.73364C6.44525 9.73347 6.2666 9.55406 6.2666 9.33325C6.2666 9.11245 6.44525 8.93304 6.66602 8.93286ZM9 8.93286C9.22076 8.93304 9.39941 9.11245 9.39941 9.33325C9.39941 9.55406 9.22076 9.73347 9 9.73364C8.77909 9.73364 8.59961 9.55417 8.59961 9.33325C8.59961 9.11234 8.77909 8.93286 9 8.93286ZM10.333 1.56665C8.9197 1.56665 7.67257 2.28192 6.93555 3.37036L6.67969 3.74829L7.13379 3.78638C9.8848 4.01517 12.069 6.2447 12.2246 9.01587L12.2393 9.29321L12.5156 9.26685C12.6617 9.25293 12.8113 9.26228 12.96 9.302L13.2773 9.38696C13.748 9.5129 14.1794 9.08222 14.0537 8.61157L13.9688 8.29419C13.8833 7.97497 13.9368 7.64806 14.0645 7.36841C14.3011 6.8504 14.4326 6.27375 14.4326 5.66626C14.4324 3.40204 12.5973 1.56665 10.333 1.56665Z" fill="#F7F8FD" stroke="#F7F8FD" stroke-width="0.533333" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_46_18362">
                                                    <rect width="16" height="16" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- مقالات سمت چپ (مقالات 4، 5 و 6) -->
                <div class="all-blogs-widget-body-left">
                    <?php for ($i = 3; $i < 6; $i++): ?>
                        <?php if (isset($posts[$i])): ?>
                            <a href="<?php echo esc_url($posts[$i]['permalink']); ?>" class="all-blogs-widget-body-left-item">
                                <h4><?php echo esc_html($posts[$i]['title']); ?></h4>
                                <div>
                                    <svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M20.0752 11.4905C19.9408 11.6248 19.757 11.7097 19.5449 11.7097L11.7101 11.7097L11.7101 19.5444C11.7101 19.9546 11.3707 20.294 10.9606 20.294C10.5505 20.294 10.2111 19.9546 10.2111 19.5444L10.2111 10.9602C10.2111 10.55 10.5505 10.2106 10.9606 10.2106L19.5449 10.2106C19.955 10.2106 20.2944 10.55 20.2944 10.9602C20.3015 11.1652 20.2095 11.3561 20.0752 11.4905Z" fill="#1D2977" />
                                        <path d="M23.5111 23.5114C23.2212 23.8013 22.7404 23.8013 22.4505 23.5114L10.5499 11.6108C10.2599 11.3208 10.2599 10.84 10.5499 10.5501C10.8398 10.2602 11.3206 10.2602 11.6105 10.5501L23.5111 22.4507C23.801 22.7406 23.801 23.2214 23.5111 23.5114Z" fill="#1D2977" />
                                    </svg>
                                </div>
                            </a>
                        <?php endif; ?>
                    <?php endfor; ?>
                </div>
            </div>
        </section>
    <?php
    endif;
    ?>
</main>

<style>
    @media (max-width: 768px) {
        html {
            overflow-x: hidden;
        }
    }
</style>
<?php get_footer(); ?>