<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 */

defined('ABSPATH') || exit;

get_header();
?>

<section class="container">
	<?php
	breadcrumb();
	do_action('woocommerce_before_cart');

	if (WC()->cart->is_empty()) {
		include get_template_directory() . '/woocommerce/cart/cart-empty.php';
		do_action('woocommerce_after_cart');
		get_footer();
		return;
	}
	?>
	<section class="cart-page-woocommerce-lamkadeh">
		<form class="cart-page-items" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
			<div class="cart-page-products">
				<section class="header-categories-main">
					<div class="title-header-categories-main">
						<span>SHOPPING CART</span>
						<div class="text-header-categories-main">
							<span><?php echo __("سبد <strong>خریــــــد</strong>", "lamkadeh") ?></span>
							<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g clip-path="url(#clip0_26_3865)">
									<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
									<path fill-rule="evenodd" clip-rule="evenodd" d="M42 10.2917C40.9644 10.2917 40.125 11.1311 40.125 12.1667V12.3787C40.4729 12.375 40.8485 12.375 41.2543 12.375H42.7456C43.1515 12.375 43.5271 12.375 43.875 12.3787V12.1667C43.875 11.1311 43.0355 10.2917 42 10.2917ZM45.125 12.4224V12.1667C45.125 10.4408 43.7259 9.04166 42 9.04166C40.2741 9.04166 38.875 10.4408 38.875 12.1667V12.4224C38.7625 12.4306 38.6539 12.4403 38.5491 12.4516C37.8172 12.5305 37.205 12.6957 36.6615 13.0683C36.4745 13.1964 36.2989 13.3404 36.1366 13.4986C35.6646 13.9586 35.3825 14.5264 35.1616 15.2286C34.9471 15.9105 34.7738 16.7772 34.556 17.8663L34.5401 17.9458C34.2262 19.5151 33.9789 20.7517 33.9079 21.7366C33.8353 22.743 33.9367 23.5896 34.4134 24.3233C34.5725 24.5681 34.7581 24.7945 34.9669 24.9985C35.5929 25.6098 36.4032 25.8753 37.4042 26.0015C38.384 26.125 39.6451 26.125 41.2454 26.125H42.7545C44.3549 26.125 45.616 26.125 46.5957 26.0015C47.5968 25.8753 48.4071 25.6098 49.033 24.9985C49.2418 24.7945 49.4275 24.5681 49.5865 24.3233C50.0632 23.5896 50.1647 22.743 50.0921 21.7366C50.021 20.7517 49.7737 19.5151 49.4599 17.9459L49.444 17.8663C49.2261 16.7772 49.0528 15.9105 48.8383 15.2286C48.6174 14.5264 48.3353 13.9586 47.8634 13.4986C47.701 13.3404 47.5254 13.1964 47.3385 13.0683C46.7949 12.6957 46.1828 12.5305 45.4508 12.4516C45.346 12.4403 45.2375 12.4306 45.125 12.4224ZM38.6831 13.6944C38.0608 13.7614 37.6764 13.8881 37.3682 14.0994C37.2402 14.187 37.1201 14.2855 37.009 14.3938C36.7414 14.6546 36.5418 15.0067 36.354 15.6037C36.1621 16.2138 36.0011 17.0144 35.7746 18.1468C35.45 19.7699 35.2193 20.9294 35.1546 21.8265C35.0908 22.7115 35.1986 23.2374 35.4616 23.6422C35.5704 23.8097 35.6974 23.9647 35.8403 24.1042C36.1857 24.4415 36.6803 24.6504 37.5606 24.7613C38.453 24.8738 39.6352 24.875 41.2904 24.875H42.7095C44.3648 24.875 45.547 24.8738 46.4394 24.7613C47.3196 24.6504 47.8142 24.4415 48.1596 24.1042C48.3025 23.9647 48.4295 23.8097 48.5384 23.6422C48.8014 23.2374 48.9091 22.7115 48.8453 21.8265C48.7806 20.9294 48.5499 19.7699 48.2253 18.1468C47.9988 17.0144 47.8378 16.2138 47.6459 15.6037C47.4581 15.0067 47.2585 14.6546 46.9909 14.3938C46.8799 14.2855 46.7597 14.187 46.6318 14.0994C46.3236 13.8881 45.9391 13.7614 45.3169 13.6944C44.681 13.6258 43.8644 13.625 42.7095 13.625L41.2904 13.625C40.1355 13.625 39.319 13.6258 38.6831 13.6944ZM39.4341 19.9107C39.7596 19.7957 40.1166 19.9663 40.2317 20.2917C40.4894 21.0208 41.1847 21.5417 42.0001 21.5417C42.8155 21.5417 43.5109 21.0208 43.7686 20.2917C43.8836 19.9663 44.2407 19.7957 44.5662 19.9107C44.8916 20.0257 45.0622 20.3828 44.9472 20.7083C44.5185 21.9212 43.3618 22.7917 42.0001 22.7917C40.6385 22.7917 39.4818 21.9212 39.0531 20.7083C38.9381 20.3828 39.1087 20.0257 39.4341 19.9107Z" fill="#1D2977" />
									<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
								</g>
								<defs>
									<clipPath id="clip0_26_3865">
										<rect width="64" height="64" rx="32" fill="white" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="shape-header-categories-main"></div>
					</div>
				</section>

				<section class="cart-page-items-products">

					<?php
					foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) :
						$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
						$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
						/**
						 * Filter the product name.
						 *
						 * @since 2.1.0
						 * @param string $product_name Name of the product in the cart.
						 * @param array $cart_item The product in the cart.
						 * @param string $cart_item_key Key for the product in the cart.
						 */
						$product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
					?>
						<?php do_action('woocommerce_cart_contents'); ?>
						<?php do_action('woocommerce_after_cart_contents'); ?>
						<div class="cart-page-item-product">
							<a href="#" class="cart-page-item-product-images">
								<?php echo $_product->get_image('woocommerce_thumbnail'); ?>
								<div class="cart-page-item-product-images-circle-one"></div>
								<div class="cart-page-item-product-images-circle-two"></div>
								<div class="cart-page-item-product-images-circle-three"></div>
							</a>
							<div class="cart-page-item-product-content">
								<div class="cart-page-item-product-content-item">
									<span class="name-product"><?php echo __("نام  محصول", "lamakdeh") ?></span>
									<a href="#" target="_blank" class="name-product-content">
										<?php echo esc_html($_product->get_name()); ?>
									</a>
								</div>
								<div class="cart-page-item-product-content-item">
									<span class="name-product"><?php echo __("قیمت جزء", "lamakdeh") ?></span>
									<div class="cart-price-amount-fee">
										<?php
										$raw_price = $_product->get_price();

										$formatted_price = wc_price($raw_price);
										$formatted_price_plain = wp_strip_all_tags($formatted_price);

										$currency_symbol = get_woocommerce_currency_symbol();

										$only_number = trim(str_replace($currency_symbol, '', $formatted_price_plain));
										?>
										<div class="cart-price-amount-fee-shape"></div>
										<span class="price-amount-fee"><?php echo esc_html($only_number); ?></span>
										<span class="price-amount-fee-symbol"><?php echo esc_html($currency_symbol); ?></span>
									</div>
								</div>
								<div class="cart-page-item-product-content-item">
									<span class="name-product"><?php echo __("تعداد", "lamakdeh") ?></span>
									<div class="cart-counter-product">
										<?php
										if ($_product->is_sold_individually()) {
											$min_quantity = 1;
											$max_quantity = 1;
										} else {
											$min_quantity = 0;
											$max_quantity = $_product->get_max_purchase_quantity();
										}

										$input_name   = "cart[{$cart_item_key}][qty]";
										$input_value  = $cart_item['quantity'];
										$product_name = $_product->get_name();

										?>
										<div class="cart-counter-product" data-product-id="<?php echo esc_attr($_product->get_id()); ?>">
											<button type="button" class="cart-counter-plus">+</button>
											<input
												class="number-input-cart"
												name="<?php echo esc_attr($input_name); ?>"
												value="<?php echo esc_attr($input_value); ?>"
												data-product_name="<?php echo esc_attr($product_name); ?>"
												min="<?php echo esc_attr($min_quantity); ?>"
												max="<?php echo esc_attr($max_quantity); ?>"
												type="text"
												inputmode="numeric">
											<button type="button" class="cart-counter-mines">-</button>
										</div>
									</div>
								</div>
								<div class="cart-page-item-product-content-item">
									<span class="name-product"><?php echo __("قیمت کل", "lamakdeh") ?></span>
									<?php
									$subtotal_html = WC()->cart->get_product_subtotal($_product, $cart_item['quantity']);

									$subtotal_plain = wp_strip_all_tags($subtotal_html);

									$currency_symbol = get_woocommerce_currency_symbol();

									$only_number_subtotal = trim(str_replace($currency_symbol, '', $subtotal_plain));
									?>

									<div class="cart-price-amount-fee">
										<div class="cart-price-amount-fee-shape"></div>
										<span class="price-amount-fee"><?php echo esc_html($only_number_subtotal); ?></span>
										<span class="price-amount-fee-symbol"><?php echo esc_html($currency_symbol); ?></span>
									</div>

								</div>
								<div class="cart-page-item-product-content-item">
									<?php
									echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
										'woocommerce_cart_item_remove_link',
										sprintf(
											'<a role="button" href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M17.6575 17.657L12.0006 12.0001M12.0006 12.0001L6.34375 6.34326M12.0006 12.0001L17.6575 6.34326M12.0006 12.0001L6.34375 17.657" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" /></svg></a>',
											esc_url(wc_get_cart_remove_url($cart_item_key)),
											/* translators: %s is the product name */
											esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
											esc_attr($product_id),
											esc_attr($_product->get_sku())
										),
										$cart_item_key
									);
									?>
								</div>
							</div>
						</div>
					<?php do_action('woocommerce_after_cart_contents');
					endforeach;
					?>
					<button type="submit" class="button-update-cart" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>">
						<?php esc_html_e('بروزرسانی سبد خرید', 'woocommerce'); ?>
					</button>

					<?php do_action('woocommerce_cart_actions'); ?>

					<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
				</section>

			</div>
			<?php if (wc_coupons_enabled()) :
				$applied_coupons = WC()->cart->get_applied_coupons();
				$current_coupon  = !empty($applied_coupons) ? $applied_coupons[0] : '';
			?>
				<div class="cart-page-discount-code">
					<section class="header-categories-main">
						<div class="title-header-categories-main">
							<span>OFF</span>
							<div class="text-header-categories-main">
								<span><?php echo __("کـــد <strong>تخفیف</strong>", "lamkadeh") ?></span>
								<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
									<g clip-path="url(#clip0_33_2648)">
										<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
										<path fill-rule="evenodd" clip-rule="evenodd" d="M40.8273 9.93238C41.5685 9.57812 42.4302 9.57812 43.1713 9.93238C43.4933 10.0863 43.7884 10.3379 44.1969 10.6864C44.2181 10.7045 44.2396 10.7228 44.2615 10.7415C44.4599 10.9105 44.5224 10.9625 44.5856 11.0049C44.7464 11.1127 44.927 11.1875 45.1169 11.225C45.1916 11.2397 45.2725 11.2471 45.5324 11.2679C45.561 11.2702 45.5891 11.2724 45.6169 11.2746C46.1522 11.3171 46.5388 11.3477 46.8753 11.4666C47.6499 11.7402 48.2592 12.3495 48.5328 13.1241C48.6516 13.4606 48.6823 13.8472 48.7248 14.3824C48.727 14.4102 48.7292 14.4384 48.7315 14.467C48.7522 14.7269 48.7597 14.8078 48.7744 14.8825C48.8119 15.0724 48.8867 15.253 48.9945 15.4138C49.0368 15.477 49.0888 15.5395 49.2579 15.7379C49.2765 15.7597 49.2949 15.7813 49.313 15.8025C49.6614 16.211 49.9131 16.506 50.067 16.828C50.4212 17.5692 50.4212 18.4308 50.067 19.172C49.9131 19.494 49.6614 19.789 49.313 20.1976C49.2949 20.2188 49.2765 20.2403 49.2579 20.2621C49.0888 20.4605 49.0368 20.523 48.9945 20.5863C48.8867 20.7471 48.8119 20.9277 48.7744 21.1176C48.7597 21.1922 48.7522 21.2732 48.7315 21.533C48.7292 21.5616 48.727 21.5898 48.7248 21.6176C48.6823 22.1529 48.6516 22.5395 48.5328 22.876C48.2592 23.6506 47.6499 24.2598 46.8753 24.5334C46.5388 24.6523 46.1522 24.683 45.6169 24.7254C45.5891 24.7276 45.561 24.7299 45.5324 24.7322C45.2725 24.7529 45.1916 24.7603 45.1169 24.7751C44.927 24.8126 44.7464 24.8874 44.5856 24.9951C44.5224 25.0375 44.4599 25.0895 44.2615 25.2586C44.2396 25.2772 44.2181 25.2955 44.1969 25.3136C43.7884 25.6621 43.4933 25.9138 43.1713 26.0677C42.4302 26.4219 41.5685 26.4219 40.8273 26.0677C40.5054 25.9138 40.2103 25.6621 39.8018 25.3136C39.7806 25.2955 39.7591 25.2772 39.7372 25.2586C39.5388 25.0895 39.4763 25.0375 39.4131 24.9951C39.2523 24.8874 39.0717 24.8126 38.8818 24.7751C38.8071 24.7603 38.7262 24.7529 38.4663 24.7322C38.4377 24.7299 38.4096 24.7276 38.3818 24.7254C37.8465 24.683 37.4599 24.6523 37.1234 24.5334C36.3488 24.2598 35.7395 23.6506 35.4659 22.876C35.3471 22.5395 35.3164 22.1529 35.2739 21.6176C35.2717 21.5898 35.2695 21.5616 35.2672 21.533C35.2465 21.2732 35.239 21.1922 35.2243 21.1176C35.1868 20.9277 35.112 20.7471 35.0042 20.5863C34.9619 20.523 34.9099 20.4606 34.7408 20.2621C34.7222 20.2403 34.7038 20.2188 34.6857 20.1976C34.3373 19.7891 34.0856 19.494 33.9317 19.172C33.5775 18.4308 33.5775 17.5692 33.9317 16.828C34.0856 16.506 34.3373 16.211 34.6857 15.8024C34.7038 15.7812 34.7222 15.7597 34.7408 15.7379C34.9099 15.5395 34.9619 15.477 35.0042 15.4138C35.112 15.253 35.1868 15.0724 35.2243 14.8825C35.239 14.8078 35.2465 14.7269 35.2672 14.467C35.2695 14.4384 35.2717 14.4102 35.2739 14.3824C35.3164 13.8472 35.3471 13.4606 35.4659 13.1241C35.7395 12.3495 36.3488 11.7402 37.1234 11.4666C37.4599 11.3477 37.8465 11.3171 38.3818 11.2746C38.4096 11.2724 38.4377 11.2702 38.4663 11.2679C38.7262 11.2471 38.8071 11.2397 38.8818 11.225C39.0717 11.1875 39.2523 11.1127 39.4131 11.0049C39.4763 10.9625 39.5388 10.9105 39.7372 10.7415C39.7591 10.7228 39.7806 10.7045 39.8018 10.6864C40.2103 10.3379 40.5054 10.0863 40.8273 9.93238ZM42.6304 11.0641C42.2313 10.8733 41.7674 10.8733 41.3683 11.0641C41.214 11.1378 41.0513 11.2696 40.5508 11.6962C40.5426 11.7032 40.5345 11.7101 40.5265 11.7169C40.3622 11.8569 40.2423 11.9592 40.1115 12.0469C39.8128 12.247 39.4775 12.3859 39.1247 12.4556C38.9702 12.4861 38.8132 12.4986 38.598 12.5157C38.5875 12.5165 38.5769 12.5174 38.5661 12.5182C37.9106 12.5706 37.7024 12.5924 37.5412 12.6493C37.1241 12.7967 36.796 13.1247 36.6487 13.5418C36.5917 13.7031 36.5699 13.9113 36.5176 14.5668C36.5167 14.5776 36.5159 14.5882 36.515 14.5987C36.4979 14.8138 36.4854 14.9709 36.4549 15.1254C36.3853 15.4781 36.2463 15.8135 36.0462 16.1122C35.9585 16.243 35.8563 16.3629 35.7162 16.5272C35.7094 16.5352 35.7025 16.5433 35.6955 16.5515C35.2689 17.052 35.1372 17.2146 35.0634 17.3689C34.8727 17.768 34.8727 18.232 35.0634 18.6311C35.1372 18.7854 35.2689 18.948 35.6955 19.4486C35.7025 19.4568 35.7094 19.4649 35.7162 19.4729C35.8563 19.6372 35.9585 19.7571 36.0462 19.8879C36.2463 20.1865 36.3853 20.5219 36.4549 20.8746C36.4854 21.0291 36.4979 21.1862 36.515 21.4014C36.5159 21.4119 36.5167 21.4225 36.5176 21.4333C36.5699 22.0888 36.5917 22.297 36.6487 22.4582C36.796 22.8753 37.1241 23.2034 37.5411 23.3507C37.7024 23.4077 37.9106 23.4295 38.5661 23.4818L38.598 23.4843C38.8132 23.5015 38.9702 23.514 39.1247 23.5445C39.4775 23.6141 39.8128 23.753 40.1115 23.9532C40.2423 24.0409 40.3622 24.1431 40.5265 24.2831L40.5508 24.3039C41.0513 24.7304 41.214 24.8622 41.3683 24.9359C41.7674 25.1267 42.2313 25.1267 42.6304 24.9359C42.7847 24.8622 42.9474 24.7304 43.4479 24.3039L43.4722 24.2831C43.6365 24.1431 43.7564 24.0409 43.8872 23.9532C44.1859 23.753 44.5212 23.6141 44.8739 23.5445C45.0285 23.514 45.1855 23.5015 45.4007 23.4843L45.4326 23.4818C46.0881 23.4295 46.2963 23.4077 46.4575 23.3507C46.8746 23.2034 47.2027 22.8753 47.35 22.4582C47.407 22.297 47.4288 22.0888 47.4811 21.4333L47.4837 21.4014C47.5008 21.1862 47.5133 21.0291 47.5438 20.8746C47.6134 20.5219 47.7524 20.1865 47.9525 19.8879C48.0402 19.7571 48.1424 19.6372 48.2825 19.4729L48.3032 19.4486C48.7298 18.948 48.8615 18.7854 48.9353 18.6311C49.126 18.232 49.126 17.768 48.9353 17.3689C48.8615 17.2146 48.7298 17.052 48.3032 16.5515L48.2824 16.5271C48.1424 16.3629 48.0402 16.243 47.9525 16.1122C47.7524 15.8135 47.6134 15.4781 47.5438 15.1254C47.5133 14.9709 47.5008 14.8138 47.4837 14.5987L47.4811 14.5668C47.4288 13.9113 47.407 13.7031 47.35 13.5418C47.2027 13.1247 46.8746 12.7967 46.4575 12.6493C46.2963 12.5924 46.0881 12.5706 45.4326 12.5182C45.4218 12.5174 45.4112 12.5165 45.4007 12.5157C45.1855 12.4986 45.0285 12.4861 44.8739 12.4556C44.5212 12.3859 44.1859 12.247 43.8872 12.0469C43.7564 11.9592 43.6365 11.8569 43.4722 11.7169C43.4642 11.7101 43.4561 11.7032 43.4479 11.6962C42.9474 11.2696 42.7847 11.1378 42.6304 11.0641Z" fill="#1D2977" />
										<path fill-rule="evenodd" clip-rule="evenodd" d="M44.9515 15.0478C45.1964 15.2928 45.1964 15.6899 44.9515 15.9348L39.9341 20.9522C39.6892 21.1971 39.2921 21.1971 39.0472 20.9522C38.8022 20.7073 38.8022 20.3102 39.0472 20.0652L44.0646 15.0478C44.3095 14.8029 44.7066 14.8029 44.9515 15.0478Z" fill="#1D2977" />
										<path d="M44.9262 20.0906C44.9262 20.5524 44.5518 20.9268 44.0899 20.9268C43.6281 20.9268 43.2537 20.5524 43.2537 20.0906C43.2537 19.6288 43.6281 19.2544 44.0899 19.2544C44.5518 19.2544 44.9262 19.6288 44.9262 20.0906Z" fill="#1D2977" />
										<path d="M40.745 15.9094C40.745 16.3713 40.3706 16.7457 39.9088 16.7457C39.4469 16.7457 39.0725 16.3713 39.0725 15.9094C39.0725 15.4476 39.4469 15.0732 39.9088 15.0732C40.3706 15.0732 40.745 15.4476 40.745 15.9094Z" fill="#1D2977" />
										<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
									</g>
									<defs>
										<clipPath id="clip0_33_2648">
											<rect width="64" height="64" rx="32" fill="white" />
										</clipPath>
									</defs>
								</svg>
							</div>
							<div class="shape-header-categories-main"></div>
						</div>
					</section>
					<div class="coupon">
						<span><?php echo __("کد تخفیف خود را وارد کنید:", "lamkadeh") ?></span>
						<label for="coupon_code" class="screen-reader-text"><?php esc_html_e('Coupon:', 'woocommerce'); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="<?php echo esc_attr($current_coupon); ?>" placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>" /> <button type="submit" class="button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'woocommerce'); ?></button>
						<?php do_action('woocommerce_cart_coupon'); ?>
					</div>
				</div>
			<?php endif; ?>
		</form>
		<div class="cart-page-peyments">
			<?php
			/**
			 * Cart collaterals hook.
			 *
			 * @hooked woocommerce_cross_sell_display
			 * @hooked woocommerce_cart_totals - 10
			 */
			do_action('woocommerce_cart_collaterals');
			?>
		</div>
	</section>
</section>

<?php
do_action('woocommerce_after_cart');
get_footer();
