<?php

/**
 * Proceed to checkout button
 *
 * Contains the markup for the proceed to checkout button on the cart.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/proceed-to-checkout-button.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>

<a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="proceed-to-checkout">
	<div>
		<?php esc_html_e('ثبت سفارش', 'lamkadeh'); ?>
	</div>
	<div>
		<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M23.4214 13.4056C23.2646 13.5623 23.0502 13.6613 22.8027 13.6613L13.6621 13.6613L13.6621 22.8019C13.6621 23.2803 13.2662 23.6763 12.7877 23.6763C12.3092 23.6763 11.9132 23.2803 11.9132 22.8019L11.9132 12.7869C11.9132 12.3084 12.3092 11.9124 12.7877 11.9124L22.8027 11.9124C23.2811 11.9124 23.6771 12.3084 23.6771 12.7869C23.6854 13.0261 23.5781 13.2489 23.4214 13.4056Z" fill="white" />
			<path d="M27.4296 27.4299C27.0914 27.7681 26.5304 27.7681 26.1922 27.4299L12.3082 13.5458C11.9699 13.2076 11.9699 12.6466 12.3082 12.3084C12.6464 11.9702 13.2074 11.9702 13.5456 12.3084L27.4296 26.1924C27.7679 26.5307 27.7679 27.0917 27.4296 27.4299Z" fill="white" />
		</svg>
	</div>
</a>