<?php

/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if (! defined('ABSPATH')) {
	exit;
}
$current_user = wp_get_current_user();
do_action('woocommerce_before_account_navigation');
?>

<section class="navigation-woocommerce-lamkadeh">
	<section class="navigation-woocommerce-lamkadeh-header">
		<div class="navigation-woocommerce-lamkadeh-header-profile">
			<?php
			$roles = $current_user->roles;
			$role_name = !empty($roles) ? translate_user_role(ucfirst($roles[0])) : __("بدون نقش", "lamkadeh");
			echo '<span>' . esc_html($role_name) . '</span>';
			?>
			<div class="navigation-woocommerce-lamkadeh-header-profile-image">
				<?php echo get_avatar($current_user->ID, 64); ?>
			</div>
			<div class="navigation-woocommerce-lamkadeh-header-profile-name"><span><?php echo $current_user->display_name ?></span></div>
			<div class="navigation-woocommerce-lamkadeh-header-profile-shape-one"></div>
			<div class="navigation-woocommerce-lamkadeh-header-profile-shape-two"></div>
			<div class="navigation-woocommerce-lamkadeh-header-profile-shape-three"></div>
		</div>
	</section>
	<section class="navigation-woocommerce-lamkadeh-bottom">
		<?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
			<a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>" class="<?php echo wc_get_account_menu_item_classes($endpoint); ?> <?php echo wc_is_current_account_menu_item($endpoint) ? 'active' : ''; ?>">
				<div>
					<?php
					switch ($endpoint) {
						case "dashboard":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 6.21053C2 4.22567 2 3.23323 2.65901 2.61662C3.31802 2 4.37868 2 6.5 2C8.62132 2 9.68198 2 10.341 2.61662C11 3.23323 11 4.22567 11 6.21053V17.7895C11 19.7743 11 20.7668 10.341 21.3834C9.68198 22 8.62132 22 6.5 22C4.37868 22 3.31802 22 2.65901 21.3834C2 20.7668 2 19.7743 2 17.7895V6.21053Z" fill="#1D2977"/><path d="M13 15.4C13 13.3258 13 12.2887 13.659 11.6444C14.318 11 15.3787 11 17.5 11C19.6213 11 20.682 11 21.341 11.6444C22 12.2887 22 13.3258 22 15.4V17.6C22 19.6742 22 20.7113 21.341 21.3556C20.682 22 19.6213 22 17.5 22C15.3787 22 14.318 22 13.659 21.3556C13 20.7113 13 19.6742 13 17.6V15.4Z" fill="#1D2977"/><path d="M13 5.5C13 4.4128 13 3.8692 13.1713 3.44041C13.3996 2.86867 13.8376 2.41443 14.389 2.17761C14.8024 2 15.3266 2 16.375 2H18.625C19.6734 2 20.1976 2 20.611 2.17761C21.1624 2.41443 21.6004 2.86867 21.8287 3.44041C22 3.8692 22 4.4128 22 5.5C22 6.5872 22 7.1308 21.8287 7.55959C21.6004 8.13133 21.1624 8.58557 20.611 8.82239C20.1976 9 19.6734 9 18.625 9H16.375C15.3266 9 14.8024 9 14.389 8.82239C13.8376 8.58557 13.3996 8.13133 13.1713 7.55959C13 7.1308 13 6.5872 13 5.5Z" fill="#1D2977"/></svg>';
							break;
						case "orders":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.3116 12.6473L20.8293 10.7154C21.4335 8.46034 21.7356 7.3328 21.5081 6.35703C21.3285 5.58657 20.9244 4.88668 20.347 4.34587C19.6157 3.66095 18.4881 3.35883 16.2331 2.75458C13.978 2.15033 12.8504 1.84821 11.8747 2.07573C11.1042 2.25537 10.4043 2.65945 9.86351 3.23687C9.27709 3.86298 8.97128 4.77957 8.51621 6.44561C8.43979 6.7254 8.35915 7.02633 8.27227 7.35057L8.27222 7.35077L7.75458 9.28263C7.15033 11.5377 6.84821 12.6652 7.07573 13.641C7.25537 14.4115 7.65945 15.1114 8.23687 15.6522C8.96815 16.3371 10.0957 16.6392 12.3508 17.2435L12.3508 17.2435C14.3834 17.7881 15.4999 18.0873 16.415 17.9744C16.5152 17.9621 16.6129 17.9448 16.7092 17.9223C17.4796 17.7427 18.1795 17.3386 18.7203 16.7612C19.4052 16.0299 19.7074 14.9024 20.3116 12.6473Z" stroke="#1D2977" stroke-width="1.5"/><path d="M16.415 17.9741C16.2065 18.6126 15.8399 19.1902 15.347 19.6519C14.6157 20.3368 13.4881 20.6389 11.2331 21.2432C8.97798 21.8474 7.85044 22.1495 6.87466 21.922C6.10421 21.7424 5.40432 21.3383 4.86351 20.7609C4.17859 20.0296 3.87647 18.9021 3.27222 16.647L2.75458 14.7151C2.15033 12.46 1.84821 11.3325 2.07573 10.3567C2.25537 9.58627 2.65945 8.88638 3.23687 8.34557C3.96815 7.66065 5.09569 7.35853 7.35077 6.75428C7.77741 6.63996 8.16368 6.53646 8.51621 6.44531" stroke="#1D2977" stroke-width="1.5"/><path d="M11.7773 10L16.607 11.2941" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round"/><path d="M11 12.8977L13.8978 13.6742" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round"/></svg>';
							break;
						case "news":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.9426 1.25C9.63423 1.24999 7.82519 1.24998 6.41371 1.43975C4.96897 1.63399 3.82895 2.03933 2.93414 2.93414C2.03933 3.82895 1.63399 4.96897 1.43975 6.41371C1.24998 7.82519 1.24999 9.63423 1.25 11.9426V12.0574C1.24999 14.3658 1.24998 16.1748 1.43975 17.5863C1.63399 19.031 2.03933 20.1711 2.93414 21.0659C3.82895 21.9607 4.96897 22.366 6.41371 22.5603C7.82519 22.75 9.63423 22.75 11.9426 22.75H12.0574C14.3658 22.75 16.1748 22.75 17.5863 22.5603C19.031 22.366 20.1711 21.9607 21.0659 21.0659C21.9607 20.1711 22.366 19.031 22.5603 17.5863C22.75 16.1748 22.75 14.3658 22.75 12.0574V10.5C22.75 10.0858 22.4142 9.75 22 9.75C21.5858 9.75 21.25 10.0858 21.25 10.5V12C21.25 14.3782 21.2484 16.0864 21.0736 17.3864C20.9018 18.6648 20.5749 19.4355 20.0052 20.0052C19.4355 20.5749 18.6648 20.9018 17.3864 21.0736C16.0864 21.2484 14.3782 21.25 12 21.25C9.62178 21.25 7.91356 21.2484 6.61358 21.0736C5.33517 20.9018 4.56445 20.5749 3.9948 20.0052C3.42514 19.4355 3.09825 18.6648 2.92637 17.3864C2.75159 16.0864 2.75 14.3782 2.75 12C2.75 9.62178 2.75159 7.91356 2.92637 6.61358C3.09825 5.33517 3.42514 4.56445 3.9948 3.9948C4.56445 3.42514 5.33517 3.09825 6.61358 2.92637C7.91356 2.75159 9.62178 2.75 12 2.75H13.5C13.9142 2.75 14.25 2.41421 14.25 2C14.25 1.58579 13.9142 1.25 13.5 1.25H11.9426Z" fill="#1D2977"/><path fill-rule="evenodd" clip-rule="evenodd" d="M19 1.25C16.9289 1.25 15.25 2.92893 15.25 5C15.25 7.07107 16.9289 8.75 19 8.75C21.0711 8.75 22.75 7.07107 22.75 5C22.75 2.92893 21.0711 1.25 19 1.25ZM16.75 5C16.75 3.75736 17.7574 2.75 19 2.75C20.2426 2.75 21.25 3.75736 21.25 5C21.25 6.24264 20.2426 7.25 19 7.25C17.7574 7.25 16.75 6.24264 16.75 5Z" fill="#1D2977"/><path d="M6.25 14C6.25 13.5858 6.58579 13.25 7 13.25H16C16.4142 13.25 16.75 13.5858 16.75 14C16.75 14.4142 16.4142 14.75 16 14.75H7C6.58579 14.75 6.25 14.4142 6.25 14Z" fill="#1D2977"/><path d="M7 16.75C6.58579 16.75 6.25 17.0858 6.25 17.5C6.25 17.9142 6.58579 18.25 7 18.25H13C13.4142 18.25 13.75 17.9142 13.75 17.5C13.75 17.0858 13.4142 16.75 13 16.75H7Z" fill="#1D2977"/></svg>';
							break;
						case "downloads":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 7L12 14M12 14L15 11M12 14L9 11" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M16 17H12H8" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round"/><path d="M2 12C2 7.28595 2 4.92893 3.46447 3.46447C4.92893 2 7.28595 2 12 2C16.714 2 19.0711 2 20.5355 3.46447C22 4.92893 22 7.28595 22 12C22 16.714 22 19.0711 20.5355 20.5355C19.0711 22 16.714 22 12 22C7.28595 22 4.92893 22 3.46447 20.5355C2 19.0711 2 16.714 2 12Z" stroke="#1D2977" stroke-width="1.5"/></svg>';
							break;
						case "edit-address":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.3864 2.92637C16.0864 2.75159 14.3782 2.75 12 2.75C9.62177 2.75 7.91356 2.75159 6.61358 2.92637C5.33517 3.09825 4.56445 3.42514 3.9948 3.9948C3.42514 4.56445 3.09825 5.33517 2.92637 6.61358C2.75159 7.91356 2.75 9.62177 2.75 12C2.75 14.3782 2.75159 16.0864 2.92637 17.3864C3.09825 18.6648 3.42514 19.4355 3.9948 20.0052C4.46242 20.4728 5.06554 20.7769 5.97376 20.9659L20.9659 5.97376C20.7769 5.06554 20.4728 4.46242 20.0052 3.9948C19.4355 3.42514 18.6648 3.09825 17.3864 2.92637ZM21.1873 7.87364L15.0611 13.9998L20.4683 19.4071C20.763 18.9078 20.9551 18.2678 21.0736 17.3864C21.2484 16.0864 21.25 14.3782 21.25 12C21.25 10.3215 21.2492 8.97669 21.1873 7.87364ZM19.4078 20.4679L14.0004 15.0605L7.87364 21.1873C8.97669 21.2492 10.3215 21.25 12 21.25C14.3782 21.25 16.0864 21.2484 17.3864 21.0736C18.2682 20.9551 18.9085 20.7628 19.4078 20.4679ZM17.5863 1.43975C19.031 1.63399 20.1711 2.03933 21.0659 2.93414C21.9607 3.82895 22.366 4.96897 22.5603 6.41371C22.75 7.82519 22.75 9.63423 22.75 11.9426V12.0574C22.75 14.3658 22.75 16.1748 22.5603 17.5863C22.366 19.031 21.9607 20.1711 21.0659 21.0659C20.1711 21.9607 19.031 22.366 17.5863 22.5603C16.1748 22.75 14.3658 22.75 12.0574 22.75H11.9426C9.63423 22.75 7.82519 22.75 6.41371 22.5603C4.96897 22.366 3.82895 21.9607 2.93414 21.0659C2.03933 20.1711 1.63399 19.031 1.43975 17.5863C1.24998 16.1748 1.24999 14.3658 1.25 12.0574V11.9426C1.24999 9.63423 1.24998 7.82519 1.43975 6.41371C1.63399 4.96897 2.03933 3.82895 2.93414 2.93414C3.82895 2.03933 4.96897 1.63399 6.41371 1.43975C7.82519 1.24998 9.63423 1.24999 11.9426 1.25H12.0574C14.3658 1.24999 16.1748 1.24998 17.5863 1.43975ZM4.75 8.75722C4.75 6.49419 6.70446 4.7499 9 4.7499C11.2955 4.7499 13.25 6.49419 13.25 8.75722C13.25 10.7835 12.0042 13.175 9.93476 14.0593C9.34021 14.3134 8.65979 14.3134 8.06524 14.0593C5.99581 13.175 4.75 10.7835 4.75 8.75722ZM9 6.2499C7.42955 6.2499 6.25 7.42231 6.25 8.75722C6.25 10.3007 7.23835 12.0747 8.65469 12.68C8.87274 12.7732 9.12726 12.7732 9.34531 12.68C10.7617 12.0747 11.75 10.3007 11.75 8.75722C11.75 7.42231 10.5705 6.2499 9 6.2499Z" fill="#1D2977"/><path d="M10 9C10 9.55229 9.55229 10 9 10C8.44772 10 8 9.55229 8 9C8 8.44772 8.44772 8 9 8C9.55229 8 10 8.44772 10 9Z" fill="#1D2977"/></svg>';
							break;
						case "wishlist":
							echo '<svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.21827 3.31832C2.97403 3.88707 2.0625 5.23985 2.0625 6.853C2.0625 8.50105 2.73691 9.77135 3.70371 10.86C4.50054 11.7573 5.46513 12.5009 6.40584 13.2261C6.62928 13.3984 6.85136 13.5696 7.06953 13.7416C7.46406 14.0526 7.81599 14.3256 8.15521 14.5238C8.49461 14.7221 8.7678 14.8127 9 14.8127C9.2322 14.8127 9.50539 14.7221 9.84479 14.5238C10.184 14.3256 10.5359 14.0526 10.9305 13.7416C11.1486 13.5696 11.3707 13.3984 11.5942 13.2261C12.5349 12.5009 13.4995 11.7573 14.2963 10.86C15.2631 9.77135 15.9375 8.50105 15.9375 6.853C15.9375 5.23985 15.026 3.88707 13.7817 3.31832C12.5729 2.76578 10.9488 2.91211 9.40527 4.51573C9.29923 4.6259 9.15291 4.68815 9 4.68815C8.84709 4.68815 8.70077 4.6259 8.59473 4.51573C7.05125 2.91211 5.42705 2.76578 4.21827 3.31832ZM9 3.34429C7.26596 1.79286 5.32422 1.57583 3.75057 2.29515C2.08853 3.05487 0.9375 4.81895 0.9375 6.853C0.9375 8.85215 1.77037 10.3772 2.86254 11.607C3.73715 12.5919 4.80767 13.4161 5.75312 14.1441C5.96744 14.3091 6.17533 14.4692 6.37306 14.6251C6.75724 14.9279 7.16966 15.2509 7.58762 15.4951C8.00539 15.7392 8.4822 15.9377 9 15.9377C9.5178 15.9377 9.99461 15.7392 10.4124 15.4951C10.8303 15.2509 11.2428 14.9279 11.6269 14.6251C11.8247 14.4692 12.0326 14.3091 12.2469 14.1441C13.1923 13.4161 14.2628 12.5919 15.1375 11.607C16.2296 10.3772 17.0625 8.85215 17.0625 6.853C17.0625 4.81895 15.9115 3.05487 14.2494 2.29515C12.6758 1.57583 10.734 1.79286 9 3.34429Z" fill="#1D2977"/></svg>';
							break;
						case "edit-account":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="6" r="4" stroke="#1D2977" stroke-width="1.5"/><path d="M20 17.5C20 19.9853 20 22 12 22C4 22 4 19.9853 4 17.5C4 15.0147 7.58172 13 12 13C16.4183 13 20 15.0147 20 17.5Z" stroke="#1D2977" stroke-width="1.5"/></svg>';
							break;
						case "tickets":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.98899 5.30778C10.169 2.90545 12.6404 1.25 15.5 1.25C19.5041 1.25 22.75 4.49594 22.75 8.5C22.75 9.57209 22.5168 10.5918 22.0977 11.5093C21.9883 11.7488 21.967 11.975 22.0156 12.1568L22.143 12.6328C22.5507 14.1566 21.1566 15.5507 19.6328 15.143L19.1568 15.0156C19.0215 14.9794 18.8616 14.982 18.6899 15.0307C18.1798 19.3775 14.4838 22.75 10 22.75C8.65003 22.75 7.36949 22.4438 6.2259 21.8963C5.99951 21.7879 5.7766 21.7659 5.59324 21.815L4.3672 22.143C2.84337 22.5507 1.44927 21.1566 1.857 19.6328L2.18504 18.4068C2.2341 18.2234 2.21211 18.0005 2.10373 17.7741C1.55623 16.6305 1.25 15.35 1.25 14C1.25 9.50945 4.63273 5.80897 8.98899 5.30778ZM10.735 5.28043C15.0598 5.64011 18.4914 9.14511 18.736 13.5016C18.9986 13.4766 19.2714 13.4935 19.5445 13.5666L20.0205 13.694C20.4293 13.8034 20.8034 13.4293 20.694 13.0205L20.5666 12.5445C20.4095 11.9571 20.5119 11.3708 20.7333 10.8861C21.0649 10.1602 21.25 9.35275 21.25 8.5C21.25 5.32436 18.6756 2.75 15.5 2.75C13.5181 2.75 11.7692 3.75284 10.735 5.28043ZM10 6.75C5.99594 6.75 2.75 9.99594 2.75 14C2.75 15.121 3.00392 16.1807 3.45667 17.1264C3.69207 17.6181 3.79079 18.2087 3.63407 18.7945L3.30602 20.0205C3.19664 20.4293 3.57066 20.8034 3.97949 20.694L5.20553 20.3659C5.79126 20.2092 6.38191 20.3079 6.87362 20.5433C7.81932 20.9961 8.87896 21.25 10 21.25C14.0041 21.25 17.25 18.0041 17.25 14C17.25 9.99594 14.0041 6.75 10 6.75Z" fill="#1D2977"/><path d="M7.5 14C7.5 14.5523 7.05228 15 6.5 15C5.94772 15 5.5 14.5523 5.5 14C5.5 13.4477 5.94772 13 6.5 13C7.05228 13 7.5 13.4477 7.5 14Z" fill="#1D2977"/><path d="M11 14C11 14.5523 10.5523 15 10 15C9.44772 15 9 14.5523 9 14C9 13.4477 9.44772 13 10 13C10.5523 13 11 13.4477 11 14Z" fill="#1D2977"/><path d="M14.5 14C14.5 14.5523 14.0523 15 13.5 15C12.9477 15 12.5 14.5523 12.5 14C12.5 13.4477 12.9477 13 13.5 13C14.0523 13 14.5 13.4477 14.5 14Z" fill="#1D2977"/></svg>';
							break;
						case "customer-logout":
							echo '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6 3C4.34315 3 3 4.34315 3 6V18C3 19.6569 4.34315 21 6 21H17C17.5523 21 18 20.5523 18 20C18 19.4477 17.5523 19 17 19H6C5.44772 19 5 18.5523 5 18V6C5 5.44772 5.44772 5 6 5H17C17.5523 5 18 4.55228 18 4C18 3.44772 17.5523 3 17 3H6ZM15.7071 7.29289C15.3166 6.90237 14.6834 6.90237 14.2929 7.29289C13.9024 7.68342 13.9024 8.31658 14.2929 8.70711L16.5858 11H8C7.44772 11 7 11.4477 7 12C7 12.5523 7.44772 13 8 13H16.5858L14.2929 15.2929C13.9024 15.6834 13.9024 16.3166 14.2929 16.7071C14.6834 17.0976 15.3166 17.0976 15.7071 16.7071L19.7071 12.7071C20.0976 12.3166 20.0976 11.6834 19.7071 11.2929L15.7071 7.29289Z" fill="#1D2977" /></svg>';
							break;
					}
					?>
					<span>
						<?php echo esc_html($label); ?>
					</span>
				</div>
				<svg class="navigation-woocommerce-lamkadeh-bottom-svg" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M20 12H4M4 12L10 6M4 12L10 18" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
				</svg>
			</a>
		<?php
		endforeach;
		?>
	</section>
</section>

<?php do_action('woocommerce_after_account_navigation'); ?>