<?php

/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.5.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_account_orders', $has_orders); ?>

<section class="header-categories-main">
	<div class="title-header-categories-main">
		<span>ORDERS</span>
		<div class="text-header-categories-main">
			<span><?php echo __("<strong>سفارش هــــــــــا</strong>", "lamkadeh") ?></span>
			<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
				<g clip-path="url(#clip0_26_3865)">
					<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
					<path fill-rule="evenodd" clip-rule="evenodd"
						d="M42 10.2917C40.9644 10.2917 40.125 11.1311 40.125 12.1667V12.3787C40.4729 12.375 40.8485 12.375 41.2543 12.375H42.7456C43.1515 12.375 43.5271 12.375 43.875 12.3787V12.1667C43.875 11.1311 43.0355 10.2917 42 10.2917ZM45.125 12.4224V12.1667C45.125 10.4408 43.7259 9.04166 42 9.04166C40.2741 9.04166 38.875 10.4408 38.875 12.1667V12.4224C38.7625 12.4306 38.6539 12.4403 38.5491 12.4516C37.8172 12.5305 37.205 12.6957 36.6615 13.0683C36.4745 13.1964 36.2989 13.3404 36.1366 13.4986C35.6646 13.9586 35.3825 14.5264 35.1616 15.2286C34.9471 15.9105 34.7738 16.7772 34.556 17.8663L34.5401 17.9458C34.2262 19.5151 33.9789 20.7517 33.9079 21.7366C33.8353 22.743 33.9367 23.5896 34.4134 24.3233C34.5725 24.5681 34.7581 24.7945 34.9669 24.9985C35.5929 25.6098 36.4032 25.8753 37.4042 26.0015C38.384 26.125 39.6451 26.125 41.2454 26.125H42.7545C44.3549 26.125 45.616 26.125 46.5957 26.0015C47.5968 25.8753 48.4071 25.6098 49.033 24.9985C49.2418 24.7945 49.4275 24.5681 49.5865 24.3233C50.0632 23.5896 50.1647 22.743 50.0921 21.7366C50.021 20.7517 49.7737 19.5151 49.4599 17.9459L49.444 17.8663C49.2261 16.7772 49.0528 15.9105 48.8383 15.2286C48.6174 14.5264 48.3353 13.9586 47.8634 13.4986C47.701 13.3404 47.5254 13.1964 47.3385 13.0683C46.7949 12.6957 46.1828 12.5305 45.4508 12.4516C45.346 12.4403 45.2375 12.4306 45.125 12.4224ZM38.6831 13.6944C38.0608 13.7614 37.6764 13.8881 37.3682 14.0994C37.2402 14.187 37.1201 14.2855 37.009 14.3938C36.7414 14.6546 36.5418 15.0067 36.354 15.6037C36.1621 16.2138 36.0011 17.0144 35.7746 18.1468C35.45 19.7699 35.2193 20.9294 35.1546 21.8265C35.0908 22.7115 35.1986 23.2374 35.4616 23.6422C35.5704 23.8097 35.6974 23.9647 35.8403 24.1042C36.1857 24.4415 36.6803 24.6504 37.5606 24.7613C38.453 24.8738 39.6352 24.875 41.2904 24.875H42.7095C44.3648 24.875 45.547 24.8738 46.4394 24.7613C47.3196 24.6504 47.8142 24.4415 48.1596 24.1042C48.3025 23.9647 48.4295 23.8097 48.5384 23.6422C48.8014 23.2374 48.9091 22.7115 48.8453 21.8265C48.7806 20.9294 48.5499 19.7699 48.2253 18.1468C47.9988 17.0144 47.8378 16.2138 47.6459 15.6037C47.4581 15.0067 47.2585 14.6546 46.9909 14.3938C46.8799 14.2855 46.7597 14.187 46.6318 14.0994C46.3236 13.8881 45.9391 13.7614 45.3169 13.6944C44.681 13.6258 43.8644 13.625 42.7095 13.625L41.2904 13.625C40.1355 13.625 39.319 13.6258 38.6831 13.6944ZM39.4341 19.9107C39.7596 19.7957 40.1166 19.9663 40.2317 20.2917C40.4894 21.0208 41.1847 21.5417 42.0001 21.5417C42.8155 21.5417 43.5109 21.0208 43.7686 20.2917C43.8836 19.9663 44.2407 19.7957 44.5662 19.9107C44.8916 20.0257 45.0622 20.3828 44.9472 20.7083C44.5185 21.9212 43.3618 22.7917 42.0001 22.7917C40.6385 22.7917 39.4818 21.9212 39.0531 20.7083C38.9381 20.3828 39.1087 20.0257 39.4341 19.9107Z"
						fill="#1D2977" />
					<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
				</g>
				<defs>
					<clipPath id="clip0_26_3865">
						<rect width="64" height="64" rx="32" fill="white" />
					</clipPath>
				</defs>
			</svg>
		</div>
		<div class="shape-header-categories-main"></div>
	</div>
</section>

<section class="filter-orders">
	<?php
	$user_id = get_current_user_id();
	if (!$user_id)
		return;

	$order_statuses = [
		'all' => __('همه', 'lamakdeh'),
		'processing' => __('جاری', 'lamakdeh'),
		'completed' => __('به اتمام رسیده', 'lamakdeh'),
		'cancelled' => __('لغو شده', 'lamakdeh'),
	];

	$order_counts = [];
	foreach ($order_statuses as $status_key => $status_label) {
		$args = [
			'customer_id' => $user_id,
			'limit' => -1,
			'return' => 'ids',
		];
		if ($status_key !== 'all') {
			$args['status'] = $status_key;
		}
		$order_counts[$status_key] = count(wc_get_orders($args));
	}

	$base_url = wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount'));
	$current_status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : 'all';

	foreach ($order_statuses as $key => $label) {
		$is_active = $current_status === $key ? 'active' : '';
		$url = add_query_arg('status', $key, $base_url);
		echo '<a href="' . esc_url($url) . '" class="item-filter-orders ' . esc_attr($is_active) . '">
			<span>' . esc_html($order_counts[$key]) . '</span>
			<span>' . esc_html($label) . '</span>
		</a>';
	}
	?>
</section>

<?php if ($has_orders): ?>

	<table
		class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table">
		<tr>
			<?php foreach (wc_get_account_orders_columns() as $column_id => $column_name): ?>
				<th scope="col"
					class="woocommerce-orders-table__header woocommerce-orders-table__header-<?php echo esc_attr($column_id); ?>">
					<span class="nobr"><?php echo esc_html($column_name); ?></span>
				</th>
			<?php endforeach; ?>
		</tr>

		<?php
		foreach ($customer_orders->orders as $customer_order) {
			$order = wc_get_order($customer_order); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			$item_count = $order->get_item_count() - $order->get_item_count_refunded();
		?>
			<tr
				class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr($order->get_status()); ?> order">
				<?php foreach (wc_get_account_orders_columns() as $column_id => $column_name):
					$is_order_number = 'order-number' === $column_id;
				?>

					<td>
						<?php if (has_action('woocommerce_my_account_my_orders_column_' . $column_id)): ?>
							<?php do_action('woocommerce_my_account_my_orders_column_' . $column_id, $order); ?>

						<?php elseif ($is_order_number): ?>
							<?php echo esc_html("#" . $order->get_order_number()); ?>

						<?php elseif ('order-date' === $column_id): ?>
							<time
								datetime="<?php echo esc_attr($order->get_date_created()->date('c')); ?>"><?php echo esc_html(wc_format_datetime($order->get_date_created())); ?></time>

						<?php elseif ('order-total' === $column_id): ?>
							<?php
							$amount = (float) $order->get_total();

							$currency = $order->get_currency() ?: get_option('woocommerce_currency');
							$symbol = get_woocommerce_currency_symbol($currency);
							$decimals = wc_get_price_decimals();
							$price_number = number_format_i18n($amount, $decimals);
							?>

							<div class="amount-order-myaccount-page">
								<span class="amount-order-myaccount"><?php echo esc_html($price_number); ?></span>
								<span class="symbol-order-myaccount"><?php echo esc_html($symbol); ?></span>
								<div class="rectangle-amount-order-myaccount"></div>
							</div>

						<?php elseif ('order-status' === $column_id): ?>
							<?php echo esc_html(wc_get_order_status_name($order->get_status())); ?>

						<?php elseif ('order-actions' === $column_id): ?>
							<?php
							$actions = wc_get_account_orders_actions($order);

							if (!empty($actions)) {
								foreach ($actions as $key => $action) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
									if (empty($action['aria-label'])) {
										// Generate the aria-label based on the action name.
										/* translators: %1$s Action name, %2$s Order number. */
										$action_aria_label = sprintf(__('%1$s order number %2$s', 'woocommerce'), $action['name'], $order->get_order_number());
									} else {
										$action_aria_label = $action['aria-label'];
									}
									echo '<a href="' . esc_url($action['url']) . '" class="woocommerce-button' . esc_attr($wp_button_class) . ' button ' . sanitize_html_class($key) . '" aria-label="' . esc_attr($action_aria_label) . '"><span>' . __("مشاهده", "lamkadeh") . '</span> <svg width="29" height="29" viewBox="0 0 29 29" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.729 9.57542C16.617 9.68738 16.4638 9.75809 16.2871 9.75809L9.75811 9.75809L9.75811 16.287C9.75811 16.6288 9.47527 16.9117 9.1335 16.9117C8.79173 16.9117 8.50889 16.6288 8.50889 16.287L8.50889 9.13348C8.50889 8.79171 8.79173 8.50887 9.1335 8.50887L16.2871 8.50887C16.6288 8.50887 16.9117 8.79171 16.9117 9.13348C16.9176 9.30437 16.841 9.46347 16.729 9.57542Z" fill="white"/><path d="M19.5926 19.5928C19.351 19.8344 18.9503 19.8344 18.7087 19.5928L8.79155 9.67558C8.54996 9.43399 8.54996 9.0333 8.79155 8.7917C9.03315 8.55011 9.43384 8.55011 9.67543 8.7917L19.5926 18.7089C19.8342 18.9505 19.8342 19.3512 19.5926 19.5928Z" fill="white"/></svg></a>';
									unset($action_aria_label);
								}
							}
							?>
						<?php endif; ?>

						<?php if ($is_order_number): ?>
							</th>
						<?php else: ?>
					</td>
				<?php endif; ?>
			<?php endforeach; ?>
			</tr>
		<?php
		}
		?>
	</table>

	<?php do_action('woocommerce_before_account_orders_pagination'); ?>

	<?php if (1 < $customer_orders->max_num_pages): ?>
		<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination">
			<?php if (1 !== $current_page): ?>
				<a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button<?php echo esc_attr($wp_button_class); ?>"
					href="<?php echo esc_url(wc_get_endpoint_url('orders', $current_page - 1)); ?>"><?php esc_html_e('Previous', 'woocommerce'); ?></a>
			<?php endif; ?>

			<?php if (intval($customer_orders->max_num_pages) !== $current_page): ?>
				<a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button<?php echo esc_attr($wp_button_class); ?>"
					href="<?php echo esc_url(wc_get_endpoint_url('orders', $current_page + 1)); ?>"><?php esc_html_e('Next', 'woocommerce'); ?></a>
			<?php endif; ?>
		</div>
	<?php endif; ?>

<?php else: ?>

	<section class="no-dashboard-lamkadeh">
		<svg width="72" height="72" viewBox="0 0 72 72" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd"
				d="M49.1817 6.06364L49.3812 6.11711C52.6794 7.00082 55.293 7.70112 57.3487 8.44374C59.4515 9.20336 61.1663 10.0723 62.579 11.3954C64.636 13.322 66.0755 15.8154 66.7155 18.5601C67.155 20.4451 67.0502 22.3646 66.6566 24.5655C66.2719 26.7172 65.5715 29.3309 64.6877 32.6292L63.0814 38.6241C62.1977 41.9221 61.4974 44.5357 60.7548 46.5914C59.9952 48.6942 59.1262 50.409 57.8031 51.8216C55.9378 53.8132 53.5412 55.226 50.8996 55.8947C50.1278 57.664 49.0008 59.2661 47.579 60.5978C46.1663 61.9209 44.4515 62.7898 42.3487 63.5495C40.293 64.2921 37.6794 64.9924 34.3814 65.876L34.1821 65.9294C30.8838 66.8132 28.2701 67.5136 26.1184 67.8984C23.9175 68.2919 21.998 68.3968 20.113 67.9573C17.3683 67.3173 14.8749 65.8777 12.9483 63.8207C11.6252 62.408 10.7563 60.6933 9.99665 58.5905C9.25403 56.5347 8.55373 53.9211 7.67001 50.6229L6.06366 44.628C5.17992 41.3298 4.47959 38.7162 4.09484 36.5646C3.70128 34.3637 3.59643 32.4442 4.03594 30.5592C4.67593 27.8145 6.11546 25.3211 8.1725 23.3945C9.58515 22.0714 11.2999 21.2025 13.4027 20.4428C15.4585 19.7002 18.0721 18.9999 21.3702 18.1162L21.47 18.0895C22.2634 17.8769 23.014 17.6761 23.7248 17.4883C24.8996 13.2909 25.9334 10.3238 27.9483 8.1725C29.8749 6.11546 32.3683 4.67593 35.113 4.03594C36.998 3.59643 38.9175 3.70128 41.1184 4.09484C43.27 4.47958 45.8836 5.17991 49.1817 6.06364ZM22.3651 22.5084C19.0864 23.3871 16.7372 24.0229 14.9316 24.6752C13.1033 25.3356 12.0299 25.9472 11.2487 26.6789C9.84121 27.9971 8.85627 29.7031 8.41838 31.5811C8.17534 32.6235 8.1824 33.8589 8.52457 35.7725C8.87168 37.7136 9.52066 40.143 10.4371 43.563L11.99 49.3586C12.9064 52.7786 13.559 55.2069 14.229 57.0616C14.8894 58.8899 15.501 59.9633 16.2327 60.7445C17.5509 62.152 19.2569 63.1369 21.1349 63.5748C22.1773 63.8179 23.4127 63.8108 25.3263 63.4686C27.2675 63.1215 29.6968 62.4725 33.1168 61.5561C36.5368 60.6397 38.9652 59.9871 40.8198 59.3171C42.6481 58.6567 43.7216 58.0451 44.5028 57.3134C44.9156 56.9268 45.2919 56.507 45.6288 56.0594C45.0917 55.9837 44.539 55.887 43.9671 55.7733C41.9516 55.3725 39.5306 54.7238 36.5425 53.9231L36.3702 53.877C33.0721 52.9933 30.4585 52.293 28.4027 51.5504C26.2999 50.7907 24.5851 49.9218 23.1725 48.5987C21.1155 46.6721 19.6759 44.1787 19.0359 41.434C18.5964 39.549 18.7013 37.6295 19.0948 35.4286C19.4796 33.277 20.1799 30.6633 21.0637 27.3652L22.3651 22.5084ZM40.3263 8.52457C38.4127 8.1824 37.1773 8.17534 36.1349 8.41838C34.2569 8.85627 32.5509 9.84121 31.2327 11.2487C29.9244 12.6455 29.1193 14.8036 27.7191 19.9297C27.4915 20.7628 27.2509 21.6607 26.99 22.6346L25.437 28.4302C24.5207 31.8502 23.8717 34.2796 23.5246 36.2207C23.1824 38.1343 23.1753 39.3697 23.4184 40.4121C23.8563 42.2901 24.8412 43.9961 26.2487 45.3143C27.0299 46.046 28.1033 46.6576 29.9316 47.318C31.7863 47.988 34.2146 48.6407 37.6346 49.557C40.7109 50.3813 42.9908 50.9911 44.8447 51.3597C46.6904 51.7267 47.9429 51.8168 48.9695 51.6901C49.1928 51.6626 49.4074 51.6245 49.6166 51.5757C51.4946 51.1378 53.2005 50.1529 54.5187 48.7454C55.2504 47.9642 55.862 46.8908 56.5225 45.0625C57.1925 43.2078 57.8451 40.7795 58.7615 37.3595L60.3144 31.5639C61.2308 28.1439 61.8798 25.7145 62.2269 23.7734C62.5691 21.8598 62.5761 20.6244 62.3331 19.582C61.8952 17.704 60.9102 15.998 59.5028 14.6798C58.7216 13.9481 57.6481 13.3365 55.8198 12.6761C53.9652 12.0061 51.5368 11.3534 48.1168 10.4371C44.6968 9.52066 42.2675 8.87168 40.3263 8.52457ZM33.1572 29.4176C33.4788 28.2173 34.7126 27.505 35.9129 27.8266L50.4018 31.7089C51.6021 32.0305 52.3144 33.2643 51.9928 34.4646C51.6711 35.6649 50.4374 36.3772 49.2371 36.0556L34.7482 32.1733C33.5479 31.8517 32.8356 30.6179 33.1572 29.4176ZM30.8266 38.1107C31.1483 36.9105 32.382 36.1981 33.5823 36.5198L42.2757 38.8491C43.476 39.1707 44.1883 40.4045 43.8666 41.6048C43.545 42.8051 42.3113 43.5174 41.111 43.1958L32.4176 40.8664C31.2173 40.5448 30.505 39.311 30.8266 38.1107Z"
				fill="#1D2977" />
		</svg>
		<span><?php echo __("شما هنوز سفارشی را ثبت نکرده اید.", "lamkadeh") ?></span>
		<a href="<?php echo esc_url(wc_get_page_permalink('shop')) ?>"><?php echo __("مشاهده محصولات", "lamkadeh") ?></a>
	</section>

<?php endif; ?>

<?php do_action('woocommerce_after_account_orders', $has_orders); ?>