<?php

/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-customer.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.7.0
 */

defined('ABSPATH') || exit;

/** @var WC_Order $order */

$shipping_first_name  = $order->get_shipping_first_name();
$shipping_last_name   = $order->get_shipping_last_name();
$shipping_phone       = $order->get_billing_phone(); // شماره همراه معمولاً در فیلد Billing ذخیره می‌شود
$shipping_postcode    = $order->get_shipping_postcode();
$shipping_email       = $order->get_billing_email(); // ایمیل معمولاً در فیلد Billing ذخیره می‌شود
$shipping_city        = $order->get_shipping_city();
$shipping_state       = $order->get_shipping_state();
$shipping_address     = $order->get_shipping_address_1();
?>

<section class="data-view-order container">
	<h4><?php echo __("آدرس ارسال", "lamkadeh") ?></h4>

	<div class="data-view-order-content container">
		<div class="data-view-order-content-right">
			<span><?php echo __("نام و نام خانوادگی", "lamkadeh"); ?></span>
			<span><?php echo __("شماره همراه", "lamkadeh"); ?></span>
			<span><?php echo __("کد پستی", "lamkadeh"); ?></span>
			<span><?php echo __("ایمیل", "lamkadeh"); ?></span>
			<span><?php echo __("شهر", "lamkadeh"); ?></span>
			<span><?php echo __("استان", "lamkadeh"); ?></span>
			<span><?php echo __("آدرس پستی", "lamkadeh"); ?></span>
		</div>
		<div class="data-view-order-content-left">
			<span><?php echo esc_html($shipping_first_name . ' ' . $shipping_last_name); ?></span>
			<span><?php echo esc_html($shipping_phone ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_postcode ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_email ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_city ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_state ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_address ?: __('ثبت نشده', 'lamkadeh')); ?></span>
		</div>
	</div>
</section>