<?php

/**
 * Order tracking
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/tracking.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 */

defined('ABSPATH') || exit;

if (!function_exists('jdate')) {
require_once(get_template_directory() . "/includes/date-convertor-shamsi/jdf.php");
}
echo "<div class='container'>";
breadcrumb();
echo "</div>";
/** @var WC_Order $order */
$order_id = $order->get_id();
$order_date = $order->get_date_created();
$order_status = $order->get_status();
$order_total = $order->get_total();
$order_currency = $order->get_currency();
$shamsi_date = function_exists('jdate') ? jdate('d F Y', strtotime($order_date)) : $order_date->date('Y/m/d');

$order_statuses_fa = [
'pending' => 'در انتظار پرداخت',
'processing' => 'جاری',
'on-hold' => 'در حالت تعلیق',
'completed' => 'به اتمام رسیده',
'cancelled' => 'لغو شده',
'refunded' => 'برگشت داده شده',
'failed' => 'ناموفق',
];

$payment_status = in_array($order_status, ['completed', 'processing']) ? 'پرداخت شده' : 'در انتظار پرداخت';
$order_status_fa = isset($order_statuses_fa[$order_status]) ? $order_statuses_fa[$order_status] : $order_status;
?>

<section class="header-view-order container">
	<div class="header-view-order-wrapper">

		<!-- شماره سفارش -->
		<div class="header-view-order-item">
			<div class="header-view-order-icon">
				<svg width="21" height="26" viewBox="0 0 21 26" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M8.28809 0.5V6.85156H12.7119V0.5H16.4414V6.85156H20.5V10.3779H16.4414V15.8027H20.5V19.3281H16.4414V25.5H12.7119V19.3281H8.28809V25.5H4.55859V19.3281H0.5V15.8027H4.55859V10.3779H0.5V6.85156H4.55859V0.5H8.28809ZM8.28809 15.8027H12.7119V10.3779H8.28809V15.8027Z" stroke="white" />
					<path d="M7.93066 0.5V6.85156H12.0693V0.5H15.6553V6.85156H19.5V10.3779H15.6553V15.8027H19.5V19.3281H15.6553V25.5H12.0693V19.3281H7.93066V25.5H4.34473V19.3281H0.5V15.8027H4.34473V10.3779H0.5V6.85156H4.34473V0.5H7.93066ZM7.93066 15.8027H12.0693V10.3779H7.93066V15.8027Z" stroke="#1D2977" />
				</svg>
			</div>
			<div class="header-view-order-content">
				<div class="header-view-order-content-text">#<?php echo $order_id; ?></div>
				<span><?php _e("شماره سفارش", "lamkadeh"); ?></span>
			</div>
		</div>

		<!-- تاریخ سفارش -->
		<div class="header-view-order-item">
			<div class="header-view-order-icon">
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M2.5 9H21.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
					<path d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12V14C22 17.7712 22 19.6569 20.8284 20.8284C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V12Z" stroke="#1D2977" stroke-width="1.5" />
					<path d="M7 4V2.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
					<path d="M17 4V2.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
					<path d="M17 16.5C17.2761 16.5 17.5 16.7239 17.5 17C17.5 17.2761 17.2761 17.5 17 17.5C16.7239 17.5 16.5 17.2761 16.5 17C16.5 16.7239 16.7239 16.5 17 16.5ZM17 12.5C17.2761 12.5 17.5 12.7239 17.5 13C17.5 13.2761 17.2761 13.5 17 13.5C16.7239 13.5 16.5 13.2761 16.5 13C16.5 12.7239 16.7239 12.5 17 12.5Z" fill="#1C274C" stroke="#1D2977" />
					<path d="M12 16.5C12.2761 16.5 12.5 16.7239 12.5 17C12.5 17.2761 12.2761 17.5 12 17.5C11.7239 17.5 11.5 17.2761 11.5 17C11.5 16.7239 11.7239 16.5 12 16.5ZM12 12.5C12.2761 12.5 12.5 12.7239 12.5 13C12.5 13.2761 12.2761 13.5 12 13.5C11.7239 13.5 11.5 13.2761 11.5 13C11.5 12.7239 11.7239 12.5 12 12.5Z" fill="#1C274C" stroke="#1D2977" />
					<path d="M7 16.5C7.27614 16.5 7.5 16.7239 7.5 17C7.5 17.2761 7.27614 17.5 7 17.5C6.72386 17.5 6.5 17.2761 6.5 17C6.5 16.7239 6.72386 16.5 7 16.5ZM7 12.5C7.27614 12.5 7.5 12.7239 7.5 13C7.5 13.2761 7.27614 13.5 7 13.5C6.72386 13.5 6.5 13.2761 6.5 13C6.5 12.7239 6.72386 12.5 7 12.5Z" fill="#1C274C" stroke="#1D2977" />
				</svg>
			</div>
			<div class="header-view-order-content">
				<div class="header-view-order-content-text"><?php echo esc_html($shamsi_date); ?></div>
				<span><?php _e("تاریخ ثبت سفارش", "lamkadeh"); ?></span>
			</div>
		</div>

		<!-- وضعیت پرداخت -->
		<div class="header-view-order-item">
			<div class="header-view-order-icon">
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M10 16H6" stroke="white" stroke-width="1.5" stroke-linecap="round" />
					<path d="M14 16H12.5" stroke="white" stroke-width="1.5" stroke-linecap="round" />
					<path d="M2 10L22 10" stroke="white" stroke-width="1.5" stroke-linecap="round" />
					<path d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.8284 18.8284C19.6569 20 17.7712 20 14 20H10C6.22876 20 4.34315 20 3.17157 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="#1D2977" stroke-width="1.5" />
				</svg>
			</div>
			<div class="header-view-order-content">
				<div class="header-view-order-content-text"><?php echo esc_html($payment_status); ?></div>
				<span><?php _e("وضعیت پرداخت", "lamkadeh"); ?></span>
			</div>
		</div>

		<!-- مبلغ سفارش -->
		<div class="header-view-order-item">
			<div class="header-view-order-icon">
				<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M9 19C6.19108 19 4.78661 19 3.77772 18.3259C3.34096 18.034 2.96596 17.659 2.67412 17.2223C2 16.2134 2 14.8089 2 12C2 9.19108 2 7.78661 2.67412 6.77772C2.96596 6.34096 3.34096 5.96596 3.77772 5.67412C4.78661 5 6.19108 5 9 5L15 5C17.8089 5 19.2134 5 20.2223 5.67412C20.659 5.96596 21.034 6.34096 21.3259 6.77772C22 7.78661 22 9.19108 22 12C22 14.8089 22 16.2134 21.3259 17.2223C21.034 17.659 20.659 18.034 20.2223 18.3259C19.2134 19 17.8089 19 15 19H9Z" stroke="#1D2977" stroke-width="1.5" />
					<path d="M9 9C7.34315 9 6 10.3431 6 12C6 13.6569 7.34315 15 9 15" stroke="white" stroke-width="1.5" />
					<path d="M15 9C16.6569 9 18 10.3431 18 12C18 13.6569 16.6569 15 15 15" stroke="white" stroke-width="1.5" />
					<path d="M9 5V18.5" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" />
					<path d="M15 5V18.5" stroke="#1D2977" stroke-width="1.5" stroke-linecap="round" />
				</svg>
			</div>
			<div class="header-view-order-content">
				<div class="header-view-order-content-text">
					<div class="header-view-order-content-text-price">
						<div></div>
						<span><?php echo number_format($order_total); ?></span>
						<span><?php echo esc_html(get_woocommerce_currency_symbol($order_currency)); ?></span>
					</div>
				</div>
				<span><?php _e("مبلغ سفارش", "lamkadeh"); ?></span>
			</div>
		</div>

	</div>
	<div class="header-view-order-shape-one"></div>
	<div class="header-view-order-shape-two"></div>
	<div class="header-view-order-shape-three"></div>
	<div class="header-view-order-shape-four"></div>
</section>

<?php
/** @var WC_Order $order */
$order_items = $order->get_items();
$order_currency = $order->get_currency();
?>

<table class="table-view-order container">
	<tr>
		<th><?php _e('نام کالا', 'lamkadeh'); ?></th>
		<th><?php _e('مبلغ جزء', 'lamkadeh'); ?></th>
		<th><?php _e('تعداد', 'lamkadeh'); ?></th>
		<th><?php _e('مبلغ کل', 'lamkadeh'); ?></th>
	</tr>
	<?php foreach ($order_items as $item_id => $item) :
		$product = $item->get_product();
		if (!$product) continue;

		$product_name = $item->get_name();
		$quantity = $item->get_quantity();
		$subtotal = $item->get_subtotal();
		$total = $item->get_total();
	?>
		<tr>
			<td>
				<a href="<?php echo get_permalink($product->get_id()); ?>">
					<?php echo esc_html($product_name); ?>
				</a>
			</td>

			<td>
				<div class="header-view-order-content-text">
					<div class="header-view-order-content-text-price">
						<div></div>
						<span><?php echo number_format($subtotal); ?></span>
						<span><?php echo esc_html(get_woocommerce_currency_symbol($order_currency)); ?></span>
					</div>
				</div>
			</td>

			<td class="quantity-table"><?php echo esc_html($quantity); ?></td>

			<td>
				<div class="header-view-order-content-text">
					<div class="header-view-order-content-text-price">
						<div></div>
						<span><?php echo number_format($total); ?></span>
						<span><?php echo esc_html(get_woocommerce_currency_symbol($order_currency)); ?></span>
					</div>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>
</table>

<?php
/** @var WC_Order $order */
if (!function_exists('jdate')) {
	require_once(get_template_directory() . "/includes/date-convertor-shamsi/jdf.php");
}

$order_statuses_fa = [
	'pending'      => 'در انتظار پرداخت',
	'processing'   => 'جاری',
	'on-hold'      => 'در انتظار',
	'completed'    => 'به اتمام رسیده',
	'cancelled'    => 'لغو شده',
	'refunded'     => 'برگشت داده شده',
	'failed'       => 'ناموفق',
];

$order_status = $order->get_status();
$order_status_fa = isset($order_statuses_fa[$order_status]) ? $order_statuses_fa[$order_status] : $order_status;

$shipping_meta   = get_post_meta($order->get_id(), '_recive_date_shipping', true);
$shipping_method = $order->get_shipping_method();
$shipping_total  = $order->get_shipping_total(); // مبلغ حمل
$payment_method  = $order->get_payment_method_title();
$transaction_id  = $order->get_transaction_id();
$currency_symbol = get_woocommerce_currency_symbol();
?>

<section class="data-view-order container">
	<h4><?php echo __("اطلاعات سفارش", "lamkadeh"); ?></h4>
	<div class="data-view-order-content">
		<div class="data-view-order-content-right">
			<span><?php echo __("وضعیت سفارش", "lamkadeh"); ?></span>
			<span><?php echo __("تاریخ ارسال", "lamkadeh"); ?></span>
			<span><?php echo __("نحوه ی ارسال", "lamkadeh"); ?></span>
			<span><?php echo __("نحوه ی پرداخت", "lamkadeh"); ?></span>
			<span><?php echo __("شناسه پرداخت", "lamkadeh"); ?></span>
		</div>
		<div class="data-view-order-content-left">
			<span><?php echo esc_html($order_status_fa); ?></span>
			<span><?php echo esc_html($shipping_meta ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span>
				<?php
				if ($shipping_method) {
					echo esc_html($shipping_method) . ' - ' . number_format($shipping_total) . ' ' . esc_html($currency_symbol);
				} else {
					echo __('ثبت نشده', 'lamkadeh');
				}
				?>
			</span>
			<span><?php echo esc_html($payment_method ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($transaction_id ?: __('ثبت نشده', 'lamkadeh')); ?></span>
		</div>
	</div>
</section>

<?php
/** @var WC_Order $order */
$shipping_first_name  = $order->get_shipping_first_name();
$shipping_last_name   = $order->get_shipping_last_name();
$shipping_phone       = $order->get_billing_phone();
$shipping_postcode    = $order->get_shipping_postcode();
$shipping_email       = $order->get_billing_email();
$shipping_city        = $order->get_shipping_city();
$shipping_state       = $order->get_shipping_state();
$shipping_address     = $order->get_shipping_address_1();
?>

<section class="data-view-order container">
	<h4><?php echo __("آدرس ارسال", "lamkadeh") ?></h4>

	<div class="data-view-order-content">
		<div class="data-view-order-content-right">
			<span><?php echo __("نام و نام خانوادگی", "lamkadeh"); ?></span>
			<span><?php echo __("شماره همراه", "lamkadeh"); ?></span>
			<span><?php echo __("کد پستی", "lamkadeh"); ?></span>
			<span><?php echo __("ایمیل", "lamkadeh"); ?></span>
			<span><?php echo __("شهر", "lamkadeh"); ?></span>
			<span><?php echo __("استان", "lamkadeh"); ?></span>
			<span><?php echo __("آدرس پستی", "lamkadeh"); ?></span>
		</div>
		<div class="data-view-order-content-left">
			<span><?php echo esc_html($shipping_first_name . ' ' . $shipping_last_name); ?></span>
			<span><?php echo esc_html($shipping_phone ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_postcode ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_email ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_city ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_state ?: __('ثبت نشده', 'lamkadeh')); ?></span>
			<span><?php echo esc_html($shipping_address ?: __('ثبت نشده', 'lamkadeh')); ?></span>
		</div>
	</div>
</section>