<?php

/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined('ABSPATH') || exit;

global $product;

if (!comments_open()) {
	return;
}

$count = $product->get_review_count();
if ($count === 0 && !wc_review_ratings_enabled()) {
	return;
}
$heading = apply_filters('woocommerce_reviews_title', __('دیدگاه‌های شــــــــــــما', 'lamkadeh'));
$heading_send_comment = __("ثبت دیدگاه شمــــــــــا", "lamkadeh");
?>
<div id="reviews" class="woocommerce-Reviews">
	<div id="comments">

		<div class="title-description-single-product">
			<div class="title-description-single-product-main">
				<span class="title-description-single-product-subtitle">COMMENT</span>
				<div class="title-description-single-product-content">
					<?php if ($heading): ?>
						<span><?php echo esc_html($heading); ?></span>
					<?php endif; ?>
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_1_11397)">
							<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
							<path fill-rule="evenodd" clip-rule="evenodd"
								d="M49.817 20.5089C49.4772 19.9205 48.8545 19.727 48.2601 19.6439C47.6609 19.5601 46.8589 19.5601 45.8889 19.5602L45.8337 19.5602C45.2561 19.5602 44.8784 19.5545 44.6033 19.5162C44.3545 19.4816 44.2754 19.4304 44.2416 19.4006C44.2169 19.3748 44.1729 19.3145 44.1429 19.0973C44.1075 18.8412 44.106 18.49 44.106 17.9271V17.5838C44.106 16.1286 44.106 14.9628 43.994 14.1317C43.8889 13.3515 43.639 12.4753 42.7735 12.2101C41.9232 11.9495 41.21 12.5083 40.6556 13.0843C40.0651 13.698 39.3636 14.6472 38.4853 15.8356L35.6097 19.7262C35.0502 20.4831 34.5838 21.1141 34.3059 21.6358C34.0274 22.1588 33.8246 22.7798 34.1336 23.3993L34.1347 23.4016L34.138 23.4083L34.1417 23.4156L34.1453 23.4226L34.1493 23.4301L34.1533 23.4376L34.1572 23.4445L34.1612 23.4516L34.1649 23.4579L34.1663 23.4602C34.5032 24.0436 35.1232 24.2479 35.723 24.3394C36.3411 24.4338 37.1659 24.4399 38.1663 24.4399C38.7498 24.4399 39.1219 24.4412 39.3952 24.476C39.6366 24.5068 39.7088 24.5542 39.7397 24.5816C39.7671 24.6102 39.8152 24.6771 39.8491 24.9022C39.8879 25.1598 39.894 25.5165 39.894 26.073L39.894 26.4161C39.8939 27.8714 39.8939 29.0371 40.0059 29.8683C40.111 30.6484 40.3609 31.5246 41.2264 31.7899C42.0767 32.0505 42.7899 31.4917 43.3442 30.9157C43.9348 30.302 44.6363 29.3528 45.5147 28.1644L48.3558 24.3205C48.934 23.5382 49.4095 22.8846 49.69 22.3406C49.9644 21.8083 50.1559 21.1837 49.8498 20.5698L49.8487 20.5676L49.8454 20.5609L49.8417 20.5536L49.8381 20.5465L49.8341 20.539L49.83 20.5315L49.8261 20.5246L49.8221 20.5175L49.8183 20.5111L49.817 20.5089ZM41.6464 14.0378C41.1258 14.5788 40.477 15.4541 39.5569 16.699L36.7499 20.4968C36.147 21.3125 35.7437 21.8613 35.5195 22.2822C35.4104 22.487 35.3695 22.6162 35.3578 22.6945C35.3506 22.7428 35.355 22.7646 35.3608 22.7786C35.3829 22.8112 35.4792 22.9113 35.9305 22.9802C36.4236 23.0555 37.1326 23.0649 38.1663 23.0649L38.2084 23.0649C38.7374 23.0648 39.1984 23.0648 39.5691 23.1121C39.9662 23.1627 40.3606 23.2778 40.6872 23.585L40.6925 23.59L40.6977 23.5951C41.0186 23.9101 41.149 24.3005 41.2088 24.6975C41.2659 25.0768 41.269 25.5435 41.269 26.073L41.269 26.3568C41.269 27.8848 41.2705 28.9568 41.3686 29.6847C41.4174 30.0471 41.4831 30.2597 41.546 30.3785C41.5931 30.4674 41.6203 30.4733 41.6279 30.4749L41.6293 30.4752L41.6307 30.4757C41.6403 30.479 41.674 30.4907 41.7782 30.4382C41.9084 30.3727 42.0944 30.2315 42.3535 29.9622C42.8741 29.4212 43.5229 28.5459 44.443 27.301L47.25 23.5032C47.8495 22.6922 48.2489 22.1353 48.4679 21.7106C48.6555 21.3465 48.6351 21.2232 48.6226 21.1905C48.602 21.1604 48.5096 21.0672 48.0697 21.0056C47.5773 20.9368 46.8728 20.9352 45.8337 20.9352C45.2811 20.9352 44.8018 20.932 44.414 20.8781C44.0135 20.8224 43.6182 20.7019 43.2944 20.3974L43.2891 20.3924L43.2839 20.3873C42.9601 20.0695 42.8352 19.6795 42.7808 19.2854C42.7309 18.924 42.7309 18.4763 42.731 17.9714L42.731 17.6432C42.731 16.1152 42.7294 15.0432 42.6313 14.3153C42.5825 13.9529 42.5168 13.7403 42.4539 13.6215C42.4067 13.5326 42.3796 13.5267 42.372 13.5251L42.3706 13.5248L42.3692 13.5243C42.3596 13.521 42.3258 13.5093 42.2216 13.5618C42.0915 13.6273 41.9055 13.7685 41.6464 14.0378Z"
								fill="#1D2977" />
							<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
						</g>
						<defs>
							<clipPath id="clip0_1_11397">
								<rect width="64" height="64" rx="32" fill="white" />
							</clipPath>
						</defs>
					</svg>

				</div>
				<div class="title-description-single-product-shape"></div>
			</div>
			<div class="title-description-single-product-text">
				<span>
					<strong>نظرات خریداران واقعی</strong> رو اینجا بخون! تجربه‌های اونا می‌تونه کمک کنه <strong>انتخابت
						مطمئن‌تر</strong> باشه.
				</span>
			</div>
		</div>

		<?php if (have_comments()): ?>

			<div class="lamkadeh-single-review">
				<?php
				wp_list_comments(apply_filters('woocommerce_product_review_list_args', array(
					'callback' => 'lamkadeh_review_display',
					'orderby' => 'comment_date_gmt',
					'status'  => 'approve',
					'order'   => 'DESC',
					'avatar_size' => 64,
				)));
				?>
			</div>

			<?php
			if (get_comment_pages_count() > 1 && get_option('page_comments')):
				echo '<nav class="woocommerce-pagination">';
				paginate_comments_links(
					apply_filters(
						'woocommerce_comment_pagination_args',
						array(
							'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
							'next_text' => is_rtl() ? '&larr;' : '&rarr;',
							'type' => 'list',
						)
					)
				);
				echo '</nav>';
			endif;
			?>
		<?php else: ?>
			<p class="woocommerce-noreviews"><?php esc_html_e('There are no reviews yet.', 'woocommerce'); ?></p>
		<?php endif; ?>
	</div>

	<?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())): ?>
		<div id="review_form_wrapper">
			<div class="review-form-lamkadeh" id="review_form">
				<div class="review-form-lamkadeh-wrapper">
					<div class="title-description-single-product">
						<div class="title-description-single-product-main">
							<span class="title-description-single-product-subtitle">CONTACT US</span>
							<div class="title-description-single-product-content">
								<?php if ($heading_send_comment): ?>
									<span><?php echo esc_html($heading_send_comment); ?></span>
								<?php endif; ?>
								<svg width="64" height="64" viewBox="0 0 64 64" fill="none"
									xmlns="http://www.w3.org/2000/svg">
									<g clip-path="url(#clip0_1_11397)">
										<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
										<path fill-rule="evenodd" clip-rule="evenodd"
											d="M49.817 20.5089C49.4772 19.9205 48.8545 19.727 48.2601 19.6439C47.6609 19.5601 46.8589 19.5601 45.8889 19.5602L45.8337 19.5602C45.2561 19.5602 44.8784 19.5545 44.6033 19.5162C44.3545 19.4816 44.2754 19.4304 44.2416 19.4006C44.2169 19.3748 44.1729 19.3145 44.1429 19.0973C44.1075 18.8412 44.106 18.49 44.106 17.9271V17.5838C44.106 16.1286 44.106 14.9628 43.994 14.1317C43.8889 13.3515 43.639 12.4753 42.7735 12.2101C41.9232 11.9495 41.21 12.5083 40.6556 13.0843C40.0651 13.698 39.3636 14.6472 38.4853 15.8356L35.6097 19.7262C35.0502 20.4831 34.5838 21.1141 34.3059 21.6358C34.0274 22.1588 33.8246 22.7798 34.1336 23.3993L34.1347 23.4016L34.138 23.4083L34.1417 23.4156L34.1453 23.4226L34.1493 23.4301L34.1533 23.4376L34.1572 23.4445L34.1612 23.4516L34.1649 23.4579L34.1663 23.4602C34.5032 24.0436 35.1232 24.2479 35.723 24.3394C36.3411 24.4338 37.1659 24.4399 38.1663 24.4399C38.7498 24.4399 39.1219 24.4412 39.3952 24.476C39.6366 24.5068 39.7088 24.5542 39.7397 24.5816C39.7671 24.6102 39.8152 24.6771 39.8491 24.9022C39.8879 25.1598 39.894 25.5165 39.894 26.073L39.894 26.4161C39.8939 27.8714 39.8939 29.0371 40.0059 29.8683C40.111 30.6484 40.3609 31.5246 41.2264 31.7899C42.0767 32.0505 42.7899 31.4917 43.3442 30.9157C43.9348 30.302 44.6363 29.3528 45.5147 28.1644L48.3558 24.3205C48.934 23.5382 49.4095 22.8846 49.69 22.3406C49.9644 21.8083 50.1559 21.1837 49.8498 20.5698L49.8487 20.5676L49.8454 20.5609L49.8417 20.5536L49.8381 20.5465L49.8341 20.539L49.83 20.5315L49.8261 20.5246L49.8221 20.5175L49.8183 20.5111L49.817 20.5089ZM41.6464 14.0378C41.1258 14.5788 40.477 15.4541 39.5569 16.699L36.7499 20.4968C36.147 21.3125 35.7437 21.8613 35.5195 22.2822C35.4104 22.487 35.3695 22.6162 35.3578 22.6945C35.3506 22.7428 35.355 22.7646 35.3608 22.7786C35.3829 22.8112 35.4792 22.9113 35.9305 22.9802C36.4236 23.0555 37.1326 23.0649 38.1663 23.0649L38.2084 23.0649C38.7374 23.0648 39.1984 23.0648 39.5691 23.1121C39.9662 23.1627 40.3606 23.2778 40.6872 23.585L40.6925 23.59L40.6977 23.5951C41.0186 23.9101 41.149 24.3005 41.2088 24.6975C41.2659 25.0768 41.269 25.5435 41.269 26.073L41.269 26.3568C41.269 27.8848 41.2705 28.9568 41.3686 29.6847C41.4174 30.0471 41.4831 30.2597 41.546 30.3785C41.5931 30.4674 41.6203 30.4733 41.6279 30.4749L41.6293 30.4752L41.6307 30.4757C41.6403 30.479 41.674 30.4907 41.7782 30.4382C41.9084 30.3727 42.0944 30.2315 42.3535 29.9622C42.8741 29.4212 43.5229 28.5459 44.443 27.301L47.25 23.5032C47.8495 22.6922 48.2489 22.1353 48.4679 21.7106C48.6555 21.3465 48.6351 21.2232 48.6226 21.1905C48.602 21.1604 48.5096 21.0672 48.0697 21.0056C47.5773 20.9368 46.8728 20.9352 45.8337 20.9352C45.2811 20.9352 44.8018 20.932 44.414 20.8781C44.0135 20.8224 43.6182 20.7019 43.2944 20.3974L43.2891 20.3924L43.2839 20.3873C42.9601 20.0695 42.8352 19.6795 42.7808 19.2854C42.7309 18.924 42.7309 18.4763 42.731 17.9714L42.731 17.6432C42.731 16.1152 42.7294 15.0432 42.6313 14.3153C42.5825 13.9529 42.5168 13.7403 42.4539 13.6215C42.4067 13.5326 42.3796 13.5267 42.372 13.5251L42.3706 13.5248L42.3692 13.5243C42.3596 13.521 42.3258 13.5093 42.2216 13.5618C42.0915 13.6273 41.9055 13.7685 41.6464 14.0378Z"
											fill="#1D2977" />
										<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
									</g>
									<defs>
										<clipPath id="clip0_1_11397">
											<rect width="64" height="64" rx="32" fill="white" />
										</clipPath>
									</defs>
								</svg>

							</div>
							<div class="title-description-single-product-shape"></div>
						</div>
						<div class="title-description-single-product-text">
							<span><?php echo __("<strong>نظرات خریداران واقعی</strong> رو اینجا بخون! تجربه‌های اونا می‌تونه کمک کنه <strong>انتخابت مطمئن‌تر</strong> باشه.", "lamkadeh") ?></span>
						</div>
					</div>

					<?php
					$commenter = wp_get_current_commenter();
					$comment_form = array(
						/* translators: %s is product title */
						'title_reply' => have_comments() ? esc_html__('', 'woocommerce') : sprintf(esc_html__('Be the first to review &ldquo;%s&rdquo;', 'woocommerce'), get_the_title()),
						/* translators: %s is product title */
						'title_reply_to' => esc_html__('Leave a Reply to %s', 'woocommerce'),
						'title_reply_before' => '<span id="reply-title" class="comment-reply-title" role="heading" aria-level="3">',
						'title_reply_after' => '</span>',
						'comment_notes_after' => '',
						'label_submit' => esc_html__('ثبت نظر', 'lamkadeh'),
						'submit_button' => '<div class="btn-send-comment-lamkadeh"><button type="submit" class="btn-send-comment-lamkadeh-right"><span>' . esc_html__('ثبت نظر', 'lamkadeh') . '</span></button><div class="btn-send-comment-lamkadeh-left"><svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M23.6216 13.6066C23.4648 13.7633 23.2504 13.8623 23.0029 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4664 23.8773 12.9879 23.8773C12.5094 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5094 12.1134 12.9879 12.1134L23.0029 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8856 13.2271 23.7783 13.4498 23.6216 13.6066Z" fill="white" /><path d="M27.6308 27.6309C27.2926 27.9692 26.7316 27.9692 26.3934 27.6309L12.5093 13.7469C12.1711 13.4087 12.1711 12.8477 12.5093 12.5095C12.8476 12.1712 13.4085 12.1712 13.7468 12.5095L27.6308 26.3935C27.9691 26.7317 27.9691 27.2927 27.6308 27.6309Z" fill="white" /></svg></div></div>',
						'logged_in_as' => '',
						'comment_field' => '',
					);

					$name_email_required = (bool) get_option('require_name_email', 1);
					$fields = array(
						'author' => array(
							'label' => __('Name', 'woocommerce'),
							'type' => 'text',
							'value' => $commenter['comment_author'],
							'required' => $name_email_required,
							'autocomplete' => 'name',
						),
						'last_name' => array(
							'label' => __('نام خانوادگی', 'lamkadeh'),
							'type' => 'text',
							'value' => '',
							'autocomplete' => 'family-name',
							'required' => true,
						),
						'email' => array(
							'label' => __('Email', 'woocommerce'),
							'type' => 'email',
							'value' => $commenter['comment_author_email'],
							'required' => $name_email_required,
							'autocomplete' => 'email',
						),
					);

					$comment_form['fields'] = array();
					$fields_html = '<div class="lamkadeh-form-commment-auther-email">';
					foreach ($fields as $key => $field) {
						if ($key != "email") {
							$fields_html .= '<p class="comment-form-' . esc_attr($key) . '">';
							$fields_html .= '<label for="' . esc_attr($key) . '">' . esc_html($field['label']) . '</label>';
							$fields_html .= '<input id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" autocomplete="' . esc_attr($field['autocomplete']) . '" value="' . esc_attr($field['value']) . '" size="30" ' . ($field['required'] ? 'required' : '') . ' />';
							$fields_html .= '</p>';
						}
					}

					$fields_html .= '</div>';

					$fields_html .= '<div class="lamkadeh-form-commment-auther-email email_and_rating">';

					foreach ($fields as $key => $field) {
						if ($key == "email") {
							$fields_html .= '<p class="comment-form-' . esc_attr($key) . '">';
							$fields_html .= '<label for="' . esc_attr($key) . '">' . esc_html($field['label']) . '</label>';
							$fields_html .= '<input id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" autocomplete="' . esc_attr($field['autocomplete']) . '" value="' . esc_attr($field['value']) . '" size="30" ' . ($field['required'] ? 'required' : '') . ' />';
							$fields_html .= '</p>';
						}
					}

					$fields_html .= '</div>';

					$comment_form['fields']['author_email_group'] = $fields_html;

					if (wc_review_ratings_enabled()) {
						$comment_form['comment_field'] = '<div class="comment-form-rating">
						<label for="rating" id="comment-form-rating-label">' . esc_html__('امتیاز', 'lamkadeh') . '</label>
						<span class="comment-form-rating-number">5.0</span>
						<select name="rating" id="rating" required>
						<option value="">' . esc_html__('Rate&hellip;', 'woocommerce') . '</option>
						<option value="5">' . esc_html__('Perfect', 'woocommerce') . '</option>
						<option value="4">' . esc_html__('Good', 'woocommerce') . '</option>
						<option value="3">' . esc_html__('Average', 'woocommerce') . '</option>
						<option value="2">' . esc_html__('Not that bad', 'woocommerce') . '</option>
						<option value="1">' . esc_html__('Very poor', 'woocommerce') . '</option>
					</select></div>';
					}

					$account_page_url = wc_get_page_permalink('myaccount');
					if ($account_page_url) {
						$comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</p>';
					}

					$comment_form['comment_field'] .= '<p class="comment-form-comment textarea-form-comment-label-lamkadeh"><label for="comment">' . esc_html__('دیدگاه', 'lamkadeh') . '&nbsp;</label><textarea id="comment" class="textarea-form-comment-lamkadeh" name="comment" cols="45" rows="8" required></textarea></p>';

					comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
					?>
				</div>
			</div>
		</div>
	<?php else: ?>
		<p class="woocommerce-verification-required">
			<?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?>
		</p>
	<?php endif; ?>

	<div class="clear"></div>
</div>