<?php

/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.2.0
 */

defined('ABSPATH') || exit;

global $product;

if (!$product->is_purchasable()) {
	return;
}

echo wc_get_stock_html($product); // WPCS: XSS ok.

if ($product->is_in_stock()): ?>

	<?php lamkadeh_show_special_stock_status(); ?>
	<div class="underline-lamkadeh">
		<div class="underline-lamkadeh-line"></div>
		<div class="underline-lamkadeh-circle"></div>
	</div>

	<?php do_action('woocommerce_before_add_to_cart_form'); ?>

	<form class="cart"
		action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
		method="post" enctype='multipart/form-data'>
		<?php do_action('woocommerce_before_add_to_cart_button'); ?>

		<?php
		do_action('woocommerce_before_add_to_cart_quantity');

		/*woocommerce_quantity_input(
			array(
				'min_value' => $product->get_min_purchase_quantity(),
				'max_value' => $product->get_max_purchase_quantity(),
				'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
			)
		);*/

		do_action('woocommerce_after_add_to_cart_quantity');
		?>
		<section class="add-to-cart-lamkadeh">
			<button type="submit" name="add-to-cart" class="btn-add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>">
				<div class="add-to-cart-right">
					<span><?php echo esc_html($product->single_add_to_cart_text()); ?></span>
				</div>
				<div class="add-to-cart-left">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M11.9996 2.75C10.7569 2.75 9.74958 3.75736 9.74958 5V5.25447C10.1671 5.24999 10.6178 5.25 11.1048 5.25H12.8943C13.3814 5.25 13.8321 5.24999 14.2496 5.25447V5C14.2496 3.75736 13.2422 2.75 11.9996 2.75ZM15.7496 5.30694V5C15.7496 2.92893 14.0706 1.25 11.9996 1.25C9.92851 1.25 8.24958 2.92893 8.24958 5V5.30694C8.11458 5.31679 7.9843 5.32834 7.85855 5.34189C6.98019 5.43657 6.24565 5.63489 5.59336 6.08197C5.36901 6.23574 5.15829 6.40849 4.96351 6.59833C4.39718 7.15027 4.05865 7.83166 3.79356 8.67439C3.53619 9.49258 3.32818 10.5327 3.0668 11.8396L3.04773 11.935C2.67109 13.8181 2.37429 15.302 2.28905 16.484C2.20195 17.6916 2.32366 18.7075 2.8957 19.588C3.08656 19.8817 3.30933 20.1534 3.55995 20.3982C4.31108 21.1318 5.28343 21.4504 6.48469 21.6018C7.66038 21.75 9.17369 21.75 11.0941 21.75H12.905C14.8255 21.75 16.3388 21.75 17.5145 21.6018C18.7157 21.4504 19.6881 21.1318 20.4392 20.3982C20.6898 20.1534 20.9126 19.8817 21.1035 19.588C21.6755 18.7075 21.7972 17.6916 21.7101 16.484C21.6249 15.3021 21.3281 13.8182 20.9514 11.9351L20.9324 11.8396C20.671 10.5327 20.463 9.49259 20.2056 8.67439C19.9405 7.83166 19.602 7.15027 19.0356 6.59833C18.8409 6.40849 18.6301 6.23574 18.4058 6.08197C17.7535 5.63489 17.019 5.43657 16.1406 5.34189C16.0148 5.32834 15.8846 5.31679 15.7496 5.30694ZM8.01929 6.83326C7.27258 6.91374 6.81128 7.06572 6.44139 7.31924C6.28789 7.42445 6.14371 7.54265 6.01044 7.67254C5.6893 7.98552 5.4498 8.40807 5.22444 9.12449C4.99414 9.85661 4.80098 10.8172 4.52919 12.1762C4.13964 14.1239 3.86281 15.5153 3.78516 16.5919C3.70858 17.6538 3.83789 18.2849 4.15352 18.7707C4.28411 18.9717 4.43653 19.1576 4.608 19.3251C5.02245 19.7298 5.61597 19.9804 6.6723 20.1136C7.74319 20.2486 9.16181 20.25 11.1481 20.25H12.851C14.8373 20.25 16.256 20.2486 17.3269 20.1136C18.3832 19.9804 18.9767 19.7298 19.3911 19.3251C19.5626 19.1576 19.715 18.9717 19.8456 18.7707C20.1613 18.2849 20.2906 17.6538 20.214 16.5919C20.1363 15.5153 19.8595 14.1239 19.47 12.1762C19.1982 10.8173 19.005 9.85661 18.7747 9.12449C18.5494 8.40807 18.3099 7.98552 17.9887 7.67254C17.8554 7.54265 17.7113 7.42445 17.5578 7.31924C17.1879 7.06572 16.7266 6.91374 15.9799 6.83326C15.2168 6.75101 14.2369 6.75 12.851 6.75H11.1481C9.76223 6.75 8.78236 6.75101 8.01929 6.83326ZM8.92054 14.2929C9.31108 14.1548 9.73957 14.3595 9.8776 14.7501C10.1868 15.625 11.0213 16.25 11.9998 16.25C12.9783 16.25 13.8127 15.625 14.1219 14.7501C14.26 14.3595 14.6885 14.1548 15.079 14.2929C15.4695 14.4309 15.6742 14.8594 15.5362 15.2499C15.0218 16.7054 13.6337 17.75 11.9998 17.75C10.3658 17.75 8.97778 16.7054 8.46334 15.2499C8.32531 14.8594 8.53 14.4309 8.92054 14.2929Z"
							fill="white" />
					</svg>
				</div>
			</button>
			<div class="share-and-add-wishlist-lamkadeh">
				<div class="share-btn shareProductBtn">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M16.5 2.25C14.7051 2.25 13.25 3.70507 13.25 5.5C13.25 5.69591 13.2673 5.88776 13.3006 6.07412L8.56991 9.38558C8.54587 9.4024 8.52312 9.42038 8.50168 9.43939C7.94993 9.00747 7.25503 8.75 6.5 8.75C4.70507 8.75 3.25 10.2051 3.25 12C3.25 13.7949 4.70507 15.25 6.5 15.25C7.25503 15.25 7.94993 14.9925 8.50168 14.5606C8.52312 14.5796 8.54587 14.5976 8.56991 14.6144L13.3006 17.9259C13.2673 18.1122 13.25 18.3041 13.25 18.5C13.25 20.2949 14.7051 21.75 16.5 21.75C18.2949 21.75 19.75 20.2949 19.75 18.5C19.75 16.7051 18.2949 15.25 16.5 15.25C15.4472 15.25 14.5113 15.7506 13.9174 16.5267L9.43806 13.3911C9.63809 12.9694 9.75 12.4978 9.75 12C9.75 11.5022 9.63809 11.0306 9.43806 10.6089L13.9174 7.4733C14.5113 8.24942 15.4472 8.75 16.5 8.75C18.2949 8.75 19.75 7.29493 19.75 5.5C19.75 3.70507 18.2949 2.25 16.5 2.25ZM14.75 5.5C14.75 4.5335 15.5335 3.75 16.5 3.75C17.4665 3.75 18.25 4.5335 18.25 5.5C18.25 6.4665 17.4665 7.25 16.5 7.25C15.5335 7.25 14.75 6.4665 14.75 5.5ZM6.5 10.25C5.5335 10.25 4.75 11.0335 4.75 12C4.75 12.9665 5.5335 13.75 6.5 13.75C7.4665 13.75 8.25 12.9665 8.25 12C8.25 11.0335 7.4665 10.25 6.5 10.25ZM16.5 16.75C15.5335 16.75 14.75 17.5335 14.75 18.5C14.75 19.4665 15.5335 20.25 16.5 20.25C17.4665 20.25 18.25 19.4665 18.25 18.5C18.25 17.5335 17.4665 16.75 16.5 16.75Z" fill="#1D2977" />
					</svg>
				</div>
				<?php
				if (is_user_logged_in()) :
					$user_id = get_current_user_id();
					$wishlist = get_user_meta($user_id, 'lamkadeh_wishlist', true);
					$is_favorite = is_array($wishlist) && in_array($product->get_id(), $wishlist);
				?>
					<div
						class="lamkadeh-wishlist-btn wishlist-btn <?php echo $is_favorite ? 'active' : ''; ?>"
						data-product-id="<?php echo esc_attr($product->get_id()); ?>">
						<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
							<rect width="56" height="56" rx="28" fill="#F7F8FD" />
							<path fill-rule="evenodd" clip-rule="evenodd" d="M21.6244 20.4242C19.9654 21.1826 18.75 22.9863 18.75 25.1371C18.75 27.3345 19.6492 29.0283 20.9383 30.4798C22.0007 31.6761 23.2868 32.6677 24.5411 33.6346C24.839 33.8643 25.1351 34.0926 25.426 34.3219C25.9521 34.7366 26.4213 35.1006 26.8736 35.3649C27.3261 35.6293 27.6904 35.75 28 35.75C28.3096 35.75 28.6739 35.6293 29.1264 35.3649C29.5787 35.1006 30.0479 34.7366 30.574 34.3219C30.8649 34.0926 31.161 33.8643 31.4589 33.6346C32.7132 32.6677 33.9993 31.6761 35.0617 30.4798C36.3508 29.0283 37.25 27.3345 37.25 25.1371C37.25 22.9863 36.0346 21.1826 34.3756 20.4242C32.7639 19.6875 30.5983 19.8826 28.5404 22.0208C28.399 22.1677 28.2039 22.2507 28 22.2507C27.7961 22.2507 27.601 22.1677 27.4596 22.0208C25.4017 19.8826 23.2361 19.6875 21.6244 20.4242ZM28 20.4588C25.6879 18.3903 23.099 18.1009 21.0008 19.06C18.7847 20.073 17.25 22.4251 17.25 25.1371C17.25 27.8027 18.3605 29.8361 19.8167 31.4758C20.9829 32.789 22.4102 33.888 23.6708 34.8586C23.9566 35.0786 24.2338 35.2921 24.4974 35.4999C25.0097 35.9037 25.5595 36.3343 26.1168 36.66C26.6739 36.9855 27.3096 37.25 28 37.25C28.6904 37.25 29.3261 36.9855 29.8832 36.66C30.4405 36.3343 30.9903 35.9037 31.5026 35.4999C31.7662 35.2921 32.0434 35.0786 32.3292 34.8586C33.5898 33.888 35.0171 32.789 36.1833 31.4758C37.6395 29.8361 38.75 27.8027 38.75 25.1371C38.75 22.4251 37.2153 20.073 34.9992 19.06C32.901 18.1009 30.3121 18.3903 28 20.4588Z" fill="#1D2977" />
						</svg>
					</div>
				<?php else : ?>
					<div class="wishlist-btn lamkadeh-wishlist-login" onclick="loginBeforeWhishlist()">
						<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
							<rect width="56" height="56" rx="28" fill="#F7F8FD" />
							<path fill-rule="evenodd" clip-rule="evenodd" d="M21.6244 20.4242C19.9654 21.1826 18.75 22.9863 18.75 25.1371C18.75 27.3345 19.6492 29.0283 20.9383 30.4798C22.0007 31.6761 23.2868 32.6677 24.5411 33.6346C24.839 33.8643 25.1351 34.0926 25.426 34.3219C25.9521 34.7366 26.4213 35.1006 26.8736 35.3649C27.3261 35.6293 27.6904 35.75 28 35.75C28.3096 35.75 28.6739 35.6293 29.1264 35.3649C29.5787 35.1006 30.0479 34.7366 30.574 34.3219C30.8649 34.0926 31.161 33.8643 31.4589 33.6346C32.7132 32.6677 33.9993 31.6761 35.0617 30.4798C36.3508 29.0283 37.25 27.3345 37.25 25.1371C37.25 22.9863 36.0346 21.1826 34.3756 20.4242C32.7639 19.6875 30.5983 19.8826 28.5404 22.0208C28.399 22.1677 28.2039 22.2507 28 22.2507C27.7961 22.2507 27.601 22.1677 27.4596 22.0208C25.4017 19.8826 23.2361 19.6875 21.6244 20.4242ZM28 20.4588C25.6879 18.3903 23.099 18.1009 21.0008 19.06C18.7847 20.073 17.25 22.4251 17.25 25.1371C17.25 27.8027 18.3605 29.8361 19.8167 31.4758C20.9829 32.789 22.4102 33.888 23.6708 34.8586C23.9566 35.0786 24.2338 35.2921 24.4974 35.4999C25.0097 35.9037 25.5595 36.3343 26.1168 36.66C26.6739 36.9855 27.3096 37.25 28 37.25C28.6904 37.25 29.3261 36.9855 29.8832 36.66C30.4405 36.3343 30.9903 35.9037 31.5026 35.4999C31.7662 35.2921 32.0434 35.0786 32.3292 34.8586C33.5898 33.888 35.0171 32.789 36.1833 31.4758C37.6395 29.8361 38.75 27.8027 38.75 25.1371C38.75 22.4251 37.2153 20.073 34.9992 19.06C32.901 18.1009 30.3121 18.3903 28 20.4588Z" fill="#1D2977" />
						</svg>
					</div>
				<?php endif; ?>
			</div>
		</section>

		<?php do_action('woocommerce_after_add_to_cart_button'); ?>
	</form>

	<?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>