<?php

/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.8.0
 */

defined('ABSPATH') || exit;

if (!function_exists('wc_get_gallery_image_html')) return;

global $product;
if (!$product || !$product instanceof WC_Product) return '';

$attachment_ids = $product->get_gallery_image_ids();
$main_image_id  = $product->get_image_id();

if (!$main_image_id && empty($attachment_ids)) {
	return;
}

$all_images = array_merge([$main_image_id], $attachment_ids);

$total_images = $total_images ?? 0;
?>

<div class="swiper gallery-woocommerce-slider">
	<div class="swiper-wrapper">
		<?php foreach ($all_images as $key => $attachment_id):
			if (!$attachment_id) continue;
			$image_full_url = wp_get_attachment_image_url($attachment_id, 'full');
		?>
			<div class="swiper-slide <?php echo $key === 0 ? 'active' : ''; ?>" data-full="<?php echo esc_url($image_full_url); ?>">
				<div class="swiper-slide-shape">
					<div class="swiper-slide-shape-circle"></div>
					<div class="swiper-slide-shape-circle-dashed"></div>
				</div>
				<?php echo wp_get_attachment_image($attachment_id, 'woocommerce_single'); ?>
			</div>
		<?php endforeach; ?>
	</div>
	<div class="pagination-gallery-woocommerce-slider">
		<span class="pagination-gallery-woocommerce-slider-current">1</span>
		<div class="pagination-gallery-woocommerce-slider-progressbar">
			<div style="width: 0%;"></div>
		</div>
		<span class="pagination-gallery-woocommerce-slider-total"><?php echo $total_images; ?></span>
	</div>
	<div class="gallery-woocommerce-slider-next-btn">
		<svg width="32" height="20" viewBox="0 0 32 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M28.6668 10L29.1972 10.5303C29.4901 10.2374 29.4901 9.76256 29.1972 9.46967L28.6668 10ZM24.1972 4.46967C23.9043 4.17678 23.4294 4.17678 23.1365 4.46967C22.8436 4.76256 22.8436 5.23744 23.1365 5.53033L24.1972 4.46967ZM23.1365 14.4697C22.8436 14.7626 22.8436 15.2374 23.1365 15.5303C23.4294 15.8232 23.9043 15.8232 24.1972 15.5303L23.1365 14.4697ZM0 10V10.75H28.6668V10V9.25H0V10ZM28.6668 10L29.1972 9.46967L24.1972 4.46967L23.6668 5L23.1365 5.53033L28.1365 10.5303L28.6668 10ZM28.6668 10L28.1365 9.46967L23.1365 14.4697L23.6668 15L24.1972 15.5303L29.1972 10.5303L28.6668 10Z" fill="white" />
		</svg>
	</div>
	<div class="gallery-woocommerce-slider-prev-btn">
		<svg width="32" height="20" viewBox="0 0 32 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.33317 10L2.80284 10.5303C2.50995 10.2374 2.50995 9.76256 2.80284 9.46967L3.33317 10ZM7.80284 4.46967C8.09574 4.17678 8.57061 4.17678 8.8635 4.46967C9.15639 4.76256 9.15639 5.23744 8.8635 5.53033L7.80284 4.46967ZM8.8635 14.4697C9.15639 14.7626 9.15639 15.2374 8.8635 15.5303C8.57061 15.8232 8.09574 15.8232 7.80284 15.5303L8.8635 14.4697ZM32 10V10.75H3.33317V10V9.25H32V10ZM3.33317 10L2.80284 9.46967L7.80284 4.46967L8.33317 5L8.8635 5.53033L3.8635 10.5303L3.33317 10ZM3.33317 10L3.8635 9.46967L8.8635 14.4697L8.33317 15L7.80284 15.5303L2.80284 10.5303L3.33317 10Z" fill="white" />
		</svg>
	</div>
</div>

<script>
	document.addEventListener('DOMContentLoaded', function() {
		const gallerySliderEl = document.querySelector('.gallery-woocommerce-slider');
		const currentEl = document.querySelector('.pagination-gallery-woocommerce-slider-current');
		const totalEl = document.querySelector('.pagination-gallery-woocommerce-slider-total');
		const progressEl = document.querySelector('.pagination-gallery-woocommerce-slider-progressbar div');

		if (!gallerySliderEl || typeof Swiper === 'undefined') return;

		const slides = gallerySliderEl.querySelectorAll('.swiper-slide');
		const mainImage = document.querySelector('.woocommerce-product-gallery__image img') || document.querySelector('.wp-post-image');

		// مقدار کل تصاویر
		const total = slides.length;
		if (totalEl) totalEl.textContent = total;

		// ساخت اسلایدر
		const swiper = new Swiper(gallerySliderEl, {
			navigation: {
				nextEl: '.gallery-woocommerce-slider .gallery-woocommerce-slider-next-btn',
				prevEl: '.gallery-woocommerce-slider .gallery-woocommerce-slider-prev-btn',
			},
			slidesPerView: 3,
			spaceBetween: 45,
			loop: true,
			breakpoints: {
				320: {
					slidesPerView: 1,
					spaceBetween: 25
				},
				768: {
					slidesPerView: 2,
					spaceBetween: 30
				},
				1024: {
					slidesPerView: 3,
					spaceBetween: 35
				}
			}
		});

		// تابع برای بروزرسانی pagination
		function updatePagination(activeIndex) {
			if (!currentEl || !progressEl) return;
			currentEl.textContent = activeIndex + 1; // چون index از 0 شروع میشه
			const percent = ((activeIndex + 1) / total) * 100;
			progressEl.style.width = percent + '%';
		}

		// وقتی روی یک اسلاید کلیک می‌کنیم
		gallerySliderEl.addEventListener('click', function(e) {
			const slide = e.target.closest('.swiper-slide');
			if (!slide) return;

			// حذف active از بقیه و افزودن به این
			gallerySliderEl.querySelectorAll('.swiper-slide').forEach(s => s.classList.remove('active'));
			slide.classList.add('active');

			// به‌روزرسانی تصویر اصلی
			const fullImg = slide.dataset.full;
			if (fullImg && mainImage) {
				mainImage.src = fullImg;
				mainImage.srcset = fullImg;
				mainImage.dataset.large_image = fullImg;

				if (typeof wc_single_product_gallery !== 'undefined' && wc_single_product_gallery.init_zoom) {
					jQuery(mainImage).trigger('zoom.destroy');
					jQuery(mainImage).attr('data-large_image', fullImg);
					jQuery(mainImage).attr('data-large_image_width', 1000);
					jQuery(mainImage).attr('data-large_image_height', 1000);
					jQuery(mainImage).parent().attr('href', fullImg);
					jQuery(mainImage).trigger('zoom.init');
				}
			}

			// محاسبه شماره اسلاید فعال
			const realSlides = Array.from(gallerySliderEl.querySelectorAll('.swiper-slide:not(.swiper-slide-duplicate)'));
			const activeIndex = realSlides.indexOf(slide);
			if (activeIndex >= 0) {
				updatePagination(activeIndex);
			}
		});

		// مقدار اولیه (اولین اسلاید)
		const firstActive = gallerySliderEl.querySelector('.swiper-slide.active');
		if (firstActive) {
			const realSlides = Array.from(gallerySliderEl.querySelectorAll('.swiper-slide:not(.swiper-slide-duplicate)'));
			const initialIndex = realSlides.indexOf(firstActive);
			if (initialIndex >= 0) updatePagination(initialIndex);
		}
	});
</script>