<?php

/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     10.3.0
 */

if (! defined('ABSPATH')) {
	exit;
}

if ($related_products) :
?>
	<section class="product-archive container">
		<section class="header-categories-main">
			<div class="title-header-categories-main">
				<span>SIMILAR PRODUCTS</span>
				<div class="text-header-categories-main">
					<span><?php echo __("محصولات مشابــــــــــه", "lamkadeh") ?></span>
					<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_1_3057)">
							<circle cx="32" cy="32" r="32" transform="matrix(-1 0 0 1 64 0)" fill="#FFD701" />
							<path fill-rule="evenodd" clip-rule="evenodd"
								d="M37.2878 12.1459C37.3151 12.1459 37.3428 12.1459 37.3708 12.1459L37.4047 12.1459C37.7268 12.1459 37.9341 12.1459 38.1368 12.1648C38.9635 12.2421 39.7499 12.5541 40.4039 13.0626H46.1252C46.1431 13.0626 46.1608 13.0626 46.1782 13.0626C46.5528 13.0625 46.808 13.0624 47.0322 13.092C48.5747 13.295 49.7885 14.5089 49.9916 16.0514C49.9993 16.1095 50.0049 16.1697 50.0091 16.2336C50.2635 16.3495 50.499 16.4994 50.7156 16.6942C50.8057 16.7753 50.8916 16.8611 50.9727 16.9513C51.4569 17.4897 51.6638 18.1451 51.7608 18.9164C51.8544 19.6606 51.8544 20.6013 51.8543 21.7681V23.8851C51.8544 25.5697 51.8544 26.904 51.714 27.9483C51.5695 29.023 51.265 29.8929 50.579 30.5789C49.893 31.2649 49.0232 31.5694 47.9485 31.7139C46.9042 31.8542 45.5698 31.8542 43.8852 31.8542H40.1151C38.4305 31.8542 37.0962 31.8542 36.0519 31.7139C34.9772 31.5694 34.1073 31.2649 33.4213 30.5789C32.7353 29.8929 32.4309 29.023 32.2864 27.9483C32.146 26.904 32.146 25.5697 32.146 23.8851L32.146 17.3707C32.146 17.3426 32.146 17.315 32.146 17.2877C32.1459 16.5581 32.1458 16.0938 32.2215 15.6928C32.5538 13.9314 33.9316 12.5537 35.6929 12.2214C36.0939 12.1457 36.5583 12.1458 37.2878 12.1459ZM48.5519 15.8838C48.3155 15.1277 47.659 14.5613 46.8527 14.4552C46.73 14.439 46.5727 14.4376 46.1252 14.4376H41.8272C42.4165 15.0234 42.6839 15.268 42.9872 15.4368C43.187 15.5479 43.399 15.6357 43.619 15.6984C43.9978 15.8064 44.4132 15.8126 45.5096 15.8126L45.8988 15.8126C46.9642 15.8125 47.841 15.8125 48.5519 15.8838ZM37.3708 13.5209C36.5305 13.5209 36.2057 13.5239 35.9478 13.5725C34.7427 13.7999 33.8 14.7426 33.5727 15.9477C33.524 16.2055 33.521 16.5304 33.521 17.3707V23.8334C33.521 25.5813 33.5225 26.8231 33.6491 27.7651C33.7731 28.6874 34.0056 29.2187 34.3936 29.6066C34.7815 29.9946 35.3129 30.2271 36.2351 30.3511C37.1771 30.4778 38.4189 30.4792 40.1668 30.4792H43.8335C45.5814 30.4792 46.8232 30.4778 47.7652 30.3511C48.6875 30.2271 49.2188 29.9946 49.6068 29.6066C49.9947 29.2187 50.2272 28.6874 50.3512 27.7651C50.4779 26.8231 50.4793 25.5813 50.4793 23.8334V21.8148C50.4793 20.5903 50.4781 19.7363 50.3965 19.0879C50.3172 18.4566 50.1714 18.1166 49.9503 17.8708C49.9017 17.8167 49.8502 17.7652 49.7961 17.7166C49.5503 17.4955 49.2103 17.3497 48.579 17.2704C47.9306 17.1888 47.0766 17.1876 45.8521 17.1876H45.5096C45.4755 17.1876 45.4418 17.1876 45.4085 17.1876C44.4479 17.1878 43.8284 17.1879 43.242 17.0208C42.9206 16.9291 42.6108 16.8008 42.3187 16.6383C41.7859 16.3419 41.348 15.9037 40.6688 15.2243C40.6453 15.2008 40.6215 15.177 40.5974 15.1529L40.093 14.6485C39.8333 14.3888 39.734 14.2904 39.6327 14.2065C39.1714 13.824 38.6054 13.5896 38.0088 13.5338C37.8778 13.5216 37.738 13.5209 37.3708 13.5209ZM42.2293 20.1667C42.2293 19.787 42.5371 19.4792 42.9168 19.4792H47.5002C47.8799 19.4792 48.1877 19.787 48.1877 20.1667C48.1877 20.5464 47.8799 20.8542 47.5002 20.8542H42.9168C42.5371 20.8542 42.2293 20.5464 42.2293 20.1667Z"
								fill="#1D2977" />
							<circle cx="22" cy="60" r="17" fill="#F7F8FD" fill-opacity="0.64" />
						</g>
						<defs>
							<clipPath id="clip0_1_3057">
								<rect width="64" height="64" rx="32" fill="white" />
							</clipPath>
						</defs>
					</svg>
				</div>
				<div class="shape-header-categories-main"></div>
			</div>
			<div class="line-header-categories-main"></div>
			<p class="description-header-categories-main">
				<?php echo __("اینجا محصولاتی رو می‌بینی که <strong>رضایـــــــــت مشتریانمون</strong> رو جلب کردن، این لیست می‌تونه <strong>بهترین راهنمایت</strong> باشه!", "lamkadeh") ?>
			</p>
			<div class="line-header-categories-main-two"></div>
			<a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="show-more-header-categories-main">
				<div>
					<span><?php echo __("همه محصولات", "lamkadeh") ?></span>
				</div>
				<div>
					<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path
							d="M23.6216 13.6066C23.4648 13.7633 23.2504 13.8623 23.0029 13.8623L13.8623 13.8623L13.8623 23.0029C13.8623 23.4813 13.4664 23.8773 12.9879 23.8773C12.5094 23.8773 12.1134 23.4813 12.1134 23.0029L12.1134 12.9879C12.1134 12.5094 12.5094 12.1134 12.9879 12.1134L23.0029 12.1134C23.4813 12.1134 23.8773 12.5094 23.8773 12.9879C23.8856 13.2271 23.7783 13.4498 23.6216 13.6066Z"
							fill="white" />
						<path
							d="M27.6308 27.6308C27.2926 27.969 26.7316 27.969 26.3934 27.6308L12.5093 13.7468C12.1711 13.4085 12.1711 12.8476 12.5093 12.5093C12.8476 12.1711 13.4085 12.1711 13.7468 12.5093L27.6308 26.3934C27.9691 26.7316 27.9691 27.2926 27.6308 27.6308Z"
							fill="white" />
					</svg>
				</div>
			</a>
		</section>
		<section class="product-archive-content">
			<div class="product-archive-content-items">
				<?php
				foreach (array_slice($related_products, 0, 4) as $related_product) :
					$post_object = get_post($related_product->get_id());
					setup_postdata($GLOBALS['post'] = $post_object);
					wc_get_template_part('content', 'product');
				endforeach;
				wp_reset_postdata();
				?>
			</div>
			<div class="product-archive-content-items">
				<?php
				foreach (array_slice($related_products, 4, 4) as $related_product) :
					$post_object = get_post($related_product->get_id());
					setup_postdata($GLOBALS['post'] = $post_object);
					wc_get_template_part('content', 'product');
				endforeach;
				wp_reset_postdata();
				?>
			</div>

			<svg class="svg-two" width="99" height="47" viewBox="0 0 99 47" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M22.5 -5.51282C20.0147 -5.51282 18 -7.4598 18 -9.86153C18 -12.2633 20.0147 -14.2103 22.5 -14.2103C24.9853 -14.2103 27 -12.2633 27 -9.86153C27 -7.4598 24.9853 -5.51282 22.5 -5.51282Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M58.5 -5.51282C56.0147 -5.51282 54 -7.45981 54 -9.86154C54 -12.2633 56.0147 -14.2103 58.5 -14.2103C60.9853 -14.2103 63 -12.2633 63 -9.86154C63 -7.45981 60.9853 -5.51282 58.5 -5.51282Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M76.5 -5.51282C74.0147 -5.51282 72 -7.45981 72 -9.86154C72 -12.2633 74.0147 -14.2103 76.5 -14.2103C78.9853 -14.2103 81 -12.2633 81 -9.86154C81 -7.45981 78.9853 -5.51282 76.5 -5.51282Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M4.5 -22.9077C2.01472 -22.9077 8.84815e-07 -24.8547 7.77469e-07 -27.2564C6.70123e-07 -29.6581 2.01472 -31.6051 4.5 -31.6051C6.98528 -31.6051 9 -29.6581 9 -27.2564C9 -24.8547 6.98528 -22.9077 4.5 -22.9077Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M22.5 -22.9077C20.0147 -22.9077 18 -24.8547 18 -27.2564C18 -29.6581 20.0147 -31.6051 22.5 -31.6051C24.9853 -31.6051 27 -29.6581 27 -27.2564C27 -24.8547 24.9853 -22.9077 22.5 -22.9077Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M40.5 -22.9077C38.0147 -22.9077 36 -24.8547 36 -27.2564C36 -29.6581 38.0147 -31.6051 40.5 -31.6051C42.9853 -31.6051 45 -29.6581 45 -27.2564C45 -24.8547 42.9853 -22.9077 40.5 -22.9077Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M76.5 -22.9077C74.0147 -22.9077 72 -24.8547 72 -27.2564C72 -29.6581 74.0147 -31.6051 76.5 -31.6051C78.9853 -31.6051 81 -29.6581 81 -27.2564C81 -24.8547 78.9853 -22.9077 76.5 -22.9077Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M94.5 -22.9077C92.0147 -22.9077 90 -24.8547 90 -27.2564C90 -29.6581 92.0147 -31.6051 94.5 -31.6051C96.9853 -31.6051 99 -29.6581 99 -27.2564C99 -24.8547 96.9853 -22.9077 94.5 -22.9077Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M4.5 -40.3026C2.01472 -40.3026 1.07346e-07 -42.2495 0 -44.6513C-1.07346e-07 -47.053 2.01472 -49 4.5 -49C6.98528 -49 9 -47.053 9 -44.6513C9 -42.2495 6.98528 -40.3026 4.5 -40.3026Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M40.5 -40.3026C38.0147 -40.3026 36 -42.2496 36 -44.6513C36 -47.053 38.0147 -49 40.5 -49C42.9853 -49 45 -47.053 45 -44.6513C45 -42.2496 42.9853 -40.3026 40.5 -40.3026Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M58.5 -40.3026C56.0147 -40.3026 54 -42.2496 54 -44.6513C54 -47.053 56.0147 -49 58.5 -49C60.9853 -49 63 -47.053 63 -44.6513C63 -42.2496 60.9853 -40.3026 58.5 -40.3026Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M76.5 -40.3026C74.0147 -40.3026 72 -42.2496 72 -44.6513C72 -47.053 74.0147 -49 76.5 -49C78.9853 -49 81 -47.053 81 -44.6513C81 -42.2496 78.9853 -40.3026 76.5 -40.3026Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M94.5 -40.3026C92.0147 -40.3026 90 -42.2496 90 -44.6513C90 -47.053 92.0147 -49 94.5 -49C96.9853 -49 99 -47.053 99 -44.6513C99 -42.2496 96.9853 -40.3026 94.5 -40.3026Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M58.5 -22.9077C56.0147 -22.9077 54 -24.8547 54 -27.2564C54 -29.6581 56.0147 -31.6051 58.5 -31.6051C60.9853 -31.6051 63 -29.6581 63 -27.2564C63 -24.8547 60.9853 -22.9077 58.5 -22.9077Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M22.5 -40.3026C20.0147 -40.3026 18 -42.2495 18 -44.6513C18 -47.053 20.0147 -49 22.5 -49C24.9853 -49 27 -47.053 27 -44.6513C27 -42.2495 24.9853 -40.3026 22.5 -40.3026Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M40.5 -5.51282C38.0147 -5.51282 36 -7.4598 36 -9.86153C36 -12.2633 38.0147 -14.2103 40.5 -14.2103C42.9853 -14.2103 45 -12.2633 45 -9.86153C45 -7.4598 42.9853 -5.51282 40.5 -5.51282Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M94.5 -5.51282C92.0147 -5.51282 90 -7.45981 90 -9.86154C90 -12.2633 92.0147 -14.2103 94.5 -14.2103C96.9853 -14.2103 99 -12.2633 99 -9.86154C99 -7.45981 96.9853 -5.51282 94.5 -5.51282Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M4.5 -5.51282C2.01472 -5.51282 1.66229e-06 -7.4598 1.55494e-06 -9.86153C1.44759e-06 -12.2633 2.01472 -14.2103 4.5 -14.2103C6.98528 -14.2103 9 -12.2633 9 -9.86153C9 -7.4598 6.98528 -5.51282 4.5 -5.51282Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M22.5 47C20.0147 47 18 45.053 18 42.6513C18 40.2496 20.0147 38.3026 22.5 38.3026C24.9853 38.3026 27 40.2496 27 42.6513C27 45.053 24.9853 47 22.5 47Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M58.5 47C56.0147 47 54 45.053 54 42.6513C54 40.2496 56.0147 38.3026 58.5 38.3026C60.9853 38.3026 63 40.2496 63 42.6513C63 45.053 60.9853 47 58.5 47Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M76.5 47C74.0147 47 72 45.053 72 42.6513C72 40.2496 74.0147 38.3026 76.5 38.3026C78.9853 38.3026 81 40.2496 81 42.6513C81 45.053 78.9853 47 76.5 47Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M4.5 29.6051C2.01472 29.6051 8.84815e-07 27.6581 7.77469e-07 25.2564C6.70123e-07 22.8547 2.01472 20.9077 4.5 20.9077C6.98528 20.9077 9 22.8547 9 25.2564C9 27.6581 6.98528 29.6051 4.5 29.6051Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M22.5 29.6051C20.0147 29.6051 18 27.6581 18 25.2564C18 22.8547 20.0147 20.9077 22.5 20.9077C24.9853 20.9077 27 22.8547 27 25.2564C27 27.6581 24.9853 29.6051 22.5 29.6051Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M40.5 29.6051C38.0147 29.6051 36 27.6581 36 25.2564C36 22.8547 38.0147 20.9077 40.5 20.9077C42.9853 20.9077 45 22.8547 45 25.2564C45 27.6581 42.9853 29.6051 40.5 29.6051Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M76.5 29.6051C74.0147 29.6051 72 27.6581 72 25.2564C72 22.8547 74.0147 20.9077 76.5 20.9077C78.9853 20.9077 81 22.8547 81 25.2564C81 27.6581 78.9853 29.6051 76.5 29.6051Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M94.5 29.6051C92.0147 29.6051 90 27.6581 90 25.2564C90 22.8547 92.0147 20.9077 94.5 20.9077C96.9853 20.9077 99 22.8547 99 25.2564C99 27.6581 96.9853 29.6051 94.5 29.6051Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M4.5 12.2103C2.01472 12.2103 1.07346e-07 10.2633 0 7.86154C-1.07346e-07 5.45981 2.01472 3.51283 4.5 3.51283C6.98528 3.51283 9 5.45981 9 7.86154C9 10.2633 6.98528 12.2103 4.5 12.2103Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M40.5 12.2103C38.0147 12.2103 36 10.2633 36 7.86154C36 5.45981 38.0147 3.51283 40.5 3.51283C42.9853 3.51282 45 5.45981 45 7.86154C45 10.2633 42.9853 12.2103 40.5 12.2103Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M58.5 12.2103C56.0147 12.2103 54 10.2633 54 7.86154C54 5.45981 56.0147 3.51283 58.5 3.51283C60.9853 3.51282 63 5.45981 63 7.86154C63 10.2633 60.9853 12.2103 58.5 12.2103Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M76.5 12.2103C74.0147 12.2103 72 10.2633 72 7.86154C72 5.45981 74.0147 3.51283 76.5 3.51283C78.9853 3.51282 81 5.45981 81 7.86154C81 10.2633 78.9853 12.2103 76.5 12.2103Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M94.5 12.2103C92.0147 12.2103 90 10.2633 90 7.86154C90 5.45981 92.0147 3.51283 94.5 3.51283C96.9853 3.51282 99 5.45981 99 7.86154C99 10.2633 96.9853 12.2103 94.5 12.2103Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M58.5 29.6051C56.0147 29.6051 54 27.6581 54 25.2564C54 22.8547 56.0147 20.9077 58.5 20.9077C60.9853 20.9077 63 22.8547 63 25.2564C63 27.6581 60.9853 29.6051 58.5 29.6051Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M22.5 12.2103C20.0147 12.2103 18 10.2633 18 7.86154C18 5.45981 20.0147 3.51283 22.5 3.51283C24.9853 3.51282 27 5.45981 27 7.86154C27 10.2633 24.9853 12.2103 22.5 12.2103Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M40.5 47C38.0147 47 36 45.053 36 42.6513C36 40.2496 38.0147 38.3026 40.5 38.3026C42.9853 38.3026 45 40.2496 45 42.6513C45 45.053 42.9853 47 40.5 47Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M94.5 47C92.0147 47 90 45.053 90 42.6513C90 40.2496 92.0147 38.3026 94.5 38.3026C96.9853 38.3026 99 40.2496 99 42.6513C99 45.053 96.9853 47 94.5 47Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M4.5 47C2.01472 47 1.66229e-06 45.053 1.55494e-06 42.6513C1.44759e-06 40.2496 2.01472 38.3026 4.5 38.3026C6.98528 38.3026 9 40.2496 9 42.6513C9 45.053 6.98528 47 4.5 47Z" fill="#1D2977" fill-opacity="0.12" />
			</svg>

			<svg class="svg-one" width="125" height="105" viewBox="0 0 125 105" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M-11 77.4615C-15.4183 77.4615 -19 73.9935 -19 69.7154C-19 65.4373 -15.4183 61.9692 -11 61.9692C-6.58172 61.9692 -3 65.4373 -3 69.7154C-3 73.9935 -6.58172 77.4615 -11 77.4615Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M53 77.4615C48.5817 77.4615 45 73.9935 45 69.7154C45 65.4373 48.5817 61.9692 53 61.9692C57.4183 61.9692 61 65.4373 61 69.7154C61 73.9935 57.4183 77.4615 53 77.4615Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M85 77.4615C80.5817 77.4615 77 73.9935 77 69.7154C77 65.4373 80.5817 61.9692 85 61.9692C89.4183 61.9692 93 65.4373 93 69.7154C93 73.9935 89.4183 77.4615 85 77.4615Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-43 46.4769C-47.4183 46.4769 -51 43.0089 -51 38.7308C-51 34.4527 -47.4183 30.9846 -43 30.9846C-38.5817 30.9846 -35 34.4527 -35 38.7308C-35 43.0089 -38.5817 46.4769 -43 46.4769Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-11 46.4769C-15.4183 46.4769 -19 43.0089 -19 38.7308C-19 34.4527 -15.4183 30.9846 -11 30.9846C-6.58172 30.9846 -3 34.4527 -3 38.7308C-3 43.0089 -6.58172 46.4769 -11 46.4769Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M21 46.4769C16.5817 46.4769 13 43.0089 13 38.7308C13 34.4527 16.5817 30.9846 21 30.9846C25.4183 30.9846 29 34.4527 29 38.7308C29 43.0089 25.4183 46.4769 21 46.4769Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M85 46.4769C80.5817 46.4769 77 43.0089 77 38.7308C77 34.4527 80.5817 30.9846 85 30.9846C89.4183 30.9846 93 34.4527 93 38.7308C93 43.0089 89.4183 46.4769 85 46.4769Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M117 46.4769C112.582 46.4769 109 43.0089 109 38.7308C109 34.4527 112.582 30.9846 117 30.9846C121.418 30.9846 125 34.4527 125 38.7308C125 43.0089 121.418 46.4769 117 46.4769Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-43 15.4923C-47.4183 15.4923 -51 12.0242 -51 7.74616C-51 3.46808 -47.4183 7.04246e-06 -43 6.85321e-06C-38.5817 6.66397e-06 -35 3.46808 -35 7.74616C-35 12.0242 -38.5817 15.4923 -43 15.4923Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M21 15.4923C16.5817 15.4923 13 12.0242 13 7.74616C13 3.46807 16.5817 4.30117e-06 21 4.11193e-06C25.4183 3.92268e-06 29 3.46807 29 7.74616C29 12.0242 25.4183 15.4923 21 15.4923Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M53 15.4923C48.5817 15.4923 45 12.0242 45 7.74615C45 3.46807 48.5817 2.93053e-06 53 2.74129e-06C57.4183 2.55204e-06 61 3.46807 61 7.74615C61 12.0242 57.4183 15.4923 53 15.4923Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M85 15.4923C80.5817 15.4923 77 12.0242 77 7.74615C77 3.46807 80.5817 1.55989e-06 85 1.37064e-06C89.4183 1.1814e-06 93 3.46807 93 7.74615C93 12.0242 89.4183 15.4923 85 15.4923Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M117 15.4923C112.582 15.4923 109 12.0242 109 7.74615C109 3.46807 112.582 1.89246e-07 117 0C121.418 -1.89246e-07 125 3.46807 125 7.74615C125 12.0242 121.418 15.4923 117 15.4923Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M53 46.4769C48.5817 46.4769 45 43.0089 45 38.7308C45 34.4527 48.5817 30.9846 53 30.9846C57.4183 30.9846 61 34.4527 61 38.7308C61 43.0089 57.4183 46.4769 53 46.4769Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-11 15.4923C-15.4183 15.4923 -19 12.0242 -19 7.74616C-19 3.46807 -15.4183 5.67181e-06 -11 5.48257e-06C-6.58173 5.29332e-06 -3 3.46807 -3 7.74616C-3 12.0242 -6.58172 15.4923 -11 15.4923Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M21 77.4615C16.5817 77.4615 13 73.9935 13 69.7154C13 65.4373 16.5817 61.9692 21 61.9692C25.4183 61.9692 29 65.4373 29 69.7154C29 73.9935 25.4183 77.4615 21 77.4615Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M117 77.4615C112.582 77.4615 109 73.9935 109 69.7154C109 65.4373 112.582 61.9692 117 61.9692C121.418 61.9692 125 65.4373 125 69.7154C125 73.9935 121.418 77.4615 117 77.4615Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-43 77.4615C-47.4183 77.4615 -51 73.9935 -51 69.7154C-51 65.4373 -47.4183 61.9692 -43 61.9692C-38.5817 61.9692 -35 65.4373 -35 69.7154C-35 73.9935 -38.5817 77.4615 -43 77.4615Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-11 171C-15.4183 171 -19 167.532 -19 163.254C-19 158.976 -15.4183 155.508 -11 155.508C-6.58172 155.508 -3 158.976 -3 163.254C-3 167.532 -6.58172 171 -11 171Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M53 171C48.5817 171 45 167.532 45 163.254C45 158.976 48.5817 155.508 53 155.508C57.4183 155.508 61 158.976 61 163.254C61 167.532 57.4183 171 53 171Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M85 171C80.5817 171 77 167.532 77 163.254C77 158.976 80.5817 155.508 85 155.508C89.4183 155.508 93 158.976 93 163.254C93 167.532 89.4183 171 85 171Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-43 140.015C-47.4183 140.015 -51 136.547 -51 132.269C-51 127.991 -47.4183 124.523 -43 124.523C-38.5817 124.523 -35 127.991 -35 132.269C-35 136.547 -38.5817 140.015 -43 140.015Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-11 140.015C-15.4183 140.015 -19 136.547 -19 132.269C-19 127.991 -15.4183 124.523 -11 124.523C-6.58172 124.523 -3 127.991 -3 132.269C-3 136.547 -6.58172 140.015 -11 140.015Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M21 140.015C16.5817 140.015 13 136.547 13 132.269C13 127.991 16.5817 124.523 21 124.523C25.4183 124.523 29 127.991 29 132.269C29 136.547 25.4183 140.015 21 140.015Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M85 140.015C80.5817 140.015 77 136.547 77 132.269C77 127.991 80.5817 124.523 85 124.523C89.4183 124.523 93 127.991 93 132.269C93 136.547 89.4183 140.015 85 140.015Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M117 140.015C112.582 140.015 109 136.547 109 132.269C109 127.991 112.582 124.523 117 124.523C121.418 124.523 125 127.991 125 132.269C125 136.547 121.418 140.015 117 140.015Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-43 109.031C-47.4183 109.031 -51 105.563 -51 101.285C-51 97.0065 -47.4183 93.5385 -43 93.5385C-38.5817 93.5385 -35 97.0065 -35 101.285C-35 105.563 -38.5817 109.031 -43 109.031Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M21 109.031C16.5817 109.031 13 105.563 13 101.285C13 97.0065 16.5817 93.5385 21 93.5385C25.4183 93.5385 29 97.0065 29 101.285C29 105.563 25.4183 109.031 21 109.031Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M53 109.031C48.5817 109.031 45 105.563 45 101.285C45 97.0065 48.5817 93.5385 53 93.5385C57.4183 93.5385 61 97.0065 61 101.285C61 105.563 57.4183 109.031 53 109.031Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M85 109.031C80.5817 109.031 77 105.563 77 101.285C77 97.0065 80.5817 93.5385 85 93.5385C89.4183 93.5385 93 97.0065 93 101.285C93 105.563 89.4183 109.031 85 109.031Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M117 109.031C112.582 109.031 109 105.563 109 101.285C109 97.0065 112.582 93.5385 117 93.5385C121.418 93.5385 125 97.0065 125 101.285C125 105.563 121.418 109.031 117 109.031Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M53 140.015C48.5817 140.015 45 136.547 45 132.269C45 127.991 48.5817 124.523 53 124.523C57.4183 124.523 61 127.991 61 132.269C61 136.547 57.4183 140.015 53 140.015Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-11 109.031C-15.4183 109.031 -19 105.563 -19 101.285C-19 97.0065 -15.4183 93.5385 -11 93.5385C-6.58173 93.5385 -3 97.0065 -3 101.285C-3 105.563 -6.58172 109.031 -11 109.031Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M21 171C16.5817 171 13 167.532 13 163.254C13 158.976 16.5817 155.508 21 155.508C25.4183 155.508 29 158.976 29 163.254C29 167.532 25.4183 171 21 171Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M117 171C112.582 171 109 167.532 109 163.254C109 158.976 112.582 155.508 117 155.508C121.418 155.508 125 158.976 125 163.254C125 167.532 121.418 171 117 171Z" fill="#1D2977" fill-opacity="0.12" />
				<path d="M-43 171C-47.4183 171 -51 167.532 -51 163.254C-51 158.976 -47.4183 155.508 -43 155.508C-38.5817 155.508 -35 158.976 -35 163.254C-35 167.532 -38.5817 171 -43 171Z" fill="#1D2977" fill-opacity="0.12" />
			</svg>
		</section>
	</section>
<?php
endif;

wp_reset_postdata();
?>